/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacemetering.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterUsageRequest extends MarketplaceMeteringRequest implements
        ToCopyableBuilder<RegisterUsageRequest.Builder, RegisterUsageRequest> {
    private static final SdkField<String> PRODUCT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductCode").getter(getter(RegisterUsageRequest::productCode)).setter(setter(Builder::productCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").build()).build();

    private static final SdkField<Integer> PUBLIC_KEY_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PublicKeyVersion").getter(getter(RegisterUsageRequest::publicKeyVersion))
            .setter(setter(Builder::publicKeyVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeyVersion").build()).build();

    private static final SdkField<String> NONCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Nonce")
            .getter(getter(RegisterUsageRequest::nonce)).setter(setter(Builder::nonce))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Nonce").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_CODE_FIELD,
            PUBLIC_KEY_VERSION_FIELD, NONCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String productCode;

    private final Integer publicKeyVersion;

    private final String nonce;

    private RegisterUsageRequest(BuilderImpl builder) {
        super(builder);
        this.productCode = builder.productCode;
        this.publicKeyVersion = builder.publicKeyVersion;
        this.nonce = builder.nonce;
    }

    /**
     * <p>
     * Product code is used to uniquely identify a product in Amazon Web Services Marketplace. The product code should
     * be the same as the one used during the publishing of a new product.
     * </p>
     * 
     * @return Product code is used to uniquely identify a product in Amazon Web Services Marketplace. The product code
     *         should be the same as the one used during the publishing of a new product.
     */
    public final String productCode() {
        return productCode;
    }

    /**
     * <p>
     * Public Key Version provided by Amazon Web Services Marketplace
     * </p>
     * 
     * @return Public Key Version provided by Amazon Web Services Marketplace
     */
    public final Integer publicKeyVersion() {
        return publicKeyVersion;
    }

    /**
     * <p>
     * (Optional) To scope down the registration to a specific running software instance and guard against replay
     * attacks.
     * </p>
     * 
     * @return (Optional) To scope down the registration to a specific running software instance and guard against
     *         replay attacks.
     */
    public final String nonce() {
        return nonce;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(productCode());
        hashCode = 31 * hashCode + Objects.hashCode(publicKeyVersion());
        hashCode = 31 * hashCode + Objects.hashCode(nonce());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterUsageRequest)) {
            return false;
        }
        RegisterUsageRequest other = (RegisterUsageRequest) obj;
        return Objects.equals(productCode(), other.productCode()) && Objects.equals(publicKeyVersion(), other.publicKeyVersion())
                && Objects.equals(nonce(), other.nonce());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterUsageRequest").add("ProductCode", productCode())
                .add("PublicKeyVersion", publicKeyVersion()).add("Nonce", nonce()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductCode":
            return Optional.ofNullable(clazz.cast(productCode()));
        case "PublicKeyVersion":
            return Optional.ofNullable(clazz.cast(publicKeyVersion()));
        case "Nonce":
            return Optional.ofNullable(clazz.cast(nonce()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProductCode", PRODUCT_CODE_FIELD);
        map.put("PublicKeyVersion", PUBLIC_KEY_VERSION_FIELD);
        map.put("Nonce", NONCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterUsageRequest, T> g) {
        return obj -> g.apply((RegisterUsageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MarketplaceMeteringRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterUsageRequest> {
        /**
         * <p>
         * Product code is used to uniquely identify a product in Amazon Web Services Marketplace. The product code
         * should be the same as the one used during the publishing of a new product.
         * </p>
         * 
         * @param productCode
         *        Product code is used to uniquely identify a product in Amazon Web Services Marketplace. The product
         *        code should be the same as the one used during the publishing of a new product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCode(String productCode);

        /**
         * <p>
         * Public Key Version provided by Amazon Web Services Marketplace
         * </p>
         * 
         * @param publicKeyVersion
         *        Public Key Version provided by Amazon Web Services Marketplace
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeyVersion(Integer publicKeyVersion);

        /**
         * <p>
         * (Optional) To scope down the registration to a specific running software instance and guard against replay
         * attacks.
         * </p>
         * 
         * @param nonce
         *        (Optional) To scope down the registration to a specific running software instance and guard against
         *        replay attacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonce(String nonce);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MarketplaceMeteringRequest.BuilderImpl implements Builder {
        private String productCode;

        private Integer publicKeyVersion;

        private String nonce;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterUsageRequest model) {
            super(model);
            productCode(model.productCode);
            publicKeyVersion(model.publicKeyVersion);
            nonce(model.nonce);
        }

        public final String getProductCode() {
            return productCode;
        }

        public final void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        @Override
        public final Builder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        public final Integer getPublicKeyVersion() {
            return publicKeyVersion;
        }

        public final void setPublicKeyVersion(Integer publicKeyVersion) {
            this.publicKeyVersion = publicKeyVersion;
        }

        @Override
        public final Builder publicKeyVersion(Integer publicKeyVersion) {
            this.publicKeyVersion = publicKeyVersion;
            return this;
        }

        public final String getNonce() {
            return nonce;
        }

        public final void setNonce(String nonce) {
            this.nonce = nonce;
        }

        @Override
        public final Builder nonce(String nonce) {
            this.nonce = nonce;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterUsageRequest build() {
            return new RegisterUsageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
