/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacemetering;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.marketplacemetering.MarketplaceMeteringAsyncClient;
import software.amazon.awssdk.services.marketplacemetering.MarketplaceMeteringServiceClientConfiguration;
import software.amazon.awssdk.services.marketplacemetering.internal.MarketplaceMeteringServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.marketplacemetering.model.BatchMeterUsageRequest;
import software.amazon.awssdk.services.marketplacemetering.model.BatchMeterUsageResponse;
import software.amazon.awssdk.services.marketplacemetering.model.CustomerNotEntitledException;
import software.amazon.awssdk.services.marketplacemetering.model.DisabledApiException;
import software.amazon.awssdk.services.marketplacemetering.model.DuplicateRequestException;
import software.amazon.awssdk.services.marketplacemetering.model.ExpiredTokenException;
import software.amazon.awssdk.services.marketplacemetering.model.InternalServiceErrorException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidCustomerIdentifierException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidEndpointRegionException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidProductCodeException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidPublicKeyVersionException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidRegionException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidTagException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidTokenException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidUsageAllocationsException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidUsageDimensionException;
import software.amazon.awssdk.services.marketplacemetering.model.MarketplaceMeteringException;
import software.amazon.awssdk.services.marketplacemetering.model.MeterUsageRequest;
import software.amazon.awssdk.services.marketplacemetering.model.MeterUsageResponse;
import software.amazon.awssdk.services.marketplacemetering.model.PlatformNotSupportedException;
import software.amazon.awssdk.services.marketplacemetering.model.RegisterUsageRequest;
import software.amazon.awssdk.services.marketplacemetering.model.RegisterUsageResponse;
import software.amazon.awssdk.services.marketplacemetering.model.ResolveCustomerRequest;
import software.amazon.awssdk.services.marketplacemetering.model.ResolveCustomerResponse;
import software.amazon.awssdk.services.marketplacemetering.model.ThrottlingException;
import software.amazon.awssdk.services.marketplacemetering.model.TimestampOutOfBoundsException;
import software.amazon.awssdk.services.marketplacemetering.transform.BatchMeterUsageRequestMarshaller;
import software.amazon.awssdk.services.marketplacemetering.transform.MeterUsageRequestMarshaller;
import software.amazon.awssdk.services.marketplacemetering.transform.RegisterUsageRequestMarshaller;
import software.amazon.awssdk.services.marketplacemetering.transform.ResolveCustomerRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultMarketplaceMeteringAsyncClient
implements MarketplaceMeteringAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultMarketplaceMeteringAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMarketplaceMeteringAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Marketplace_Metering#2.34.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<BatchMeterUsageResponse> batchMeterUsage(BatchMeterUsageRequest batchMeterUsageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchMeterUsageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMarketplaceMeteringAsyncClient.resolveMetricPublishers(clientConfiguration, batchMeterUsageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Marketplace Metering");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchMeterUsage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchMeterUsageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidUsageAllocationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUsageAllocationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUsageAllocationsException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "ExpiredTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredTokenException::builder).build());
                    }
                    case "InvalidEndpointRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointRegionException::builder).build());
                    }
                    case "PlatformNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformNotSupportedException::builder).build());
                    }
                    case "TimestampOutOfBoundsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TimestampOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TimestampOutOfBoundsException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "InvalidUsageDimensionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUsageDimensionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUsageDimensionException::builder).build());
                    }
                    case "DuplicateRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "InvalidPublicKeyVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPublicKeyVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPublicKeyVersionException::builder).build());
                    }
                    case "InvalidRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "CustomerNotEntitledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomerNotEntitledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomerNotEntitledException::builder).build());
                    }
                    case "DisabledApiException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledApiException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledApiException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidCustomerIdentifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomerIdentifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCustomerIdentifierException::builder).build());
                    }
                    case "InvalidProductCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidProductCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidProductCodeException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchMeterUsage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchMeterUsageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchMeterUsageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMarketplaceMeteringAsyncClient.lambda$batchMeterUsage$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMarketplaceMeteringAsyncClient.lambda$batchMeterUsage$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<MeterUsageResponse> meterUsage(MeterUsageRequest meterUsageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)meterUsageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMarketplaceMeteringAsyncClient.resolveMetricPublishers(clientConfiguration, meterUsageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Marketplace Metering");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"MeterUsage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MeterUsageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidUsageAllocationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUsageAllocationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUsageAllocationsException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "ExpiredTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredTokenException::builder).build());
                    }
                    case "InvalidEndpointRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointRegionException::builder).build());
                    }
                    case "PlatformNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformNotSupportedException::builder).build());
                    }
                    case "TimestampOutOfBoundsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TimestampOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TimestampOutOfBoundsException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "InvalidUsageDimensionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUsageDimensionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUsageDimensionException::builder).build());
                    }
                    case "DuplicateRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "InvalidPublicKeyVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPublicKeyVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPublicKeyVersionException::builder).build());
                    }
                    case "InvalidRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "CustomerNotEntitledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomerNotEntitledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomerNotEntitledException::builder).build());
                    }
                    case "DisabledApiException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledApiException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledApiException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidCustomerIdentifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomerIdentifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCustomerIdentifierException::builder).build());
                    }
                    case "InvalidProductCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidProductCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidProductCodeException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("MeterUsage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new MeterUsageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)meterUsageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMarketplaceMeteringAsyncClient.lambda$meterUsage$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMarketplaceMeteringAsyncClient.lambda$meterUsage$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterUsageResponse> registerUsage(RegisterUsageRequest registerUsageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerUsageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMarketplaceMeteringAsyncClient.resolveMetricPublishers(clientConfiguration, registerUsageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Marketplace Metering");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterUsage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterUsageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidUsageAllocationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUsageAllocationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUsageAllocationsException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "ExpiredTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredTokenException::builder).build());
                    }
                    case "InvalidEndpointRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointRegionException::builder).build());
                    }
                    case "PlatformNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformNotSupportedException::builder).build());
                    }
                    case "TimestampOutOfBoundsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TimestampOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TimestampOutOfBoundsException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "InvalidUsageDimensionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUsageDimensionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUsageDimensionException::builder).build());
                    }
                    case "DuplicateRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "InvalidPublicKeyVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPublicKeyVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPublicKeyVersionException::builder).build());
                    }
                    case "InvalidRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "CustomerNotEntitledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomerNotEntitledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomerNotEntitledException::builder).build());
                    }
                    case "DisabledApiException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledApiException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledApiException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidCustomerIdentifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomerIdentifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCustomerIdentifierException::builder).build());
                    }
                    case "InvalidProductCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidProductCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidProductCodeException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterUsage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RegisterUsageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)registerUsageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMarketplaceMeteringAsyncClient.lambda$registerUsage$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMarketplaceMeteringAsyncClient.lambda$registerUsage$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ResolveCustomerResponse> resolveCustomer(ResolveCustomerRequest resolveCustomerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)resolveCustomerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMarketplaceMeteringAsyncClient.resolveMetricPublishers(clientConfiguration, resolveCustomerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Marketplace Metering");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResolveCustomer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResolveCustomerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidUsageAllocationsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUsageAllocationsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUsageAllocationsException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "InvalidTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                    }
                    case "ExpiredTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredTokenException::builder).build());
                    }
                    case "InvalidEndpointRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointRegionException::builder).build());
                    }
                    case "PlatformNotSupportedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PlatformNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PlatformNotSupportedException::builder).build());
                    }
                    case "TimestampOutOfBoundsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TimestampOutOfBoundsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TimestampOutOfBoundsException::builder).build());
                    }
                    case "InternalServiceErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
                    }
                    case "InvalidUsageDimensionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUsageDimensionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidUsageDimensionException::builder).build());
                    }
                    case "DuplicateRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "InvalidPublicKeyVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPublicKeyVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPublicKeyVersionException::builder).build());
                    }
                    case "InvalidRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRegionException::builder).build());
                    }
                    case "CustomerNotEntitledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomerNotEntitledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomerNotEntitledException::builder).build());
                    }
                    case "DisabledApiException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DisabledApiException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DisabledApiException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "InvalidCustomerIdentifierException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomerIdentifierException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCustomerIdentifierException::builder).build());
                    }
                    case "InvalidProductCodeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidProductCodeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidProductCodeException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResolveCustomer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ResolveCustomerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)resolveCustomerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMarketplaceMeteringAsyncClient.lambda$resolveCustomer$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMarketplaceMeteringAsyncClient.lambda$resolveCustomer$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final MarketplaceMeteringServiceClientConfiguration serviceClientConfiguration() {
        return new MarketplaceMeteringServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "aws-marketplace";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(MarketplaceMeteringException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        MarketplaceMeteringServiceClientConfigurationBuilder serviceConfigBuilder = new MarketplaceMeteringServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$resolveCustomer$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resolveCustomer$14(List metricPublishers, MetricCollector apiCallMetricCollector, ResolveCustomerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$registerUsage$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerUsage$10(List metricPublishers, MetricCollector apiCallMetricCollector, RegisterUsageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$meterUsage$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$meterUsage$6(List metricPublishers, MetricCollector apiCallMetricCollector, MeterUsageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchMeterUsage$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchMeterUsage$2(List metricPublishers, MetricCollector apiCallMetricCollector, BatchMeterUsageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

