/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The settings for a flow entitlement.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Entitlement implements SdkPojo, Serializable, ToCopyableBuilder<Entitlement.Builder, Entitlement> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Entitlement::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.<Encryption> builder(MarshallingType.SDK_POJO)
            .getter(getter(Entitlement::encryption)).setter(setter(Builder::encryption)).constructor(Encryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()).build();

    private static final SdkField<String> ENTITLEMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Entitlement::entitlementArn)).setter(setter(Builder::entitlementArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlementArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Entitlement::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> SUBSCRIBERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Entitlement::subscribers))
            .setter(setter(Builder::subscribers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            ENCRYPTION_FIELD, ENTITLEMENT_ARN_FIELD, NAME_FIELD, SUBSCRIBERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final Encryption encryption;

    private final String entitlementArn;

    private final String name;

    private final List<String> subscribers;

    private Entitlement(BuilderImpl builder) {
        this.description = builder.description;
        this.encryption = builder.encryption;
        this.entitlementArn = builder.entitlementArn;
        this.name = builder.name;
        this.subscribers = builder.subscribers;
    }

    /**
     * A description of the entitlement.
     * 
     * @return A description of the entitlement.
     */
    public String description() {
        return description;
    }

    /**
     * The type of encryption that will be used on the output that is associated with this entitlement.
     * 
     * @return The type of encryption that will be used on the output that is associated with this entitlement.
     */
    public Encryption encryption() {
        return encryption;
    }

    /**
     * The ARN of the entitlement.
     * 
     * @return The ARN of the entitlement.
     */
    public String entitlementArn() {
        return entitlementArn;
    }

    /**
     * The name of the entitlement.
     * 
     * @return The name of the entitlement.
     */
    public String name() {
        return name;
    }

    /**
     * The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be
     * allowed to create their own flow using your content as the source.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will
     *         be allowed to create their own flow using your content as the source.
     */
    public List<String> subscribers() {
        return subscribers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(entitlementArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(subscribers());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entitlement)) {
            return false;
        }
        Entitlement other = (Entitlement) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(encryption(), other.encryption())
                && Objects.equals(entitlementArn(), other.entitlementArn()) && Objects.equals(name(), other.name())
                && Objects.equals(subscribers(), other.subscribers());
    }

    @Override
    public String toString() {
        return ToString.builder("Entitlement").add("Description", description()).add("Encryption", encryption())
                .add("EntitlementArn", entitlementArn()).add("Name", name()).add("Subscribers", subscribers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "EntitlementArn":
            return Optional.ofNullable(clazz.cast(entitlementArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Subscribers":
            return Optional.ofNullable(clazz.cast(subscribers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Entitlement, T> g) {
        return obj -> g.apply((Entitlement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Entitlement> {
        /**
         * A description of the entitlement.
         * 
         * @param description
         *        A description of the entitlement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The type of encryption that will be used on the output that is associated with this entitlement.
         * 
         * @param encryption
         *        The type of encryption that will be used on the output that is associated with this entitlement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(Encryption encryption);

        /**
         * The type of encryption that will be used on the output that is associated with this entitlement. This is a
         * convenience that creates an instance of the {@link Encryption.Builder} avoiding the need to create one
         * manually via {@link Encryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link Encryption.Builder#build()} is called immediately and its result
         * is passed to {@link #encryption(Encryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link Encryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(Encryption)
         */
        default Builder encryption(Consumer<Encryption.Builder> encryption) {
            return encryption(Encryption.builder().applyMutation(encryption).build());
        }

        /**
         * The ARN of the entitlement.
         * 
         * @param entitlementArn
         *        The ARN of the entitlement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlementArn(String entitlementArn);

        /**
         * The name of the entitlement.
         * 
         * @param name
         *        The name of the entitlement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be
         * allowed to create their own flow using your content as the source.
         * 
         * @param subscribers
         *        The AWS account IDs that you want to share your content with. The receiving accounts (subscribers)
         *        will be allowed to create their own flow using your content as the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(Collection<String> subscribers);

        /**
         * The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be
         * allowed to create their own flow using your content as the source.
         * 
         * @param subscribers
         *        The AWS account IDs that you want to share your content with. The receiving accounts (subscribers)
         *        will be allowed to create their own flow using your content as the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(String... subscribers);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private Encryption encryption;

        private String entitlementArn;

        private String name;

        private List<String> subscribers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Entitlement model) {
            description(model.description);
            encryption(model.encryption);
            entitlementArn(model.entitlementArn);
            name(model.name);
            subscribers(model.subscribers);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Encryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final String getEntitlementArn() {
            return entitlementArn;
        }

        @Override
        public final Builder entitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
            return this;
        }

        public final void setEntitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getSubscribers() {
            return subscribers;
        }

        @Override
        public final Builder subscribers(Collection<String> subscribers) {
            this.subscribers = ___listOf__stringCopier.copy(subscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(String... subscribers) {
            subscribers(Arrays.asList(subscribers));
            return this;
        }

        public final void setSubscribers(Collection<String> subscribers) {
            this.subscribers = ___listOf__stringCopier.copy(subscribers);
        }

        @Override
        public Entitlement build() {
            return new Entitlement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
