/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The settings for a flow, including its source, outputs, and entitlements.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Flow implements SdkPojo, Serializable, ToCopyableBuilder<Flow.Builder, Flow> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Flow::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Flow::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> EGRESS_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Flow::egressIp)).setter(setter(Builder::egressIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressIp").build()).build();

    private static final SdkField<List<Entitlement>> ENTITLEMENTS_FIELD = SdkField
            .<List<Entitlement>> builder(MarshallingType.LIST)
            .getter(getter(Flow::entitlements))
            .setter(setter(Builder::entitlements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Entitlement> builder(MarshallingType.SDK_POJO)
                                            .constructor(Entitlement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Flow::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Flow::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<Output>> OUTPUTS_FIELD = SdkField
            .<List<Output>> builder(MarshallingType.LIST)
            .getter(getter(Flow::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Output> builder(MarshallingType.SDK_POJO)
                                            .constructor(Output::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Source> SOURCE_FIELD = SdkField.<Source> builder(MarshallingType.SDK_POJO)
            .getter(getter(Flow::source)).setter(setter(Builder::source)).constructor(Source::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Flow::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            DESCRIPTION_FIELD, EGRESS_IP_FIELD, ENTITLEMENTS_FIELD, FLOW_ARN_FIELD, NAME_FIELD, OUTPUTS_FIELD, SOURCE_FIELD,
            STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String availabilityZone;

    private final String description;

    private final String egressIp;

    private final List<Entitlement> entitlements;

    private final String flowArn;

    private final String name;

    private final List<Output> outputs;

    private final Source source;

    private final String status;

    private Flow(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.description = builder.description;
        this.egressIp = builder.egressIp;
        this.entitlements = builder.entitlements;
        this.flowArn = builder.flowArn;
        this.name = builder.name;
        this.outputs = builder.outputs;
        this.source = builder.source;
        this.status = builder.status;
    }

    /**
     * The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones
     * within the current AWS.
     * 
     * @return The Availability Zone that you want to create the flow in. These options are limited to the Availability
     *         Zones within the current AWS.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * A description of the flow. This value is not used or seen outside of the current AWS Elemental MediaConnect
     * account.
     * 
     * @return A description of the flow. This value is not used or seen outside of the current AWS Elemental
     *         MediaConnect account.
     */
    public String description() {
        return description;
    }

    /**
     * The IP address from which video will be sent to output destinations.
     * 
     * @return The IP address from which video will be sent to output destinations.
     */
    public String egressIp() {
        return egressIp;
    }

    /**
     * The entitlements in this flow.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The entitlements in this flow.
     */
    public List<Entitlement> entitlements() {
        return entitlements;
    }

    /**
     * The Amazon Resource Name (ARN), a unique identifier for any AWS resource, of the flow.
     * 
     * @return The Amazon Resource Name (ARN), a unique identifier for any AWS resource, of the flow.
     */
    public String flowArn() {
        return flowArn;
    }

    /**
     * The name of the flow.
     * 
     * @return The name of the flow.
     */
    public String name() {
        return name;
    }

    /**
     * The outputs in this flow.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The outputs in this flow.
     */
    public List<Output> outputs() {
        return outputs;
    }

    /**
     * Returns the value of the Source property for this object.
     * 
     * @return The value of the Source property for this object.
     */
    public Source source() {
        return source;
    }

    /**
     * The current status of the flow.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the flow.
     * @see Status
     */
    public Status status() {
        return Status.fromValue(status);
    }

    /**
     * The current status of the flow.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the flow.
     * @see Status
     */
    public String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(egressIp());
        hashCode = 31 * hashCode + Objects.hashCode(entitlements());
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(outputs());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Flow)) {
            return false;
        }
        Flow other = (Flow) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(description(), other.description())
                && Objects.equals(egressIp(), other.egressIp()) && Objects.equals(entitlements(), other.entitlements())
                && Objects.equals(flowArn(), other.flowArn()) && Objects.equals(name(), other.name())
                && Objects.equals(outputs(), other.outputs()) && Objects.equals(source(), other.source())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("Flow").add("AvailabilityZone", availabilityZone()).add("Description", description())
                .add("EgressIp", egressIp()).add("Entitlements", entitlements()).add("FlowArn", flowArn()).add("Name", name())
                .add("Outputs", outputs()).add("Source", source()).add("Status", statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EgressIp":
            return Optional.ofNullable(clazz.cast(egressIp()));
        case "Entitlements":
            return Optional.ofNullable(clazz.cast(entitlements()));
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Flow, T> g) {
        return obj -> g.apply((Flow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Flow> {
        /**
         * The Availability Zone that you want to create the flow in. These options are limited to the Availability
         * Zones within the current AWS.
         * 
         * @param availabilityZone
         *        The Availability Zone that you want to create the flow in. These options are limited to the
         *        Availability Zones within the current AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * A description of the flow. This value is not used or seen outside of the current AWS Elemental MediaConnect
         * account.
         * 
         * @param description
         *        A description of the flow. This value is not used or seen outside of the current AWS Elemental
         *        MediaConnect account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The IP address from which video will be sent to output destinations.
         * 
         * @param egressIp
         *        The IP address from which video will be sent to output destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressIp(String egressIp);

        /**
         * The entitlements in this flow.
         * 
         * @param entitlements
         *        The entitlements in this flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(Collection<Entitlement> entitlements);

        /**
         * The entitlements in this flow.
         * 
         * @param entitlements
         *        The entitlements in this flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(Entitlement... entitlements);

        /**
         * The entitlements in this flow. This is a convenience that creates an instance of the {@link List
         * <Entitlement>.Builder} avoiding the need to create one manually via {@link List<Entitlement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Entitlement>.Builder#build()} is called immediately and its
         * result is passed to {@link #entitlements(List<Entitlement>)}.
         * 
         * @param entitlements
         *        a consumer that will call methods on {@link List<Entitlement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entitlements(List<Entitlement>)
         */
        Builder entitlements(Consumer<Entitlement.Builder>... entitlements);

        /**
         * The Amazon Resource Name (ARN), a unique identifier for any AWS resource, of the flow.
         * 
         * @param flowArn
         *        The Amazon Resource Name (ARN), a unique identifier for any AWS resource, of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * The name of the flow.
         * 
         * @param name
         *        The name of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The outputs in this flow.
         * 
         * @param outputs
         *        The outputs in this flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<Output> outputs);

        /**
         * The outputs in this flow.
         * 
         * @param outputs
         *        The outputs in this flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Output... outputs);

        /**
         * The outputs in this flow. This is a convenience that creates an instance of the {@link List<Output>.Builder}
         * avoiding the need to create one manually via {@link List<Output>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Output>.Builder#build()} is called immediately and its
         * result is passed to {@link #outputs(List<Output>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on {@link List<Output>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(List<Output>)
         */
        Builder outputs(Consumer<Output.Builder>... outputs);

        /**
         * Sets the value of the Source property for this object.
         *
         * @param source
         *        The new value for the Source property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(Source source);

        /**
         * Sets the value of the Source property for this object.
         *
         * This is a convenience that creates an instance of the {@link Source.Builder} avoiding the need to create one
         * manually via {@link Source#builder()}.
         *
         * When the {@link Consumer} completes, {@link Source.Builder#build()} is called immediately and its result is
         * passed to {@link #source(Source)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(Source)
         */
        default Builder source(Consumer<Source.Builder> source) {
            return source(Source.builder().applyMutation(source).build());
        }

        /**
         * The current status of the flow.
         * 
         * @param status
         *        The current status of the flow.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * The current status of the flow.
         * 
         * @param status
         *        The current status of the flow.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String description;

        private String egressIp;

        private List<Entitlement> entitlements = DefaultSdkAutoConstructList.getInstance();

        private String flowArn;

        private String name;

        private List<Output> outputs = DefaultSdkAutoConstructList.getInstance();

        private Source source;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(Flow model) {
            availabilityZone(model.availabilityZone);
            description(model.description);
            egressIp(model.egressIp);
            entitlements(model.entitlements);
            flowArn(model.flowArn);
            name(model.name);
            outputs(model.outputs);
            source(model.source);
            status(model.status);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEgressIp() {
            return egressIp;
        }

        @Override
        public final Builder egressIp(String egressIp) {
            this.egressIp = egressIp;
            return this;
        }

        public final void setEgressIp(String egressIp) {
            this.egressIp = egressIp;
        }

        public final Collection<Entitlement.Builder> getEntitlements() {
            return entitlements != null ? entitlements.stream().map(Entitlement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entitlements(Collection<Entitlement> entitlements) {
            this.entitlements = ___listOfEntitlementCopier.copy(entitlements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Entitlement... entitlements) {
            entitlements(Arrays.asList(entitlements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Consumer<Entitlement.Builder>... entitlements) {
            entitlements(Stream.of(entitlements).map(c -> Entitlement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEntitlements(Collection<Entitlement.BuilderImpl> entitlements) {
            this.entitlements = ___listOfEntitlementCopier.copyFromBuilder(entitlements);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<Output.Builder> getOutputs() {
            return outputs != null ? outputs.stream().map(Output::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = ___listOfOutputCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<Output.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> Output.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = ___listOfOutputCopier.copyFromBuilder(outputs);
        }

        public final Source.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Flow build() {
            return new Flow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
