/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEntitlementsResponse extends MediaConnectResponse implements
        ToCopyableBuilder<ListEntitlementsResponse.Builder, ListEntitlementsResponse> {
    private static final SdkField<List<ListedEntitlement>> ENTITLEMENTS_FIELD = SdkField
            .<List<ListedEntitlement>> builder(MarshallingType.LIST)
            .getter(getter(ListEntitlementsResponse::entitlements))
            .setter(setter(Builder::entitlements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListedEntitlement> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListedEntitlement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListEntitlementsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITLEMENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ListedEntitlement> entitlements;

    private final String nextToken;

    private ListEntitlementsResponse(BuilderImpl builder) {
        super(builder);
        this.entitlements = builder.entitlements;
        this.nextToken = builder.nextToken;
    }

    /**
     * A list of entitlements that have been granted to you from other AWS accounts.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of entitlements that have been granted to you from other AWS accounts.
     */
    public List<ListedEntitlement> entitlements() {
        return entitlements;
    }

    /**
     * The token that identifies which batch of results that you want to see. For example, you submit a ListEntitlements
     * request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value.
     * To see the next batch of results, you can submit the ListEntitlements request a second time and specify the
     * NextToken value.
     * 
     * @return The token that identifies which batch of results that you want to see. For example, you submit a
     *         ListEntitlements request with MaxResults set at 5. The service returns the first batch of results (up to
     *         5) and a NextToken value. To see the next batch of results, you can submit the ListEntitlements request a
     *         second time and specify the NextToken value.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entitlements());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntitlementsResponse)) {
            return false;
        }
        ListEntitlementsResponse other = (ListEntitlementsResponse) obj;
        return Objects.equals(entitlements(), other.entitlements()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListEntitlementsResponse").add("Entitlements", entitlements()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Entitlements":
            return Optional.ofNullable(clazz.cast(entitlements()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEntitlementsResponse, T> g) {
        return obj -> g.apply((ListEntitlementsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEntitlementsResponse> {
        /**
         * A list of entitlements that have been granted to you from other AWS accounts.
         * 
         * @param entitlements
         *        A list of entitlements that have been granted to you from other AWS accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(Collection<ListedEntitlement> entitlements);

        /**
         * A list of entitlements that have been granted to you from other AWS accounts.
         * 
         * @param entitlements
         *        A list of entitlements that have been granted to you from other AWS accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(ListedEntitlement... entitlements);

        /**
         * A list of entitlements that have been granted to you from other AWS accounts. This is a convenience that
         * creates an instance of the {@link List<ListedEntitlement>.Builder} avoiding the need to create one manually
         * via {@link List<ListedEntitlement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ListedEntitlement>.Builder#build()} is called immediately
         * and its result is passed to {@link #entitlements(List<ListedEntitlement>)}.
         * 
         * @param entitlements
         *        a consumer that will call methods on {@link List<ListedEntitlement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entitlements(List<ListedEntitlement>)
         */
        Builder entitlements(Consumer<ListedEntitlement.Builder>... entitlements);

        /**
         * The token that identifies which batch of results that you want to see. For example, you submit a
         * ListEntitlements request with MaxResults set at 5. The service returns the first batch of results (up to 5)
         * and a NextToken value. To see the next batch of results, you can submit the ListEntitlements request a second
         * time and specify the NextToken value.
         * 
         * @param nextToken
         *        The token that identifies which batch of results that you want to see. For example, you submit a
         *        ListEntitlements request with MaxResults set at 5. The service returns the first batch of results (up
         *        to 5) and a NextToken value. To see the next batch of results, you can submit the ListEntitlements
         *        request a second time and specify the NextToken value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private List<ListedEntitlement> entitlements = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntitlementsResponse model) {
            super(model);
            entitlements(model.entitlements);
            nextToken(model.nextToken);
        }

        public final Collection<ListedEntitlement.Builder> getEntitlements() {
            return entitlements != null ? entitlements.stream().map(ListedEntitlement::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder entitlements(Collection<ListedEntitlement> entitlements) {
            this.entitlements = ___listOfListedEntitlementCopier.copy(entitlements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(ListedEntitlement... entitlements) {
            entitlements(Arrays.asList(entitlements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Consumer<ListedEntitlement.Builder>... entitlements) {
            entitlements(Stream.of(entitlements).map(c -> ListedEntitlement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEntitlements(Collection<ListedEntitlement.BuilderImpl> entitlements) {
            this.entitlements = ___listOfListedEntitlementCopier.copyFromBuilder(entitlements);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEntitlementsResponse build() {
            return new ListEntitlementsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
