/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Information about the encryption of the flow.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEncryption implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateEncryption.Builder, UpdateEncryption> {
    private static final SdkField<String> ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateEncryption::algorithmAsString)).setter(setter(Builder::algorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithm").build()).build();

    private static final SdkField<String> KEY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateEncryption::keyTypeAsString)).setter(setter(Builder::keyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyType").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateEncryption::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateEncryption::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_FIELD,
            KEY_TYPE_FIELD, ROLE_ARN_FIELD, SECRET_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String algorithm;

    private final String keyType;

    private final String roleArn;

    private final String secretArn;

    private UpdateEncryption(BuilderImpl builder) {
        this.algorithm = builder.algorithm;
        this.keyType = builder.keyType;
        this.roleArn = builder.roleArn;
        this.secretArn = builder.secretArn;
    }

    /**
     * The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #algorithm} will
     * return {@link Algorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #algorithmAsString}.
     * </p>
     * 
     * @return The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
     * @see Algorithm
     */
    public Algorithm algorithm() {
        return Algorithm.fromValue(algorithm);
    }

    /**
     * The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #algorithm} will
     * return {@link Algorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #algorithmAsString}.
     * </p>
     * 
     * @return The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
     * @see Algorithm
     */
    public String algorithmAsString() {
        return algorithm;
    }

    /**
     * The type of key that is used for the encryption. If no keyType is provided, the service will use the default
     * setting (static-key).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyType} will
     * return {@link KeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyTypeAsString}.
     * </p>
     * 
     * @return The type of key that is used for the encryption. If no keyType is provided, the service will use the
     *         default setting (static-key).
     * @see KeyType
     */
    public KeyType keyType() {
        return KeyType.fromValue(keyType);
    }

    /**
     * The type of key that is used for the encryption. If no keyType is provided, the service will use the default
     * setting (static-key).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyType} will
     * return {@link KeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyTypeAsString}.
     * </p>
     * 
     * @return The type of key that is used for the encryption. If no keyType is provided, the service will use the
     *         default setting (static-key).
     * @see KeyType
     */
    public String keyTypeAsString() {
        return keyType;
    }

    /**
     * The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted
     * entity).
     * 
     * @return The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a
     *         trusted entity).
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * The ARN that was assigned to the secret that you created in AWS Secrets Manager to store the encryption key.
     * 
     * @return The ARN that was assigned to the secret that you created in AWS Secrets Manager to store the encryption
     *         key.
     */
    public String secretArn() {
        return secretArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(algorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEncryption)) {
            return false;
        }
        UpdateEncryption other = (UpdateEncryption) obj;
        return Objects.equals(algorithmAsString(), other.algorithmAsString())
                && Objects.equals(keyTypeAsString(), other.keyTypeAsString()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(secretArn(), other.secretArn());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateEncryption").add("Algorithm", algorithmAsString()).add("KeyType", keyTypeAsString())
                .add("RoleArn", roleArn()).add("SecretArn", secretArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Algorithm":
            return Optional.ofNullable(clazz.cast(algorithmAsString()));
        case "KeyType":
            return Optional.ofNullable(clazz.cast(keyTypeAsString()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEncryption, T> g) {
        return obj -> g.apply((UpdateEncryption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateEncryption> {
        /**
         * The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
         * 
         * @param algorithm
         *        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
         * @see Algorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Algorithm
         */
        Builder algorithm(String algorithm);

        /**
         * The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
         * 
         * @param algorithm
         *        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
         * @see Algorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Algorithm
         */
        Builder algorithm(Algorithm algorithm);

        /**
         * The type of key that is used for the encryption. If no keyType is provided, the service will use the default
         * setting (static-key).
         * 
         * @param keyType
         *        The type of key that is used for the encryption. If no keyType is provided, the service will use the
         *        default setting (static-key).
         * @see KeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyType
         */
        Builder keyType(String keyType);

        /**
         * The type of key that is used for the encryption. If no keyType is provided, the service will use the default
         * setting (static-key).
         * 
         * @param keyType
         *        The type of key that is used for the encryption. If no keyType is provided, the service will use the
         *        default setting (static-key).
         * @see KeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyType
         */
        Builder keyType(KeyType keyType);

        /**
         * The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted
         * entity).
         * 
         * @param roleArn
         *        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a
         *        trusted entity).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * The ARN that was assigned to the secret that you created in AWS Secrets Manager to store the encryption key.
         * 
         * @param secretArn
         *        The ARN that was assigned to the secret that you created in AWS Secrets Manager to store the
         *        encryption key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);
    }

    static final class BuilderImpl implements Builder {
        private String algorithm;

        private String keyType;

        private String roleArn;

        private String secretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEncryption model) {
            algorithm(model.algorithm);
            keyType(model.keyType);
            roleArn(model.roleArn);
            secretArn(model.secretArn);
        }

        public final String getAlgorithm() {
            return algorithm;
        }

        @Override
        public final Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Override
        public final Builder algorithm(Algorithm algorithm) {
            this.algorithm(algorithm.toString());
            return this;
        }

        public final void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public final String getKeyType() {
            return keyType;
        }

        @Override
        public final Builder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        @Override
        public final Builder keyType(KeyType keyType) {
            this.keyType(keyType.toString());
            return this;
        }

        public final void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public UpdateEncryption build() {
            return new UpdateEncryption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
