/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to add outputs to the specified flow.
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddFlowOutputsRequest extends MediaConnectRequest implements
        ToCopyableBuilder<AddFlowOutputsRequest.Builder, AddFlowOutputsRequest> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddFlowOutputsRequest::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowArn").build()).build();

    private static final SdkField<List<AddOutputRequest>> OUTPUTS_FIELD = SdkField
            .<List<AddOutputRequest>> builder(MarshallingType.LIST)
            .getter(getter(AddFlowOutputsRequest::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddOutputRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddOutputRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(FLOW_ARN_FIELD, OUTPUTS_FIELD));

    private final String flowArn;

    private final List<AddOutputRequest> outputs;

    private AddFlowOutputsRequest(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.outputs = builder.outputs;
    }

    /**
     * The flow that you want to add outputs to.
     * 
     * @return The flow that you want to add outputs to.
     */
    public String flowArn() {
        return flowArn;
    }

    /**
     * A list of outputs that you want to add.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of outputs that you want to add.
     */
    public List<AddOutputRequest> outputs() {
        return outputs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(outputs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddFlowOutputsRequest)) {
            return false;
        }
        AddFlowOutputsRequest other = (AddFlowOutputsRequest) obj;
        return Objects.equals(flowArn(), other.flowArn()) && Objects.equals(outputs(), other.outputs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AddFlowOutputsRequest").add("FlowArn", flowArn()).add("Outputs", outputs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddFlowOutputsRequest, T> g) {
        return obj -> g.apply((AddFlowOutputsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddFlowOutputsRequest> {
        /**
         * The flow that you want to add outputs to.
         * 
         * @param flowArn
         *        The flow that you want to add outputs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * A list of outputs that you want to add.
         * 
         * @param outputs
         *        A list of outputs that you want to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<AddOutputRequest> outputs);

        /**
         * A list of outputs that you want to add.
         * 
         * @param outputs
         *        A list of outputs that you want to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(AddOutputRequest... outputs);

        /**
         * A list of outputs that you want to add. This is a convenience that creates an instance of the {@link List
         * <AddOutputRequest>.Builder} avoiding the need to create one manually via {@link List
         * <AddOutputRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AddOutputRequest>.Builder#build()} is called immediately and
         * its result is passed to {@link #outputs(List<AddOutputRequest>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on {@link List<AddOutputRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(List<AddOutputRequest>)
         */
        Builder outputs(Consumer<AddOutputRequest.Builder>... outputs);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConnectRequest.BuilderImpl implements Builder {
        private String flowArn;

        private List<AddOutputRequest> outputs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddFlowOutputsRequest model) {
            super(model);
            flowArn(model.flowArn);
            outputs(model.outputs);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        public final Collection<AddOutputRequest.Builder> getOutputs() {
            return outputs != null ? outputs.stream().map(AddOutputRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputs(Collection<AddOutputRequest> outputs) {
            this.outputs = ___listOfAddOutputRequestCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(AddOutputRequest... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<AddOutputRequest.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> AddOutputRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputs(Collection<AddOutputRequest.BuilderImpl> outputs) {
            this.outputs = ___listOfAddOutputRequestCopier.copyFromBuilder(outputs);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddFlowOutputsRequest build() {
            return new AddFlowOutputsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
