/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to grant entitlements on a flow.
 */
@Generated("software.amazon.awssdk:codegen")
public final class GrantFlowEntitlementsRequest extends MediaConnectRequest implements
        ToCopyableBuilder<GrantFlowEntitlementsRequest.Builder, GrantFlowEntitlementsRequest> {
    private static final SdkField<List<GrantEntitlementRequest>> ENTITLEMENTS_FIELD = SdkField
            .<List<GrantEntitlementRequest>> builder(MarshallingType.LIST)
            .getter(getter(GrantFlowEntitlementsRequest::entitlements))
            .setter(setter(Builder::entitlements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GrantEntitlementRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(GrantEntitlementRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GrantFlowEntitlementsRequest::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITLEMENTS_FIELD,
            FLOW_ARN_FIELD));

    private final List<GrantEntitlementRequest> entitlements;

    private final String flowArn;

    private GrantFlowEntitlementsRequest(BuilderImpl builder) {
        super(builder);
        this.entitlements = builder.entitlements;
        this.flowArn = builder.flowArn;
    }

    /**
     * The list of entitlements that you want to grant.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of entitlements that you want to grant.
     */
    public List<GrantEntitlementRequest> entitlements() {
        return entitlements;
    }

    /**
     * The flow that you want to grant entitlements on.
     * 
     * @return The flow that you want to grant entitlements on.
     */
    public String flowArn() {
        return flowArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(entitlements());
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrantFlowEntitlementsRequest)) {
            return false;
        }
        GrantFlowEntitlementsRequest other = (GrantFlowEntitlementsRequest) obj;
        return Objects.equals(entitlements(), other.entitlements()) && Objects.equals(flowArn(), other.flowArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GrantFlowEntitlementsRequest").add("Entitlements", entitlements()).add("FlowArn", flowArn())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Entitlements":
            return Optional.ofNullable(clazz.cast(entitlements()));
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GrantFlowEntitlementsRequest, T> g) {
        return obj -> g.apply((GrantFlowEntitlementsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, GrantFlowEntitlementsRequest> {
        /**
         * The list of entitlements that you want to grant.
         * 
         * @param entitlements
         *        The list of entitlements that you want to grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(Collection<GrantEntitlementRequest> entitlements);

        /**
         * The list of entitlements that you want to grant.
         * 
         * @param entitlements
         *        The list of entitlements that you want to grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(GrantEntitlementRequest... entitlements);

        /**
         * The list of entitlements that you want to grant. This is a convenience that creates an instance of the
         * {@link List<GrantEntitlementRequest>.Builder} avoiding the need to create one manually via {@link List
         * <GrantEntitlementRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GrantEntitlementRequest>.Builder#build()} is called
         * immediately and its result is passed to {@link #entitlements(List<GrantEntitlementRequest>)}.
         * 
         * @param entitlements
         *        a consumer that will call methods on {@link List<GrantEntitlementRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entitlements(List<GrantEntitlementRequest>)
         */
        Builder entitlements(Consumer<GrantEntitlementRequest.Builder>... entitlements);

        /**
         * The flow that you want to grant entitlements on.
         * 
         * @param flowArn
         *        The flow that you want to grant entitlements on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConnectRequest.BuilderImpl implements Builder {
        private List<GrantEntitlementRequest> entitlements = DefaultSdkAutoConstructList.getInstance();

        private String flowArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GrantFlowEntitlementsRequest model) {
            super(model);
            entitlements(model.entitlements);
            flowArn(model.flowArn);
        }

        public final Collection<GrantEntitlementRequest.Builder> getEntitlements() {
            return entitlements != null ? entitlements.stream().map(GrantEntitlementRequest::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entitlements(Collection<GrantEntitlementRequest> entitlements) {
            this.entitlements = ___listOfGrantEntitlementRequestCopier.copy(entitlements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(GrantEntitlementRequest... entitlements) {
            entitlements(Arrays.asList(entitlements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Consumer<GrantEntitlementRequest.Builder>... entitlements) {
            entitlements(Stream.of(entitlements).map(c -> GrantEntitlementRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEntitlements(Collection<GrantEntitlementRequest.BuilderImpl> entitlements) {
            this.entitlements = ___listOfGrantEntitlementRequestCopier.copyFromBuilder(entitlements);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GrantFlowEntitlementsRequest build() {
            return new GrantFlowEntitlementsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
