/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The entitlements that you want to grant on a flow.
 */
@Generated("software.amazon.awssdk:codegen")
public final class GrantEntitlementRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<GrantEntitlementRequest.Builder, GrantEntitlementRequest> {
    private static final SdkField<Integer> DATA_TRANSFER_SUBSCRIBER_FEE_PERCENT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DataTransferSubscriberFeePercent")
            .getter(getter(GrantEntitlementRequest::dataTransferSubscriberFeePercent))
            .setter(setter(Builder::dataTransferSubscriberFeePercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTransferSubscriberFeePercent")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GrantEntitlementRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.<Encryption> builder(MarshallingType.SDK_POJO)
            .memberName("Encryption").getter(getter(GrantEntitlementRequest::encryption)).setter(setter(Builder::encryption))
            .constructor(Encryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()).build();

    private static final SdkField<String> ENTITLEMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntitlementStatus").getter(getter(GrantEntitlementRequest::entitlementStatusAsString))
            .setter(setter(Builder::entitlementStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlementStatus").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GrantEntitlementRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> SUBSCRIBERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Subscribers")
            .getter(getter(GrantEntitlementRequest::subscribers))
            .setter(setter(Builder::subscribers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_TRANSFER_SUBSCRIBER_FEE_PERCENT_FIELD, DESCRIPTION_FIELD, ENCRYPTION_FIELD, ENTITLEMENT_STATUS_FIELD,
            NAME_FIELD, SUBSCRIBERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer dataTransferSubscriberFeePercent;

    private final String description;

    private final Encryption encryption;

    private final String entitlementStatus;

    private final String name;

    private final List<String> subscribers;

    private GrantEntitlementRequest(BuilderImpl builder) {
        this.dataTransferSubscriberFeePercent = builder.dataTransferSubscriberFeePercent;
        this.description = builder.description;
        this.encryption = builder.encryption;
        this.entitlementStatus = builder.entitlementStatus;
        this.name = builder.name;
        this.subscribers = builder.subscribers;
    }

    /**
     * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
     * 
     * @return Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
     */
    public Integer dataTransferSubscriberFeePercent() {
        return dataTransferSubscriberFeePercent;
    }

    /**
     * A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console and
     * will not be seen by the subscriber or end user.
     * 
     * @return A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console
     *         and will not be seen by the subscriber or end user.
     */
    public String description() {
        return description;
    }

    /**
     * The type of encryption that will be used on the output that is associated with this entitlement.
     * 
     * @return The type of encryption that will be used on the output that is associated with this entitlement.
     */
    public Encryption encryption() {
        return encryption;
    }

    /**
     * An indication of whether the new entitlement should be enabled or disabled as soon as it is created. If you don’t
     * specify the entitlementStatus field in your request, MediaConnect sets it to ENABLED.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entitlementStatus}
     * will return {@link EntitlementStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #entitlementStatusAsString}.
     * </p>
     * 
     * @return An indication of whether the new entitlement should be enabled or disabled as soon as it is created. If
     *         you don’t specify the entitlementStatus field in your request, MediaConnect sets it to ENABLED.
     * @see EntitlementStatus
     */
    public EntitlementStatus entitlementStatus() {
        return EntitlementStatus.fromValue(entitlementStatus);
    }

    /**
     * An indication of whether the new entitlement should be enabled or disabled as soon as it is created. If you don’t
     * specify the entitlementStatus field in your request, MediaConnect sets it to ENABLED.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entitlementStatus}
     * will return {@link EntitlementStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #entitlementStatusAsString}.
     * </p>
     * 
     * @return An indication of whether the new entitlement should be enabled or disabled as soon as it is created. If
     *         you don’t specify the entitlementStatus field in your request, MediaConnect sets it to ENABLED.
     * @see EntitlementStatus
     */
    public String entitlementStatusAsString() {
        return entitlementStatus;
    }

    /**
     * The name of the entitlement. This value must be unique within the current flow.
     * 
     * @return The name of the entitlement. This value must be unique within the current flow.
     */
    public String name() {
        return name;
    }

    /**
     * Returns true if the Subscribers property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSubscribers() {
        return subscribers != null && !(subscribers instanceof SdkAutoConstructList);
    }

    /**
     * The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be
     * allowed to create their own flows using your content as the source.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubscribers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will
     *         be allowed to create their own flows using your content as the source.
     */
    public List<String> subscribers() {
        return subscribers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataTransferSubscriberFeePercent());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(entitlementStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscribers() ? subscribers() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrantEntitlementRequest)) {
            return false;
        }
        GrantEntitlementRequest other = (GrantEntitlementRequest) obj;
        return Objects.equals(dataTransferSubscriberFeePercent(), other.dataTransferSubscriberFeePercent())
                && Objects.equals(description(), other.description()) && Objects.equals(encryption(), other.encryption())
                && Objects.equals(entitlementStatusAsString(), other.entitlementStatusAsString())
                && Objects.equals(name(), other.name()) && hasSubscribers() == other.hasSubscribers()
                && Objects.equals(subscribers(), other.subscribers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GrantEntitlementRequest")
                .add("DataTransferSubscriberFeePercent", dataTransferSubscriberFeePercent()).add("Description", description())
                .add("Encryption", encryption()).add("EntitlementStatus", entitlementStatusAsString()).add("Name", name())
                .add("Subscribers", hasSubscribers() ? subscribers() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataTransferSubscriberFeePercent":
            return Optional.ofNullable(clazz.cast(dataTransferSubscriberFeePercent()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "EntitlementStatus":
            return Optional.ofNullable(clazz.cast(entitlementStatusAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Subscribers":
            return Optional.ofNullable(clazz.cast(subscribers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GrantEntitlementRequest, T> g) {
        return obj -> g.apply((GrantEntitlementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GrantEntitlementRequest> {
        /**
         * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
         * 
         * @param dataTransferSubscriberFeePercent
         *        Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTransferSubscriberFeePercent(Integer dataTransferSubscriberFeePercent);

        /**
         * A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console and
         * will not be seen by the subscriber or end user.
         * 
         * @param description
         *        A description of the entitlement. This description appears only on the AWS Elemental MediaConnect
         *        console and will not be seen by the subscriber or end user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The type of encryption that will be used on the output that is associated with this entitlement.
         * 
         * @param encryption
         *        The type of encryption that will be used on the output that is associated with this entitlement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(Encryption encryption);

        /**
         * The type of encryption that will be used on the output that is associated with this entitlement. This is a
         * convenience that creates an instance of the {@link Encryption.Builder} avoiding the need to create one
         * manually via {@link Encryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link Encryption.Builder#build()} is called immediately and its result
         * is passed to {@link #encryption(Encryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link Encryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(Encryption)
         */
        default Builder encryption(Consumer<Encryption.Builder> encryption) {
            return encryption(Encryption.builder().applyMutation(encryption).build());
        }

        /**
         * An indication of whether the new entitlement should be enabled or disabled as soon as it is created. If you
         * don’t specify the entitlementStatus field in your request, MediaConnect sets it to ENABLED.
         * 
         * @param entitlementStatus
         *        An indication of whether the new entitlement should be enabled or disabled as soon as it is created.
         *        If you don’t specify the entitlementStatus field in your request, MediaConnect sets it to ENABLED.
         * @see EntitlementStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntitlementStatus
         */
        Builder entitlementStatus(String entitlementStatus);

        /**
         * An indication of whether the new entitlement should be enabled or disabled as soon as it is created. If you
         * don’t specify the entitlementStatus field in your request, MediaConnect sets it to ENABLED.
         * 
         * @param entitlementStatus
         *        An indication of whether the new entitlement should be enabled or disabled as soon as it is created.
         *        If you don’t specify the entitlementStatus field in your request, MediaConnect sets it to ENABLED.
         * @see EntitlementStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntitlementStatus
         */
        Builder entitlementStatus(EntitlementStatus entitlementStatus);

        /**
         * The name of the entitlement. This value must be unique within the current flow.
         * 
         * @param name
         *        The name of the entitlement. This value must be unique within the current flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be
         * allowed to create their own flows using your content as the source.
         * 
         * @param subscribers
         *        The AWS account IDs that you want to share your content with. The receiving accounts (subscribers)
         *        will be allowed to create their own flows using your content as the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(Collection<String> subscribers);

        /**
         * The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be
         * allowed to create their own flows using your content as the source.
         * 
         * @param subscribers
         *        The AWS account IDs that you want to share your content with. The receiving accounts (subscribers)
         *        will be allowed to create their own flows using your content as the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(String... subscribers);
    }

    static final class BuilderImpl implements Builder {
        private Integer dataTransferSubscriberFeePercent;

        private String description;

        private Encryption encryption;

        private String entitlementStatus;

        private String name;

        private List<String> subscribers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GrantEntitlementRequest model) {
            dataTransferSubscriberFeePercent(model.dataTransferSubscriberFeePercent);
            description(model.description);
            encryption(model.encryption);
            entitlementStatus(model.entitlementStatus);
            name(model.name);
            subscribers(model.subscribers);
        }

        public final Integer getDataTransferSubscriberFeePercent() {
            return dataTransferSubscriberFeePercent;
        }

        @Override
        public final Builder dataTransferSubscriberFeePercent(Integer dataTransferSubscriberFeePercent) {
            this.dataTransferSubscriberFeePercent = dataTransferSubscriberFeePercent;
            return this;
        }

        public final void setDataTransferSubscriberFeePercent(Integer dataTransferSubscriberFeePercent) {
            this.dataTransferSubscriberFeePercent = dataTransferSubscriberFeePercent;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Encryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final String getEntitlementStatus() {
            return entitlementStatus;
        }

        @Override
        public final Builder entitlementStatus(String entitlementStatus) {
            this.entitlementStatus = entitlementStatus;
            return this;
        }

        @Override
        public final Builder entitlementStatus(EntitlementStatus entitlementStatus) {
            this.entitlementStatus(entitlementStatus == null ? null : entitlementStatus.toString());
            return this;
        }

        public final void setEntitlementStatus(String entitlementStatus) {
            this.entitlementStatus = entitlementStatus;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getSubscribers() {
            if (subscribers instanceof SdkAutoConstructList) {
                return null;
            }
            return subscribers;
        }

        @Override
        public final Builder subscribers(Collection<String> subscribers) {
            this.subscribers = ___listOf__stringCopier.copy(subscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(String... subscribers) {
            subscribers(Arrays.asList(subscribers));
            return this;
        }

        public final void setSubscribers(Collection<String> subscribers) {
            this.subscribers = ___listOf__stringCopier.copy(subscribers);
        }

        @Override
        public GrantEntitlementRequest build() {
            return new GrantEntitlementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
