/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Provides a summary of a flow, including its ARN, Availability Zone, and source type.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListedFlow implements SdkPojo, Serializable, ToCopyableBuilder<ListedFlow.Builder, ListedFlow> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(ListedFlow::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ListedFlow::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(ListedFlow::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ListedFlow::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(ListedFlow::sourceTypeAsString)).setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListedFlow::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            DESCRIPTION_FIELD, FLOW_ARN_FIELD, NAME_FIELD, SOURCE_TYPE_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String availabilityZone;

    private final String description;

    private final String flowArn;

    private final String name;

    private final String sourceType;

    private final String status;

    private ListedFlow(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.description = builder.description;
        this.flowArn = builder.flowArn;
        this.name = builder.name;
        this.sourceType = builder.sourceType;
        this.status = builder.status;
    }

    /**
     * The Availability Zone that the flow was created in.
     * 
     * @return The Availability Zone that the flow was created in.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * A description of the flow.
     * 
     * @return A description of the flow.
     */
    public String description() {
        return description;
    }

    /**
     * The ARN of the flow.
     * 
     * @return The ARN of the flow.
     */
    public String flowArn() {
        return flowArn;
    }

    /**
     * The name of the flow.
     * 
     * @return The name of the flow.
     */
    public String name() {
        return name;
    }

    /**
     * The type of source. This value is either owned (originated somewhere other than an AWS Elemental MediaConnect
     * flow owned by another AWS account) or entitled (originated at an AWS Elemental MediaConnect flow owned by another
     * AWS account).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The type of source. This value is either owned (originated somewhere other than an AWS Elemental
     *         MediaConnect flow owned by another AWS account) or entitled (originated at an AWS Elemental MediaConnect
     *         flow owned by another AWS account).
     * @see SourceType
     */
    public SourceType sourceType() {
        return SourceType.fromValue(sourceType);
    }

    /**
     * The type of source. This value is either owned (originated somewhere other than an AWS Elemental MediaConnect
     * flow owned by another AWS account) or entitled (originated at an AWS Elemental MediaConnect flow owned by another
     * AWS account).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The type of source. This value is either owned (originated somewhere other than an AWS Elemental
     *         MediaConnect flow owned by another AWS account) or entitled (originated at an AWS Elemental MediaConnect
     *         flow owned by another AWS account).
     * @see SourceType
     */
    public String sourceTypeAsString() {
        return sourceType;
    }

    /**
     * The current status of the flow.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the flow.
     * @see Status
     */
    public Status status() {
        return Status.fromValue(status);
    }

    /**
     * The current status of the flow.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the flow.
     * @see Status
     */
    public String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedFlow)) {
            return false;
        }
        ListedFlow other = (ListedFlow) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(description(), other.description())
                && Objects.equals(flowArn(), other.flowArn()) && Objects.equals(name(), other.name())
                && Objects.equals(sourceTypeAsString(), other.sourceTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListedFlow").add("AvailabilityZone", availabilityZone()).add("Description", description())
                .add("FlowArn", flowArn()).add("Name", name()).add("SourceType", sourceTypeAsString())
                .add("Status", statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListedFlow, T> g) {
        return obj -> g.apply((ListedFlow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListedFlow> {
        /**
         * The Availability Zone that the flow was created in.
         * 
         * @param availabilityZone
         *        The Availability Zone that the flow was created in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * A description of the flow.
         * 
         * @param description
         *        A description of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The ARN of the flow.
         * 
         * @param flowArn
         *        The ARN of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * The name of the flow.
         * 
         * @param name
         *        The name of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The type of source. This value is either owned (originated somewhere other than an AWS Elemental MediaConnect
         * flow owned by another AWS account) or entitled (originated at an AWS Elemental MediaConnect flow owned by
         * another AWS account).
         * 
         * @param sourceType
         *        The type of source. This value is either owned (originated somewhere other than an AWS Elemental
         *        MediaConnect flow owned by another AWS account) or entitled (originated at an AWS Elemental
         *        MediaConnect flow owned by another AWS account).
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder sourceType(String sourceType);

        /**
         * The type of source. This value is either owned (originated somewhere other than an AWS Elemental MediaConnect
         * flow owned by another AWS account) or entitled (originated at an AWS Elemental MediaConnect flow owned by
         * another AWS account).
         * 
         * @param sourceType
         *        The type of source. This value is either owned (originated somewhere other than an AWS Elemental
         *        MediaConnect flow owned by another AWS account) or entitled (originated at an AWS Elemental
         *        MediaConnect flow owned by another AWS account).
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder sourceType(SourceType sourceType);

        /**
         * The current status of the flow.
         * 
         * @param status
         *        The current status of the flow.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * The current status of the flow.
         * 
         * @param status
         *        The current status of the flow.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String description;

        private String flowArn;

        private String name;

        private String sourceType;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedFlow model) {
            availabilityZone(model.availabilityZone);
            description(model.description);
            flowArn(model.flowArn);
            name(model.name);
            sourceType(model.sourceType);
            status(model.status);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getFlowArn() {
            return flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSourceType() {
            return sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public ListedFlow build() {
            return new ListedFlow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
