/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A definition of what is being billed for, including the type and amount.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceSpecification.Builder, ResourceSpecification> {
    private static final SdkField<Integer> RESERVED_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReservedBitrate").getter(getter(ResourceSpecification::reservedBitrate))
            .setter(setter(Builder::reservedBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservedBitrate").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ResourceSpecification::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_BITRATE_FIELD,
            RESOURCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer reservedBitrate;

    private final String resourceType;

    private ResourceSpecification(BuilderImpl builder) {
        this.reservedBitrate = builder.reservedBitrate;
        this.resourceType = builder.resourceType;
    }

    /**
     * The amount of outbound bandwidth that is discounted in the offering.
     * 
     * @return The amount of outbound bandwidth that is discounted in the offering.
     */
    public Integer reservedBitrate() {
        return reservedBitrate;
    }

    /**
     * The type of resource and the unit that is being billed for.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource and the unit that is being billed for.
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * The type of resource and the unit that is being billed for.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource and the unit that is being billed for.
     * @see ResourceType
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservedBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSpecification)) {
            return false;
        }
        ResourceSpecification other = (ResourceSpecification) obj;
        return Objects.equals(reservedBitrate(), other.reservedBitrate())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceSpecification").add("ReservedBitrate", reservedBitrate())
                .add("ResourceType", resourceTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedBitrate":
            return Optional.ofNullable(clazz.cast(reservedBitrate()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceSpecification, T> g) {
        return obj -> g.apply((ResourceSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceSpecification> {
        /**
         * The amount of outbound bandwidth that is discounted in the offering.
         * 
         * @param reservedBitrate
         *        The amount of outbound bandwidth that is discounted in the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedBitrate(Integer reservedBitrate);

        /**
         * The type of resource and the unit that is being billed for.
         * 
         * @param resourceType
         *        The type of resource and the unit that is being billed for.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * The type of resource and the unit that is being billed for.
         * 
         * @param resourceType
         *        The type of resource and the unit that is being billed for.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);
    }

    static final class BuilderImpl implements Builder {
        private Integer reservedBitrate;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSpecification model) {
            reservedBitrate(model.reservedBitrate);
            resourceType(model.resourceType);
        }

        public final Integer getReservedBitrate() {
            return reservedBitrate;
        }

        @Override
        public final Builder reservedBitrate(Integer reservedBitrate) {
            this.reservedBitrate = reservedBitrate;
            return this;
        }

        public final void setReservedBitrate(Integer reservedBitrate) {
            this.reservedBitrate = reservedBitrate;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public ResourceSpecification build() {
            return new ResourceSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
