/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The output that you want to add to this flow.
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddOutputRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<AddOutputRequest.Builder, AddOutputRequest> {
    private static final SdkField<List<String>> CIDR_ALLOW_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CidrAllowList")
            .getter(getter(AddOutputRequest::cidrAllowList))
            .setter(setter(Builder::cidrAllowList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidrAllowList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AddOutputRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Destination").getter(getter(AddOutputRequest::destination)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.<Encryption> builder(MarshallingType.SDK_POJO)
            .memberName("Encryption").getter(getter(AddOutputRequest::encryption)).setter(setter(Builder::encryption))
            .constructor(Encryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()).build();

    private static final SdkField<Integer> MAX_LATENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxLatency").getter(getter(AddOutputRequest::maxLatency)).setter(setter(Builder::maxLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLatency").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AddOutputRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(AddOutputRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(AddOutputRequest::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<String> REMOTE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RemoteId").getter(getter(AddOutputRequest::remoteId)).setter(setter(Builder::remoteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteId").build()).build();

    private static final SdkField<Integer> SMOOTHING_LATENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SmoothingLatency").getter(getter(AddOutputRequest::smoothingLatency))
            .setter(setter(Builder::smoothingLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smoothingLatency").build()).build();

    private static final SdkField<String> STREAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamId").getter(getter(AddOutputRequest::streamId)).setter(setter(Builder::streamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()).build();

    private static final SdkField<VpcInterfaceAttachment> VPC_INTERFACE_ATTACHMENT_FIELD = SdkField
            .<VpcInterfaceAttachment> builder(MarshallingType.SDK_POJO).memberName("VpcInterfaceAttachment")
            .getter(getter(AddOutputRequest::vpcInterfaceAttachment)).setter(setter(Builder::vpcInterfaceAttachment))
            .constructor(VpcInterfaceAttachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaceAttachment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_ALLOW_LIST_FIELD,
            DESCRIPTION_FIELD, DESTINATION_FIELD, ENCRYPTION_FIELD, MAX_LATENCY_FIELD, NAME_FIELD, PORT_FIELD, PROTOCOL_FIELD,
            REMOTE_ID_FIELD, SMOOTHING_LATENCY_FIELD, STREAM_ID_FIELD, VPC_INTERFACE_ATTACHMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> cidrAllowList;

    private final String description;

    private final String destination;

    private final Encryption encryption;

    private final Integer maxLatency;

    private final String name;

    private final Integer port;

    private final String protocol;

    private final String remoteId;

    private final Integer smoothingLatency;

    private final String streamId;

    private final VpcInterfaceAttachment vpcInterfaceAttachment;

    private AddOutputRequest(BuilderImpl builder) {
        this.cidrAllowList = builder.cidrAllowList;
        this.description = builder.description;
        this.destination = builder.destination;
        this.encryption = builder.encryption;
        this.maxLatency = builder.maxLatency;
        this.name = builder.name;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.remoteId = builder.remoteId;
        this.smoothingLatency = builder.smoothingLatency;
        this.streamId = builder.streamId;
        this.vpcInterfaceAttachment = builder.vpcInterfaceAttachment;
    }

    /**
     * Returns true if the CidrAllowList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCidrAllowList() {
        return cidrAllowList != null && !(cidrAllowList instanceof SdkAutoConstructList);
    }

    /**
     * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses
     * should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCidrAllowList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The range of IP addresses that should be allowed to initiate output requests to this flow. These IP
     *         addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example,
     *         10.0.0.0/16.
     */
    public List<String> cidrAllowList() {
        return cidrAllowList;
    }

    /**
     * A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not
     * be seen by the end user.
     * 
     * @return A description of the output. This description appears only on the AWS Elemental MediaConnect console and
     *         will not be seen by the end user.
     */
    public String description() {
        return description;
    }

    /**
     * The IP address from which video will be sent to output destinations.
     * 
     * @return The IP address from which video will be sent to output destinations.
     */
    public String destination() {
        return destination;
    }

    /**
     * The type of key used for the encryption. If no keyType is provided, the service will use the default setting
     * (static-key).
     * 
     * @return The type of key used for the encryption. If no keyType is provided, the service will use the default
     *         setting (static-key).
     */
    public Encryption encryption() {
        return encryption;
    }

    /**
     * The maximum latency in milliseconds for Zixi-based streams.
     * 
     * @return The maximum latency in milliseconds for Zixi-based streams.
     */
    public Integer maxLatency() {
        return maxLatency;
    }

    /**
     * The name of the output. This value must be unique within the current flow.
     * 
     * @return The name of the output. This value must be unique within the current flow.
     */
    public String name() {
        return name;
    }

    /**
     * The port to use when content is distributed to this output.
     * 
     * @return The port to use when content is distributed to this output.
     */
    public Integer port() {
        return port;
    }

    /**
     * The protocol to use for the output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol to use for the output.
     * @see Protocol
     */
    public Protocol protocol() {
        return Protocol.fromValue(protocol);
    }

    /**
     * The protocol to use for the output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol to use for the output.
     * @see Protocol
     */
    public String protocolAsString() {
        return protocol;
    }

    /**
     * The remote ID for the Zixi-pull output stream.
     * 
     * @return The remote ID for the Zixi-pull output stream.
     */
    public String remoteId() {
        return remoteId;
    }

    /**
     * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
     * 
     * @return The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
     */
    public Integer smoothingLatency() {
        return smoothingLatency;
    }

    /**
     * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
     * 
     * @return The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
     */
    public String streamId() {
        return streamId;
    }

    /**
     * The name of the VPC interface attachment to use for this output.
     * 
     * @return The name of the VPC interface attachment to use for this output.
     */
    public VpcInterfaceAttachment vpcInterfaceAttachment() {
        return vpcInterfaceAttachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCidrAllowList() ? cidrAllowList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(maxLatency());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(remoteId());
        hashCode = 31 * hashCode + Objects.hashCode(smoothingLatency());
        hashCode = 31 * hashCode + Objects.hashCode(streamId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcInterfaceAttachment());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddOutputRequest)) {
            return false;
        }
        AddOutputRequest other = (AddOutputRequest) obj;
        return hasCidrAllowList() == other.hasCidrAllowList() && Objects.equals(cidrAllowList(), other.cidrAllowList())
                && Objects.equals(description(), other.description()) && Objects.equals(destination(), other.destination())
                && Objects.equals(encryption(), other.encryption()) && Objects.equals(maxLatency(), other.maxLatency())
                && Objects.equals(name(), other.name()) && Objects.equals(port(), other.port())
                && Objects.equals(protocolAsString(), other.protocolAsString()) && Objects.equals(remoteId(), other.remoteId())
                && Objects.equals(smoothingLatency(), other.smoothingLatency()) && Objects.equals(streamId(), other.streamId())
                && Objects.equals(vpcInterfaceAttachment(), other.vpcInterfaceAttachment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AddOutputRequest").add("CidrAllowList", hasCidrAllowList() ? cidrAllowList() : null)
                .add("Description", description()).add("Destination", destination()).add("Encryption", encryption())
                .add("MaxLatency", maxLatency()).add("Name", name()).add("Port", port()).add("Protocol", protocolAsString())
                .add("RemoteId", remoteId()).add("SmoothingLatency", smoothingLatency()).add("StreamId", streamId())
                .add("VpcInterfaceAttachment", vpcInterfaceAttachment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrAllowList":
            return Optional.ofNullable(clazz.cast(cidrAllowList()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "MaxLatency":
            return Optional.ofNullable(clazz.cast(maxLatency()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "RemoteId":
            return Optional.ofNullable(clazz.cast(remoteId()));
        case "SmoothingLatency":
            return Optional.ofNullable(clazz.cast(smoothingLatency()));
        case "StreamId":
            return Optional.ofNullable(clazz.cast(streamId()));
        case "VpcInterfaceAttachment":
            return Optional.ofNullable(clazz.cast(vpcInterfaceAttachment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddOutputRequest, T> g) {
        return obj -> g.apply((AddOutputRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddOutputRequest> {
        /**
         * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses
         * should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         * 
         * @param cidrAllowList
         *        The range of IP addresses that should be allowed to initiate output requests to this flow. These IP
         *        addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example,
         *        10.0.0.0/16.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrAllowList(Collection<String> cidrAllowList);

        /**
         * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses
         * should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         * 
         * @param cidrAllowList
         *        The range of IP addresses that should be allowed to initiate output requests to this flow. These IP
         *        addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example,
         *        10.0.0.0/16.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrAllowList(String... cidrAllowList);

        /**
         * A description of the output. This description appears only on the AWS Elemental MediaConnect console and will
         * not be seen by the end user.
         * 
         * @param description
         *        A description of the output. This description appears only on the AWS Elemental MediaConnect console
         *        and will not be seen by the end user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The IP address from which video will be sent to output destinations.
         * 
         * @param destination
         *        The IP address from which video will be sent to output destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * The type of key used for the encryption. If no keyType is provided, the service will use the default setting
         * (static-key).
         * 
         * @param encryption
         *        The type of key used for the encryption. If no keyType is provided, the service will use the default
         *        setting (static-key).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(Encryption encryption);

        /**
         * The type of key used for the encryption. If no keyType is provided, the service will use the default setting
         * (static-key). This is a convenience that creates an instance of the {@link Encryption.Builder} avoiding the
         * need to create one manually via {@link Encryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link Encryption.Builder#build()} is called immediately and its result
         * is passed to {@link #encryption(Encryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link Encryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(Encryption)
         */
        default Builder encryption(Consumer<Encryption.Builder> encryption) {
            return encryption(Encryption.builder().applyMutation(encryption).build());
        }

        /**
         * The maximum latency in milliseconds for Zixi-based streams.
         * 
         * @param maxLatency
         *        The maximum latency in milliseconds for Zixi-based streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxLatency(Integer maxLatency);

        /**
         * The name of the output. This value must be unique within the current flow.
         * 
         * @param name
         *        The name of the output. This value must be unique within the current flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The port to use when content is distributed to this output.
         * 
         * @param port
         *        The port to use when content is distributed to this output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * The protocol to use for the output.
         * 
         * @param protocol
         *        The protocol to use for the output.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * The protocol to use for the output.
         * 
         * @param protocol
         *        The protocol to use for the output.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);

        /**
         * The remote ID for the Zixi-pull output stream.
         * 
         * @param remoteId
         *        The remote ID for the Zixi-pull output stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteId(String remoteId);

        /**
         * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
         * 
         * @param smoothingLatency
         *        The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smoothingLatency(Integer smoothingLatency);

        /**
         * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
         * 
         * @param streamId
         *        The stream ID that you want to use for this transport. This parameter applies only to Zixi-based
         *        streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamId(String streamId);

        /**
         * The name of the VPC interface attachment to use for this output.
         * 
         * @param vpcInterfaceAttachment
         *        The name of the VPC interface attachment to use for this output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcInterfaceAttachment(VpcInterfaceAttachment vpcInterfaceAttachment);

        /**
         * The name of the VPC interface attachment to use for this output. This is a convenience that creates an
         * instance of the {@link VpcInterfaceAttachment.Builder} avoiding the need to create one manually via
         * {@link VpcInterfaceAttachment#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcInterfaceAttachment.Builder#build()} is called immediately and
         * its result is passed to {@link #vpcInterfaceAttachment(VpcInterfaceAttachment)}.
         * 
         * @param vpcInterfaceAttachment
         *        a consumer that will call methods on {@link VpcInterfaceAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcInterfaceAttachment(VpcInterfaceAttachment)
         */
        default Builder vpcInterfaceAttachment(Consumer<VpcInterfaceAttachment.Builder> vpcInterfaceAttachment) {
            return vpcInterfaceAttachment(VpcInterfaceAttachment.builder().applyMutation(vpcInterfaceAttachment).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> cidrAllowList = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String destination;

        private Encryption encryption;

        private Integer maxLatency;

        private String name;

        private Integer port;

        private String protocol;

        private String remoteId;

        private Integer smoothingLatency;

        private String streamId;

        private VpcInterfaceAttachment vpcInterfaceAttachment;

        private BuilderImpl() {
        }

        private BuilderImpl(AddOutputRequest model) {
            cidrAllowList(model.cidrAllowList);
            description(model.description);
            destination(model.destination);
            encryption(model.encryption);
            maxLatency(model.maxLatency);
            name(model.name);
            port(model.port);
            protocol(model.protocol);
            remoteId(model.remoteId);
            smoothingLatency(model.smoothingLatency);
            streamId(model.streamId);
            vpcInterfaceAttachment(model.vpcInterfaceAttachment);
        }

        public final Collection<String> getCidrAllowList() {
            if (cidrAllowList instanceof SdkAutoConstructList) {
                return null;
            }
            return cidrAllowList;
        }

        @Override
        public final Builder cidrAllowList(Collection<String> cidrAllowList) {
            this.cidrAllowList = ___listOf__stringCopier.copy(cidrAllowList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrAllowList(String... cidrAllowList) {
            cidrAllowList(Arrays.asList(cidrAllowList));
            return this;
        }

        public final void setCidrAllowList(Collection<String> cidrAllowList) {
            this.cidrAllowList = ___listOf__stringCopier.copy(cidrAllowList);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDestination() {
            return destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final Encryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Integer getMaxLatency() {
            return maxLatency;
        }

        @Override
        public final Builder maxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
            return this;
        }

        public final void setMaxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getRemoteId() {
            return remoteId;
        }

        @Override
        public final Builder remoteId(String remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public final void setRemoteId(String remoteId) {
            this.remoteId = remoteId;
        }

        public final Integer getSmoothingLatency() {
            return smoothingLatency;
        }

        @Override
        public final Builder smoothingLatency(Integer smoothingLatency) {
            this.smoothingLatency = smoothingLatency;
            return this;
        }

        public final void setSmoothingLatency(Integer smoothingLatency) {
            this.smoothingLatency = smoothingLatency;
        }

        public final String getStreamId() {
            return streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public final VpcInterfaceAttachment.Builder getVpcInterfaceAttachment() {
            return vpcInterfaceAttachment != null ? vpcInterfaceAttachment.toBuilder() : null;
        }

        @Override
        public final Builder vpcInterfaceAttachment(VpcInterfaceAttachment vpcInterfaceAttachment) {
            this.vpcInterfaceAttachment = vpcInterfaceAttachment;
            return this;
        }

        public final void setVpcInterfaceAttachment(VpcInterfaceAttachment.BuilderImpl vpcInterfaceAttachment) {
            this.vpcInterfaceAttachment = vpcInterfaceAttachment != null ? vpcInterfaceAttachment.build() : null;
        }

        @Override
        public AddOutputRequest build() {
            return new AddOutputRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
