/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFlowResponse extends MediaConnectResponse implements
        ToCopyableBuilder<DescribeFlowResponse.Builder, DescribeFlowResponse> {
    private static final SdkField<Flow> FLOW_FIELD = SdkField.<Flow> builder(MarshallingType.SDK_POJO).memberName("Flow")
            .getter(getter(DescribeFlowResponse::flow)).setter(setter(Builder::flow)).constructor(Flow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flow").build()).build();

    private static final SdkField<Messages> MESSAGES_FIELD = SdkField.<Messages> builder(MarshallingType.SDK_POJO)
            .memberName("Messages").getter(getter(DescribeFlowResponse::messages)).setter(setter(Builder::messages))
            .constructor(Messages::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_FIELD, MESSAGES_FIELD));

    private final Flow flow;

    private final Messages messages;

    private DescribeFlowResponse(BuilderImpl builder) {
        super(builder);
        this.flow = builder.flow;
        this.messages = builder.messages;
    }

    /**
     * Returns the value of the Flow property for this object.
     * 
     * @return The value of the Flow property for this object.
     */
    public Flow flow() {
        return flow;
    }

    /**
     * Returns the value of the Messages property for this object.
     * 
     * @return The value of the Messages property for this object.
     */
    public Messages messages() {
        return messages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flow());
        hashCode = 31 * hashCode + Objects.hashCode(messages());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFlowResponse)) {
            return false;
        }
        DescribeFlowResponse other = (DescribeFlowResponse) obj;
        return Objects.equals(flow(), other.flow()) && Objects.equals(messages(), other.messages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeFlowResponse").add("Flow", flow()).add("Messages", messages()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Flow":
            return Optional.ofNullable(clazz.cast(flow()));
        case "Messages":
            return Optional.ofNullable(clazz.cast(messages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFlowResponse, T> g) {
        return obj -> g.apply((DescribeFlowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFlowResponse> {
        /**
         * Sets the value of the Flow property for this object.
         *
         * @param flow
         *        The new value for the Flow property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flow(Flow flow);

        /**
         * Sets the value of the Flow property for this object.
         *
         * This is a convenience that creates an instance of the {@link Flow.Builder} avoiding the need to create one
         * manually via {@link Flow#builder()}.
         *
         * When the {@link Consumer} completes, {@link Flow.Builder#build()} is called immediately and its result is
         * passed to {@link #flow(Flow)}.
         * 
         * @param flow
         *        a consumer that will call methods on {@link Flow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flow(Flow)
         */
        default Builder flow(Consumer<Flow.Builder> flow) {
            return flow(Flow.builder().applyMutation(flow).build());
        }

        /**
         * Sets the value of the Messages property for this object.
         *
         * @param messages
         *        The new value for the Messages property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Messages messages);

        /**
         * Sets the value of the Messages property for this object.
         *
         * This is a convenience that creates an instance of the {@link Messages.Builder} avoiding the need to create
         * one manually via {@link Messages#builder()}.
         *
         * When the {@link Consumer} completes, {@link Messages.Builder#build()} is called immediately and its result is
         * passed to {@link #messages(Messages)}.
         * 
         * @param messages
         *        a consumer that will call methods on {@link Messages.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messages(Messages)
         */
        default Builder messages(Consumer<Messages.Builder> messages) {
            return messages(Messages.builder().applyMutation(messages).build());
        }
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private Flow flow;

        private Messages messages;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFlowResponse model) {
            super(model);
            flow(model.flow);
            messages(model.messages);
        }

        public final Flow.Builder getFlow() {
            return flow != null ? flow.toBuilder() : null;
        }

        @Override
        public final Builder flow(Flow flow) {
            this.flow = flow;
            return this;
        }

        public final void setFlow(Flow.BuilderImpl flow) {
            this.flow = flow != null ? flow.build() : null;
        }

        public final Messages.Builder getMessages() {
            return messages != null ? messages.toBuilder() : null;
        }

        @Override
        public final Builder messages(Messages messages) {
            this.messages = messages;
            return this;
        }

        public final void setMessages(Messages.BuilderImpl messages) {
            this.messages = messages != null ? messages.build() : null;
        }

        @Override
        public DescribeFlowResponse build() {
            return new DescribeFlowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
