/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoveFlowVpcInterfaceResponse extends MediaConnectResponse implements
        ToCopyableBuilder<RemoveFlowVpcInterfaceResponse.Builder, RemoveFlowVpcInterfaceResponse> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(RemoveFlowVpcInterfaceResponse::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final SdkField<List<String>> NON_DELETED_NETWORK_INTERFACE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NonDeletedNetworkInterfaceIds")
            .getter(getter(RemoveFlowVpcInterfaceResponse::nonDeletedNetworkInterfaceIds))
            .setter(setter(Builder::nonDeletedNetworkInterfaceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nonDeletedNetworkInterfaceIds")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VPC_INTERFACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcInterfaceName").getter(getter(RemoveFlowVpcInterfaceResponse::vpcInterfaceName))
            .setter(setter(Builder::vpcInterfaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD,
            NON_DELETED_NETWORK_INTERFACE_IDS_FIELD, VPC_INTERFACE_NAME_FIELD));

    private final String flowArn;

    private final List<String> nonDeletedNetworkInterfaceIds;

    private final String vpcInterfaceName;

    private RemoveFlowVpcInterfaceResponse(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.nonDeletedNetworkInterfaceIds = builder.nonDeletedNetworkInterfaceIds;
        this.vpcInterfaceName = builder.vpcInterfaceName;
    }

    /**
     * The ARN of the flow that is associated with the VPC interface you removed.
     * 
     * @return The ARN of the flow that is associated with the VPC interface you removed.
     */
    public String flowArn() {
        return flowArn;
    }

    /**
     * Returns true if the NonDeletedNetworkInterfaceIds property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasNonDeletedNetworkInterfaceIds() {
        return nonDeletedNetworkInterfaceIds != null && !(nonDeletedNetworkInterfaceIds instanceof SdkAutoConstructList);
    }

    /**
     * IDs of network interfaces associated with the removed VPC interface that Media Connect was unable to remove.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNonDeletedNetworkInterfaceIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return IDs of network interfaces associated with the removed VPC interface that Media Connect was unable to
     *         remove.
     */
    public List<String> nonDeletedNetworkInterfaceIds() {
        return nonDeletedNetworkInterfaceIds;
    }

    /**
     * The name of the VPC interface that was removed.
     * 
     * @return The name of the VPC interface that was removed.
     */
    public String vpcInterfaceName() {
        return vpcInterfaceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasNonDeletedNetworkInterfaceIds() ? nonDeletedNetworkInterfaceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcInterfaceName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveFlowVpcInterfaceResponse)) {
            return false;
        }
        RemoveFlowVpcInterfaceResponse other = (RemoveFlowVpcInterfaceResponse) obj;
        return Objects.equals(flowArn(), other.flowArn())
                && hasNonDeletedNetworkInterfaceIds() == other.hasNonDeletedNetworkInterfaceIds()
                && Objects.equals(nonDeletedNetworkInterfaceIds(), other.nonDeletedNetworkInterfaceIds())
                && Objects.equals(vpcInterfaceName(), other.vpcInterfaceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString
                .builder("RemoveFlowVpcInterfaceResponse")
                .add("FlowArn", flowArn())
                .add("NonDeletedNetworkInterfaceIds", hasNonDeletedNetworkInterfaceIds() ? nonDeletedNetworkInterfaceIds() : null)
                .add("VpcInterfaceName", vpcInterfaceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "NonDeletedNetworkInterfaceIds":
            return Optional.ofNullable(clazz.cast(nonDeletedNetworkInterfaceIds()));
        case "VpcInterfaceName":
            return Optional.ofNullable(clazz.cast(vpcInterfaceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveFlowVpcInterfaceResponse, T> g) {
        return obj -> g.apply((RemoveFlowVpcInterfaceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RemoveFlowVpcInterfaceResponse> {
        /**
         * The ARN of the flow that is associated with the VPC interface you removed.
         * 
         * @param flowArn
         *        The ARN of the flow that is associated with the VPC interface you removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * IDs of network interfaces associated with the removed VPC interface that Media Connect was unable to remove.
         * 
         * @param nonDeletedNetworkInterfaceIds
         *        IDs of network interfaces associated with the removed VPC interface that Media Connect was unable to
         *        remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonDeletedNetworkInterfaceIds(Collection<String> nonDeletedNetworkInterfaceIds);

        /**
         * IDs of network interfaces associated with the removed VPC interface that Media Connect was unable to remove.
         * 
         * @param nonDeletedNetworkInterfaceIds
         *        IDs of network interfaces associated with the removed VPC interface that Media Connect was unable to
         *        remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonDeletedNetworkInterfaceIds(String... nonDeletedNetworkInterfaceIds);

        /**
         * The name of the VPC interface that was removed.
         * 
         * @param vpcInterfaceName
         *        The name of the VPC interface that was removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcInterfaceName(String vpcInterfaceName);
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private String flowArn;

        private List<String> nonDeletedNetworkInterfaceIds = DefaultSdkAutoConstructList.getInstance();

        private String vpcInterfaceName;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveFlowVpcInterfaceResponse model) {
            super(model);
            flowArn(model.flowArn);
            nonDeletedNetworkInterfaceIds(model.nonDeletedNetworkInterfaceIds);
            vpcInterfaceName(model.vpcInterfaceName);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        public final Collection<String> getNonDeletedNetworkInterfaceIds() {
            if (nonDeletedNetworkInterfaceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return nonDeletedNetworkInterfaceIds;
        }

        @Override
        public final Builder nonDeletedNetworkInterfaceIds(Collection<String> nonDeletedNetworkInterfaceIds) {
            this.nonDeletedNetworkInterfaceIds = ___listOf__stringCopier.copy(nonDeletedNetworkInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nonDeletedNetworkInterfaceIds(String... nonDeletedNetworkInterfaceIds) {
            nonDeletedNetworkInterfaceIds(Arrays.asList(nonDeletedNetworkInterfaceIds));
            return this;
        }

        public final void setNonDeletedNetworkInterfaceIds(Collection<String> nonDeletedNetworkInterfaceIds) {
            this.nonDeletedNetworkInterfaceIds = ___listOf__stringCopier.copy(nonDeletedNetworkInterfaceIds);
        }

        public final String getVpcInterfaceName() {
            return vpcInterfaceName;
        }

        @Override
        public final Builder vpcInterfaceName(String vpcInterfaceName) {
            this.vpcInterfaceName = vpcInterfaceName;
            return this;
        }

        public final void setVpcInterfaceName(String vpcInterfaceName) {
            this.vpcInterfaceName = vpcInterfaceName;
        }

        @Override
        public RemoveFlowVpcInterfaceResponse build() {
            return new RemoveFlowVpcInterfaceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
