/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The settings for the source of the flow.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Source implements SdkPojo, Serializable, ToCopyableBuilder<Source.Builder, Source> {
    private static final SdkField<Integer> DATA_TRANSFER_SUBSCRIBER_FEE_PERCENT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DataTransferSubscriberFeePercent")
            .getter(getter(Source::dataTransferSubscriberFeePercent))
            .setter(setter(Builder::dataTransferSubscriberFeePercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTransferSubscriberFeePercent")
                    .build()).build();

    private static final SdkField<Encryption> DECRYPTION_FIELD = SdkField.<Encryption> builder(MarshallingType.SDK_POJO)
            .memberName("Decryption").getter(getter(Source::decryption)).setter(setter(Builder::decryption))
            .constructor(Encryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decryption").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Source::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENTITLEMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntitlementArn").getter(getter(Source::entitlementArn)).setter(setter(Builder::entitlementArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlementArn").build()).build();

    private static final SdkField<String> INGEST_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IngestIp").getter(getter(Source::ingestIp)).setter(setter(Builder::ingestIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestIp").build()).build();

    private static final SdkField<Integer> INGEST_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("IngestPort").getter(getter(Source::ingestPort)).setter(setter(Builder::ingestPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestPort").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Source::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceArn").getter(getter(Source::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceArn").build()).build();

    private static final SdkField<Transport> TRANSPORT_FIELD = SdkField.<Transport> builder(MarshallingType.SDK_POJO)
            .memberName("Transport").getter(getter(Source::transport)).setter(setter(Builder::transport))
            .constructor(Transport::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transport").build()).build();

    private static final SdkField<String> VPC_INTERFACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcInterfaceName").getter(getter(Source::vpcInterfaceName)).setter(setter(Builder::vpcInterfaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaceName").build()).build();

    private static final SdkField<String> WHITELIST_CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WhitelistCidr").getter(getter(Source::whitelistCidr)).setter(setter(Builder::whitelistCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("whitelistCidr").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_TRANSFER_SUBSCRIBER_FEE_PERCENT_FIELD, DECRYPTION_FIELD, DESCRIPTION_FIELD, ENTITLEMENT_ARN_FIELD,
            INGEST_IP_FIELD, INGEST_PORT_FIELD, NAME_FIELD, SOURCE_ARN_FIELD, TRANSPORT_FIELD, VPC_INTERFACE_NAME_FIELD,
            WHITELIST_CIDR_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer dataTransferSubscriberFeePercent;

    private final Encryption decryption;

    private final String description;

    private final String entitlementArn;

    private final String ingestIp;

    private final Integer ingestPort;

    private final String name;

    private final String sourceArn;

    private final Transport transport;

    private final String vpcInterfaceName;

    private final String whitelistCidr;

    private Source(BuilderImpl builder) {
        this.dataTransferSubscriberFeePercent = builder.dataTransferSubscriberFeePercent;
        this.decryption = builder.decryption;
        this.description = builder.description;
        this.entitlementArn = builder.entitlementArn;
        this.ingestIp = builder.ingestIp;
        this.ingestPort = builder.ingestPort;
        this.name = builder.name;
        this.sourceArn = builder.sourceArn;
        this.transport = builder.transport;
        this.vpcInterfaceName = builder.vpcInterfaceName;
        this.whitelistCidr = builder.whitelistCidr;
    }

    /**
     * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
     * 
     * @return Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
     */
    public Integer dataTransferSubscriberFeePercent() {
        return dataTransferSubscriberFeePercent;
    }

    /**
     * The type of encryption that is used on the content ingested from this source.
     * 
     * @return The type of encryption that is used on the content ingested from this source.
     */
    public Encryption decryption() {
        return decryption;
    }

    /**
     * A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect
     * account.
     * 
     * @return A description for the source. This value is not used or seen outside of the current AWS Elemental
     *         MediaConnect account.
     */
    public String description() {
        return description;
    }

    /**
     * The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The
     * entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
     * 
     * @return The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account.
     *         The entitlement is set by the content originator and the ARN is generated as part of the originator's
     *         flow.
     */
    public String entitlementArn() {
        return entitlementArn;
    }

    /**
     * The IP address that the flow will be listening on for incoming content.
     * 
     * @return The IP address that the flow will be listening on for incoming content.
     */
    public String ingestIp() {
        return ingestIp;
    }

    /**
     * The port that the flow will be listening on for incoming content.
     * 
     * @return The port that the flow will be listening on for incoming content.
     */
    public Integer ingestPort() {
        return ingestPort;
    }

    /**
     * The name of the source.
     * 
     * @return The name of the source.
     */
    public String name() {
        return name;
    }

    /**
     * The ARN of the source.
     * 
     * @return The ARN of the source.
     */
    public String sourceArn() {
        return sourceArn;
    }

    /**
     * Attributes related to the transport stream that are used in the source.
     * 
     * @return Attributes related to the transport stream that are used in the source.
     */
    public Transport transport() {
        return transport;
    }

    /**
     * The name of the VPC Interface this Source is configured with.
     * 
     * @return The name of the VPC Interface this Source is configured with.
     */
    public String vpcInterfaceName() {
        return vpcInterfaceName;
    }

    /**
     * The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should
     * be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     * 
     * @return The range of IP addresses that should be allowed to contribute content to your source. These IP addresses
     *         should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     */
    public String whitelistCidr() {
        return whitelistCidr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataTransferSubscriberFeePercent());
        hashCode = 31 * hashCode + Objects.hashCode(decryption());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(entitlementArn());
        hashCode = 31 * hashCode + Objects.hashCode(ingestIp());
        hashCode = 31 * hashCode + Objects.hashCode(ingestPort());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(transport());
        hashCode = 31 * hashCode + Objects.hashCode(vpcInterfaceName());
        hashCode = 31 * hashCode + Objects.hashCode(whitelistCidr());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source) obj;
        return Objects.equals(dataTransferSubscriberFeePercent(), other.dataTransferSubscriberFeePercent())
                && Objects.equals(decryption(), other.decryption()) && Objects.equals(description(), other.description())
                && Objects.equals(entitlementArn(), other.entitlementArn()) && Objects.equals(ingestIp(), other.ingestIp())
                && Objects.equals(ingestPort(), other.ingestPort()) && Objects.equals(name(), other.name())
                && Objects.equals(sourceArn(), other.sourceArn()) && Objects.equals(transport(), other.transport())
                && Objects.equals(vpcInterfaceName(), other.vpcInterfaceName())
                && Objects.equals(whitelistCidr(), other.whitelistCidr());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Source").add("DataTransferSubscriberFeePercent", dataTransferSubscriberFeePercent())
                .add("Decryption", decryption()).add("Description", description()).add("EntitlementArn", entitlementArn())
                .add("IngestIp", ingestIp()).add("IngestPort", ingestPort()).add("Name", name()).add("SourceArn", sourceArn())
                .add("Transport", transport()).add("VpcInterfaceName", vpcInterfaceName()).add("WhitelistCidr", whitelistCidr())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataTransferSubscriberFeePercent":
            return Optional.ofNullable(clazz.cast(dataTransferSubscriberFeePercent()));
        case "Decryption":
            return Optional.ofNullable(clazz.cast(decryption()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EntitlementArn":
            return Optional.ofNullable(clazz.cast(entitlementArn()));
        case "IngestIp":
            return Optional.ofNullable(clazz.cast(ingestIp()));
        case "IngestPort":
            return Optional.ofNullable(clazz.cast(ingestPort()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "Transport":
            return Optional.ofNullable(clazz.cast(transport()));
        case "VpcInterfaceName":
            return Optional.ofNullable(clazz.cast(vpcInterfaceName()));
        case "WhitelistCidr":
            return Optional.ofNullable(clazz.cast(whitelistCidr()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Source, T> g) {
        return obj -> g.apply((Source) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Source> {
        /**
         * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
         * 
         * @param dataTransferSubscriberFeePercent
         *        Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTransferSubscriberFeePercent(Integer dataTransferSubscriberFeePercent);

        /**
         * The type of encryption that is used on the content ingested from this source.
         * 
         * @param decryption
         *        The type of encryption that is used on the content ingested from this source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decryption(Encryption decryption);

        /**
         * The type of encryption that is used on the content ingested from this source. This is a convenience that
         * creates an instance of the {@link Encryption.Builder} avoiding the need to create one manually via
         * {@link Encryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link Encryption.Builder#build()} is called immediately and its result
         * is passed to {@link #decryption(Encryption)}.
         * 
         * @param decryption
         *        a consumer that will call methods on {@link Encryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #decryption(Encryption)
         */
        default Builder decryption(Consumer<Encryption.Builder> decryption) {
            return decryption(Encryption.builder().applyMutation(decryption).build());
        }

        /**
         * A description for the source. This value is not used or seen outside of the current AWS Elemental
         * MediaConnect account.
         * 
         * @param description
         *        A description for the source. This value is not used or seen outside of the current AWS Elemental
         *        MediaConnect account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The
         * entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
         * 
         * @param entitlementArn
         *        The ARN of the entitlement that allows you to subscribe to content that comes from another AWS
         *        account. The entitlement is set by the content originator and the ARN is generated as part of the
         *        originator's flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlementArn(String entitlementArn);

        /**
         * The IP address that the flow will be listening on for incoming content.
         * 
         * @param ingestIp
         *        The IP address that the flow will be listening on for incoming content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestIp(String ingestIp);

        /**
         * The port that the flow will be listening on for incoming content.
         * 
         * @param ingestPort
         *        The port that the flow will be listening on for incoming content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestPort(Integer ingestPort);

        /**
         * The name of the source.
         * 
         * @param name
         *        The name of the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The ARN of the source.
         * 
         * @param sourceArn
         *        The ARN of the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * Attributes related to the transport stream that are used in the source.
         * 
         * @param transport
         *        Attributes related to the transport stream that are used in the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transport(Transport transport);

        /**
         * Attributes related to the transport stream that are used in the source. This is a convenience that creates an
         * instance of the {@link Transport.Builder} avoiding the need to create one manually via
         * {@link Transport#builder()}.
         *
         * When the {@link Consumer} completes, {@link Transport.Builder#build()} is called immediately and its result
         * is passed to {@link #transport(Transport)}.
         * 
         * @param transport
         *        a consumer that will call methods on {@link Transport.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transport(Transport)
         */
        default Builder transport(Consumer<Transport.Builder> transport) {
            return transport(Transport.builder().applyMutation(transport).build());
        }

        /**
         * The name of the VPC Interface this Source is configured with.
         * 
         * @param vpcInterfaceName
         *        The name of the VPC Interface this Source is configured with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcInterfaceName(String vpcInterfaceName);

        /**
         * The range of IP addresses that should be allowed to contribute content to your source. These IP addresses
         * should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         * 
         * @param whitelistCidr
         *        The range of IP addresses that should be allowed to contribute content to your source. These IP
         *        addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example,
         *        10.0.0.0/16.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whitelistCidr(String whitelistCidr);
    }

    static final class BuilderImpl implements Builder {
        private Integer dataTransferSubscriberFeePercent;

        private Encryption decryption;

        private String description;

        private String entitlementArn;

        private String ingestIp;

        private Integer ingestPort;

        private String name;

        private String sourceArn;

        private Transport transport;

        private String vpcInterfaceName;

        private String whitelistCidr;

        private BuilderImpl() {
        }

        private BuilderImpl(Source model) {
            dataTransferSubscriberFeePercent(model.dataTransferSubscriberFeePercent);
            decryption(model.decryption);
            description(model.description);
            entitlementArn(model.entitlementArn);
            ingestIp(model.ingestIp);
            ingestPort(model.ingestPort);
            name(model.name);
            sourceArn(model.sourceArn);
            transport(model.transport);
            vpcInterfaceName(model.vpcInterfaceName);
            whitelistCidr(model.whitelistCidr);
        }

        public final Integer getDataTransferSubscriberFeePercent() {
            return dataTransferSubscriberFeePercent;
        }

        @Override
        public final Builder dataTransferSubscriberFeePercent(Integer dataTransferSubscriberFeePercent) {
            this.dataTransferSubscriberFeePercent = dataTransferSubscriberFeePercent;
            return this;
        }

        public final void setDataTransferSubscriberFeePercent(Integer dataTransferSubscriberFeePercent) {
            this.dataTransferSubscriberFeePercent = dataTransferSubscriberFeePercent;
        }

        public final Encryption.Builder getDecryption() {
            return decryption != null ? decryption.toBuilder() : null;
        }

        @Override
        public final Builder decryption(Encryption decryption) {
            this.decryption = decryption;
            return this;
        }

        public final void setDecryption(Encryption.BuilderImpl decryption) {
            this.decryption = decryption != null ? decryption.build() : null;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEntitlementArn() {
            return entitlementArn;
        }

        @Override
        public final Builder entitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
            return this;
        }

        public final void setEntitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
        }

        public final String getIngestIp() {
            return ingestIp;
        }

        @Override
        public final Builder ingestIp(String ingestIp) {
            this.ingestIp = ingestIp;
            return this;
        }

        public final void setIngestIp(String ingestIp) {
            this.ingestIp = ingestIp;
        }

        public final Integer getIngestPort() {
            return ingestPort;
        }

        @Override
        public final Builder ingestPort(Integer ingestPort) {
            this.ingestPort = ingestPort;
            return this;
        }

        public final void setIngestPort(Integer ingestPort) {
            this.ingestPort = ingestPort;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final Transport.Builder getTransport() {
            return transport != null ? transport.toBuilder() : null;
        }

        @Override
        public final Builder transport(Transport transport) {
            this.transport = transport;
            return this;
        }

        public final void setTransport(Transport.BuilderImpl transport) {
            this.transport = transport != null ? transport.build() : null;
        }

        public final String getVpcInterfaceName() {
            return vpcInterfaceName;
        }

        @Override
        public final Builder vpcInterfaceName(String vpcInterfaceName) {
            this.vpcInterfaceName = vpcInterfaceName;
            return this;
        }

        public final void setVpcInterfaceName(String vpcInterfaceName) {
            this.vpcInterfaceName = vpcInterfaceName;
        }

        public final String getWhitelistCidr() {
            return whitelistCidr;
        }

        @Override
        public final Builder whitelistCidr(String whitelistCidr) {
            this.whitelistCidr = whitelistCidr;
            return this;
        }

        public final void setWhitelistCidr(String whitelistCidr) {
            this.whitelistCidr = whitelistCidr;
        }

        @Override
        public Source build() {
            return new Source(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
