/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFlowsResponse extends MediaConnectResponse implements
        ToCopyableBuilder<ListFlowsResponse.Builder, ListFlowsResponse> {
    private static final SdkField<List<ListedFlow>> FLOWS_FIELD = SdkField
            .<List<ListedFlow>> builder(MarshallingType.LIST)
            .memberName("Flows")
            .getter(getter(ListFlowsResponse::flows))
            .setter(setter(Builder::flows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListedFlow> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListedFlow::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFlowsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(FLOWS_FIELD, NEXT_TOKEN_FIELD));

    private final List<ListedFlow> flows;

    private final String nextToken;

    private ListFlowsResponse(BuilderImpl builder) {
        super(builder);
        this.flows = builder.flows;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Flows property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFlows() {
        return flows != null && !(flows instanceof SdkAutoConstructList);
    }

    /**
     * A list of flow summaries.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFlows()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of flow summaries.
     */
    public final List<ListedFlow> flows() {
        return flows;
    }

    /**
     * The token that identifies which batch of results that you want to see. For example, you submit a ListFlows
     * request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value.
     * To see the next batch of results, you can submit the ListFlows request a second time and specify the NextToken
     * value.
     * 
     * @return The token that identifies which batch of results that you want to see. For example, you submit a
     *         ListFlows request with MaxResults set at 5. The service returns the first batch of results (up to 5) and
     *         a NextToken value. To see the next batch of results, you can submit the ListFlows request a second time
     *         and specify the NextToken value.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFlows() ? flows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFlowsResponse)) {
            return false;
        }
        ListFlowsResponse other = (ListFlowsResponse) obj;
        return hasFlows() == other.hasFlows() && Objects.equals(flows(), other.flows())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFlowsResponse").add("Flows", hasFlows() ? flows() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Flows":
            return Optional.ofNullable(clazz.cast(flows()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFlowsResponse, T> g) {
        return obj -> g.apply((ListFlowsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFlowsResponse> {
        /**
         * A list of flow summaries.
         * 
         * @param flows
         *        A list of flow summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flows(Collection<ListedFlow> flows);

        /**
         * A list of flow summaries.
         * 
         * @param flows
         *        A list of flow summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flows(ListedFlow... flows);

        /**
         * A list of flow summaries. This is a convenience that creates an instance of the {@link List
         * <ListedFlow>.Builder} avoiding the need to create one manually via {@link List<ListedFlow>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ListedFlow>.Builder#build()} is called immediately and its
         * result is passed to {@link #flows(List<ListedFlow>)}.
         * 
         * @param flows
         *        a consumer that will call methods on {@link List<ListedFlow>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flows(List<ListedFlow>)
         */
        Builder flows(Consumer<ListedFlow.Builder>... flows);

        /**
         * The token that identifies which batch of results that you want to see. For example, you submit a ListFlows
         * request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken
         * value. To see the next batch of results, you can submit the ListFlows request a second time and specify the
         * NextToken value.
         * 
         * @param nextToken
         *        The token that identifies which batch of results that you want to see. For example, you submit a
         *        ListFlows request with MaxResults set at 5. The service returns the first batch of results (up to 5)
         *        and a NextToken value. To see the next batch of results, you can submit the ListFlows request a second
         *        time and specify the NextToken value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private List<ListedFlow> flows = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFlowsResponse model) {
            super(model);
            flows(model.flows);
            nextToken(model.nextToken);
        }

        public final Collection<ListedFlow.Builder> getFlows() {
            if (flows instanceof SdkAutoConstructList) {
                return null;
            }
            return flows != null ? flows.stream().map(ListedFlow::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder flows(Collection<ListedFlow> flows) {
            this.flows = ___listOfListedFlowCopier.copy(flows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flows(ListedFlow... flows) {
            flows(Arrays.asList(flows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flows(Consumer<ListedFlow.Builder>... flows) {
            flows(Stream.of(flows).map(c -> ListedFlow.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFlows(Collection<ListedFlow.BuilderImpl> flows) {
            this.flows = ___listOfListedFlowCopier.copyFromBuilder(flows);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFlowsResponse build() {
            return new ListFlowsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
