/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Information about the encryption of the flow.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEncryption implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateEncryption.Builder, UpdateEncryption> {
    private static final SdkField<String> ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Algorithm").getter(getter(UpdateEncryption::algorithmAsString)).setter(setter(Builder::algorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithm").build()).build();

    private static final SdkField<String> CONSTANT_INITIALIZATION_VECTOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConstantInitializationVector")
            .getter(getter(UpdateEncryption::constantInitializationVector))
            .setter(setter(Builder::constantInitializationVector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("constantInitializationVector")
                    .build()).build();

    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceId").getter(getter(UpdateEncryption::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceId").build()).build();

    private static final SdkField<String> KEY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyType").getter(getter(UpdateEncryption::keyTypeAsString)).setter(setter(Builder::keyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyType").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(UpdateEncryption::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(UpdateEncryption::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(UpdateEncryption::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(UpdateEncryption::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(UpdateEncryption::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_FIELD,
            CONSTANT_INITIALIZATION_VECTOR_FIELD, DEVICE_ID_FIELD, KEY_TYPE_FIELD, REGION_FIELD, RESOURCE_ID_FIELD,
            ROLE_ARN_FIELD, SECRET_ARN_FIELD, URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String algorithm;

    private final String constantInitializationVector;

    private final String deviceId;

    private final String keyType;

    private final String region;

    private final String resourceId;

    private final String roleArn;

    private final String secretArn;

    private final String url;

    private UpdateEncryption(BuilderImpl builder) {
        this.algorithm = builder.algorithm;
        this.constantInitializationVector = builder.constantInitializationVector;
        this.deviceId = builder.deviceId;
        this.keyType = builder.keyType;
        this.region = builder.region;
        this.resourceId = builder.resourceId;
        this.roleArn = builder.roleArn;
        this.secretArn = builder.secretArn;
        this.url = builder.url;
    }

    /**
     * The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #algorithm} will
     * return {@link Algorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #algorithmAsString}.
     * </p>
     * 
     * @return The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
     * @see Algorithm
     */
    public final Algorithm algorithm() {
        return Algorithm.fromValue(algorithm);
    }

    /**
     * The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #algorithm} will
     * return {@link Algorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #algorithmAsString}.
     * </p>
     * 
     * @return The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
     * @see Algorithm
     */
    public final String algorithmAsString() {
        return algorithm;
    }

    /**
     * A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting
     * content. This parameter is not valid for static key encryption.
     * 
     * @return A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting
     *         content. This parameter is not valid for static key encryption.
     */
    public final String constantInitializationVector() {
        return constantInitializationVector;
    }

    /**
     * The value of one of the devices that you configured with your digital rights management (DRM) platform key
     * provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
     * 
     * @return The value of one of the devices that you configured with your digital rights management (DRM) platform
     *         key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
     */
    public final String deviceId() {
        return deviceId;
    }

    /**
     * The type of key that is used for the encryption. If no keyType is provided, the service will use the default
     * setting (static-key).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyType} will
     * return {@link KeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyTypeAsString}.
     * </p>
     * 
     * @return The type of key that is used for the encryption. If no keyType is provided, the service will use the
     *         default setting (static-key).
     * @see KeyType
     */
    public final KeyType keyType() {
        return KeyType.fromValue(keyType);
    }

    /**
     * The type of key that is used for the encryption. If no keyType is provided, the service will use the default
     * setting (static-key).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyType} will
     * return {@link KeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyTypeAsString}.
     * </p>
     * 
     * @return The type of key that is used for the encryption. If no keyType is provided, the service will use the
     *         default setting (static-key).
     * @see KeyType
     */
    public final String keyTypeAsString() {
        return keyType;
    }

    /**
     * The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE
     * encryption and is not valid for static key encryption.
     * 
     * @return The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE
     *         encryption and is not valid for static key encryption.
     */
    public final String region() {
        return region;
    }

    /**
     * An identifier for the content. The service sends this value to the key server to identify the current endpoint.
     * The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid
     * for static key encryption.
     * 
     * @return An identifier for the content. The service sends this value to the key server to identify the current
     *         endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE
     *         encryption and is not valid for static key encryption.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted
     * entity).
     * 
     * @return The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a
     *         trusted entity).
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is
     * required for static key encryption and is not valid for SPEKE encryption.
     * 
     * @return The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter
     *         is required for static key encryption and is not valid for SPEKE encryption.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for
     * SPEKE encryption and is not valid for static key encryption.
     * 
     * @return The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required
     *         for SPEKE encryption and is not valid for static key encryption.
     */
    public final String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(algorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(constantInitializationVector());
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(keyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEncryption)) {
            return false;
        }
        UpdateEncryption other = (UpdateEncryption) obj;
        return Objects.equals(algorithmAsString(), other.algorithmAsString())
                && Objects.equals(constantInitializationVector(), other.constantInitializationVector())
                && Objects.equals(deviceId(), other.deviceId()) && Objects.equals(keyTypeAsString(), other.keyTypeAsString())
                && Objects.equals(region(), other.region()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(secretArn(), other.secretArn())
                && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEncryption").add("Algorithm", algorithmAsString())
                .add("ConstantInitializationVector", constantInitializationVector()).add("DeviceId", deviceId())
                .add("KeyType", keyTypeAsString()).add("Region", region()).add("ResourceId", resourceId())
                .add("RoleArn", roleArn()).add("SecretArn", secretArn()).add("Url", url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Algorithm":
            return Optional.ofNullable(clazz.cast(algorithmAsString()));
        case "ConstantInitializationVector":
            return Optional.ofNullable(clazz.cast(constantInitializationVector()));
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "KeyType":
            return Optional.ofNullable(clazz.cast(keyTypeAsString()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEncryption, T> g) {
        return obj -> g.apply((UpdateEncryption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateEncryption> {
        /**
         * The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
         * 
         * @param algorithm
         *        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
         * @see Algorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Algorithm
         */
        Builder algorithm(String algorithm);

        /**
         * The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
         * 
         * @param algorithm
         *        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
         * @see Algorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Algorithm
         */
        Builder algorithm(Algorithm algorithm);

        /**
         * A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting
         * content. This parameter is not valid for static key encryption.
         * 
         * @param constantInitializationVector
         *        A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for
         *        encrypting content. This parameter is not valid for static key encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constantInitializationVector(String constantInitializationVector);

        /**
         * The value of one of the devices that you configured with your digital rights management (DRM) platform key
         * provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
         * 
         * @param deviceId
         *        The value of one of the devices that you configured with your digital rights management (DRM) platform
         *        key provider. This parameter is required for SPEKE encryption and is not valid for static key
         *        encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * The type of key that is used for the encryption. If no keyType is provided, the service will use the default
         * setting (static-key).
         * 
         * @param keyType
         *        The type of key that is used for the encryption. If no keyType is provided, the service will use the
         *        default setting (static-key).
         * @see KeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyType
         */
        Builder keyType(String keyType);

        /**
         * The type of key that is used for the encryption. If no keyType is provided, the service will use the default
         * setting (static-key).
         * 
         * @param keyType
         *        The type of key that is used for the encryption. If no keyType is provided, the service will use the
         *        default setting (static-key).
         * @see KeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyType
         */
        Builder keyType(KeyType keyType);

        /**
         * The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE
         * encryption and is not valid for static key encryption.
         * 
         * @param region
         *        The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for
         *        SPEKE encryption and is not valid for static key encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * An identifier for the content. The service sends this value to the key server to identify the current
         * endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption
         * and is not valid for static key encryption.
         * 
         * @param resourceId
         *        An identifier for the content. The service sends this value to the key server to identify the current
         *        endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE
         *        encryption and is not valid for static key encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted
         * entity).
         * 
         * @param roleArn
         *        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a
         *        trusted entity).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is
         * required for static key encryption and is not valid for SPEKE encryption.
         * 
         * @param secretArn
         *        The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This
         *        parameter is required for static key encryption and is not valid for SPEKE encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for
         * SPEKE encryption and is not valid for static key encryption.
         * 
         * @param url
         *        The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is
         *        required for SPEKE encryption and is not valid for static key encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String algorithm;

        private String constantInitializationVector;

        private String deviceId;

        private String keyType;

        private String region;

        private String resourceId;

        private String roleArn;

        private String secretArn;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEncryption model) {
            algorithm(model.algorithm);
            constantInitializationVector(model.constantInitializationVector);
            deviceId(model.deviceId);
            keyType(model.keyType);
            region(model.region);
            resourceId(model.resourceId);
            roleArn(model.roleArn);
            secretArn(model.secretArn);
            url(model.url);
        }

        public final String getAlgorithm() {
            return algorithm;
        }

        @Override
        public final Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Override
        public final Builder algorithm(Algorithm algorithm) {
            this.algorithm(algorithm == null ? null : algorithm.toString());
            return this;
        }

        public final void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public final String getConstantInitializationVector() {
            return constantInitializationVector;
        }

        @Override
        public final Builder constantInitializationVector(String constantInitializationVector) {
            this.constantInitializationVector = constantInitializationVector;
            return this;
        }

        public final void setConstantInitializationVector(String constantInitializationVector) {
            this.constantInitializationVector = constantInitializationVector;
        }

        public final String getDeviceId() {
            return deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public final String getKeyType() {
            return keyType;
        }

        @Override
        public final Builder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        @Override
        public final Builder keyType(KeyType keyType) {
            this.keyType(keyType == null ? null : keyType.toString());
            return this;
        }

        public final void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public UpdateEncryption build() {
            return new UpdateEncryption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
