/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The settings for a flow, including its source, outputs, and entitlements.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Flow implements SdkPojo, Serializable, ToCopyableBuilder<Flow.Builder, Flow> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(Flow::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Flow::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> EGRESS_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EgressIp").getter(getter(Flow::egressIp)).setter(setter(Builder::egressIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressIp").build()).build();

    private static final SdkField<List<Entitlement>> ENTITLEMENTS_FIELD = SdkField
            .<List<Entitlement>> builder(MarshallingType.LIST)
            .memberName("Entitlements")
            .getter(getter(Flow::entitlements))
            .setter(setter(Builder::entitlements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Entitlement> builder(MarshallingType.SDK_POJO)
                                            .constructor(Entitlement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(Flow::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final SdkField<List<MediaStream>> MEDIA_STREAMS_FIELD = SdkField
            .<List<MediaStream>> builder(MarshallingType.LIST)
            .memberName("MediaStreams")
            .getter(getter(Flow::mediaStreams))
            .setter(setter(Builder::mediaStreams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreams").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MediaStream> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaStream::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Flow::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<Output>> OUTPUTS_FIELD = SdkField
            .<List<Output>> builder(MarshallingType.LIST)
            .memberName("Outputs")
            .getter(getter(Flow::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Output> builder(MarshallingType.SDK_POJO)
                                            .constructor(Output::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Source> SOURCE_FIELD = SdkField.<Source> builder(MarshallingType.SDK_POJO).memberName("Source")
            .getter(getter(Flow::source)).setter(setter(Builder::source)).constructor(Source::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<FailoverConfig> SOURCE_FAILOVER_CONFIG_FIELD = SdkField
            .<FailoverConfig> builder(MarshallingType.SDK_POJO).memberName("SourceFailoverConfig")
            .getter(getter(Flow::sourceFailoverConfig)).setter(setter(Builder::sourceFailoverConfig))
            .constructor(FailoverConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFailoverConfig").build())
            .build();

    private static final SdkField<List<Source>> SOURCES_FIELD = SdkField
            .<List<Source>> builder(MarshallingType.LIST)
            .memberName("Sources")
            .getter(getter(Flow::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Source> builder(MarshallingType.SDK_POJO)
                                            .constructor(Source::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Flow::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<VpcInterface>> VPC_INTERFACES_FIELD = SdkField
            .<List<VpcInterface>> builder(MarshallingType.LIST)
            .memberName("VpcInterfaces")
            .getter(getter(Flow::vpcInterfaces))
            .setter(setter(Builder::vpcInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpcInterface> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcInterface::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            DESCRIPTION_FIELD, EGRESS_IP_FIELD, ENTITLEMENTS_FIELD, FLOW_ARN_FIELD, MEDIA_STREAMS_FIELD, NAME_FIELD,
            OUTPUTS_FIELD, SOURCE_FIELD, SOURCE_FAILOVER_CONFIG_FIELD, SOURCES_FIELD, STATUS_FIELD, VPC_INTERFACES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String availabilityZone;

    private final String description;

    private final String egressIp;

    private final List<Entitlement> entitlements;

    private final String flowArn;

    private final List<MediaStream> mediaStreams;

    private final String name;

    private final List<Output> outputs;

    private final Source source;

    private final FailoverConfig sourceFailoverConfig;

    private final List<Source> sources;

    private final String status;

    private final List<VpcInterface> vpcInterfaces;

    private Flow(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.description = builder.description;
        this.egressIp = builder.egressIp;
        this.entitlements = builder.entitlements;
        this.flowArn = builder.flowArn;
        this.mediaStreams = builder.mediaStreams;
        this.name = builder.name;
        this.outputs = builder.outputs;
        this.source = builder.source;
        this.sourceFailoverConfig = builder.sourceFailoverConfig;
        this.sources = builder.sources;
        this.status = builder.status;
        this.vpcInterfaces = builder.vpcInterfaces;
    }

    /**
     * The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones
     * within the current AWS.
     * 
     * @return The Availability Zone that you want to create the flow in. These options are limited to the Availability
     *         Zones within the current AWS.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * A description of the flow. This value is not used or seen outside of the current AWS Elemental MediaConnect
     * account.
     * 
     * @return A description of the flow. This value is not used or seen outside of the current AWS Elemental
     *         MediaConnect account.
     */
    public final String description() {
        return description;
    }

    /**
     * The IP address from which video will be sent to output destinations.
     * 
     * @return The IP address from which video will be sent to output destinations.
     */
    public final String egressIp() {
        return egressIp;
    }

    /**
     * Returns true if the Entitlements property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEntitlements() {
        return entitlements != null && !(entitlements instanceof SdkAutoConstructList);
    }

    /**
     * The entitlements in this flow.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEntitlements()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The entitlements in this flow.
     */
    public final List<Entitlement> entitlements() {
        return entitlements;
    }

    /**
     * The Amazon Resource Name (ARN), a unique identifier for any AWS resource, of the flow.
     * 
     * @return The Amazon Resource Name (ARN), a unique identifier for any AWS resource, of the flow.
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * Returns true if the MediaStreams property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasMediaStreams() {
        return mediaStreams != null && !(mediaStreams instanceof SdkAutoConstructList);
    }

    /**
     * The media streams that are associated with the flow. After you associate a media stream with a source, you can
     * also associate it with outputs on the flow.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMediaStreams()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The media streams that are associated with the flow. After you associate a media stream with a source,
     *         you can also associate it with outputs on the flow.
     */
    public final List<MediaStream> mediaStreams() {
        return mediaStreams;
    }

    /**
     * The name of the flow.
     * 
     * @return The name of the flow.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns true if the Outputs property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * The outputs in this flow.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOutputs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The outputs in this flow.
     */
    public final List<Output> outputs() {
        return outputs;
    }

    /**
     * Returns the value of the Source property for this object.
     * 
     * @return The value of the Source property for this object.
     */
    public final Source source() {
        return source;
    }

    /**
     * Returns the value of the SourceFailoverConfig property for this object.
     * 
     * @return The value of the SourceFailoverConfig property for this object.
     */
    public final FailoverConfig sourceFailoverConfig() {
        return sourceFailoverConfig;
    }

    /**
     * Returns true if the Sources property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Sources property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the Sources property for this object.
     */
    public final List<Source> sources() {
        return sources;
    }

    /**
     * The current status of the flow.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the flow.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * The current status of the flow.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the flow.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns true if the VpcInterfaces property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasVpcInterfaces() {
        return vpcInterfaces != null && !(vpcInterfaces instanceof SdkAutoConstructList);
    }

    /**
     * The VPC Interfaces for this flow.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVpcInterfaces()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The VPC Interfaces for this flow.
     */
    public final List<VpcInterface> vpcInterfaces() {
        return vpcInterfaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(egressIp());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntitlements() ? entitlements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasMediaStreams() ? mediaStreams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFailoverConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcInterfaces() ? vpcInterfaces() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Flow)) {
            return false;
        }
        Flow other = (Flow) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(description(), other.description())
                && Objects.equals(egressIp(), other.egressIp()) && hasEntitlements() == other.hasEntitlements()
                && Objects.equals(entitlements(), other.entitlements()) && Objects.equals(flowArn(), other.flowArn())
                && hasMediaStreams() == other.hasMediaStreams() && Objects.equals(mediaStreams(), other.mediaStreams())
                && Objects.equals(name(), other.name()) && hasOutputs() == other.hasOutputs()
                && Objects.equals(outputs(), other.outputs()) && Objects.equals(source(), other.source())
                && Objects.equals(sourceFailoverConfig(), other.sourceFailoverConfig()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasVpcInterfaces() == other.hasVpcInterfaces() && Objects.equals(vpcInterfaces(), other.vpcInterfaces());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Flow").add("AvailabilityZone", availabilityZone()).add("Description", description())
                .add("EgressIp", egressIp()).add("Entitlements", hasEntitlements() ? entitlements() : null)
                .add("FlowArn", flowArn()).add("MediaStreams", hasMediaStreams() ? mediaStreams() : null).add("Name", name())
                .add("Outputs", hasOutputs() ? outputs() : null).add("Source", source())
                .add("SourceFailoverConfig", sourceFailoverConfig()).add("Sources", hasSources() ? sources() : null)
                .add("Status", statusAsString()).add("VpcInterfaces", hasVpcInterfaces() ? vpcInterfaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EgressIp":
            return Optional.ofNullable(clazz.cast(egressIp()));
        case "Entitlements":
            return Optional.ofNullable(clazz.cast(entitlements()));
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "MediaStreams":
            return Optional.ofNullable(clazz.cast(mediaStreams()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "SourceFailoverConfig":
            return Optional.ofNullable(clazz.cast(sourceFailoverConfig()));
        case "Sources":
            return Optional.ofNullable(clazz.cast(sources()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "VpcInterfaces":
            return Optional.ofNullable(clazz.cast(vpcInterfaces()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Flow, T> g) {
        return obj -> g.apply((Flow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Flow> {
        /**
         * The Availability Zone that you want to create the flow in. These options are limited to the Availability
         * Zones within the current AWS.
         * 
         * @param availabilityZone
         *        The Availability Zone that you want to create the flow in. These options are limited to the
         *        Availability Zones within the current AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * A description of the flow. This value is not used or seen outside of the current AWS Elemental MediaConnect
         * account.
         * 
         * @param description
         *        A description of the flow. This value is not used or seen outside of the current AWS Elemental
         *        MediaConnect account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The IP address from which video will be sent to output destinations.
         * 
         * @param egressIp
         *        The IP address from which video will be sent to output destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressIp(String egressIp);

        /**
         * The entitlements in this flow.
         * 
         * @param entitlements
         *        The entitlements in this flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(Collection<Entitlement> entitlements);

        /**
         * The entitlements in this flow.
         * 
         * @param entitlements
         *        The entitlements in this flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(Entitlement... entitlements);

        /**
         * The entitlements in this flow. This is a convenience that creates an instance of the {@link List
         * <Entitlement>.Builder} avoiding the need to create one manually via {@link List<Entitlement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Entitlement>.Builder#build()} is called immediately and its
         * result is passed to {@link #entitlements(List<Entitlement>)}.
         * 
         * @param entitlements
         *        a consumer that will call methods on {@link List<Entitlement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entitlements(List<Entitlement>)
         */
        Builder entitlements(Consumer<Entitlement.Builder>... entitlements);

        /**
         * The Amazon Resource Name (ARN), a unique identifier for any AWS resource, of the flow.
         * 
         * @param flowArn
         *        The Amazon Resource Name (ARN), a unique identifier for any AWS resource, of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * The media streams that are associated with the flow. After you associate a media stream with a source, you
         * can also associate it with outputs on the flow.
         * 
         * @param mediaStreams
         *        The media streams that are associated with the flow. After you associate a media stream with a source,
         *        you can also associate it with outputs on the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStreams(Collection<MediaStream> mediaStreams);

        /**
         * The media streams that are associated with the flow. After you associate a media stream with a source, you
         * can also associate it with outputs on the flow.
         * 
         * @param mediaStreams
         *        The media streams that are associated with the flow. After you associate a media stream with a source,
         *        you can also associate it with outputs on the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStreams(MediaStream... mediaStreams);

        /**
         * The media streams that are associated with the flow. After you associate a media stream with a source, you
         * can also associate it with outputs on the flow. This is a convenience that creates an instance of the
         * {@link List<MediaStream>.Builder} avoiding the need to create one manually via {@link List
         * <MediaStream>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MediaStream>.Builder#build()} is called immediately and its
         * result is passed to {@link #mediaStreams(List<MediaStream>)}.
         * 
         * @param mediaStreams
         *        a consumer that will call methods on {@link List<MediaStream>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaStreams(List<MediaStream>)
         */
        Builder mediaStreams(Consumer<MediaStream.Builder>... mediaStreams);

        /**
         * The name of the flow.
         * 
         * @param name
         *        The name of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The outputs in this flow.
         * 
         * @param outputs
         *        The outputs in this flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<Output> outputs);

        /**
         * The outputs in this flow.
         * 
         * @param outputs
         *        The outputs in this flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Output... outputs);

        /**
         * The outputs in this flow. This is a convenience that creates an instance of the {@link List<Output>.Builder}
         * avoiding the need to create one manually via {@link List<Output>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Output>.Builder#build()} is called immediately and its
         * result is passed to {@link #outputs(List<Output>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on {@link List<Output>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(List<Output>)
         */
        Builder outputs(Consumer<Output.Builder>... outputs);

        /**
         * Sets the value of the Source property for this object.
         *
         * @param source
         *        The new value for the Source property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(Source source);

        /**
         * Sets the value of the Source property for this object.
         *
         * This is a convenience that creates an instance of the {@link Source.Builder} avoiding the need to create one
         * manually via {@link Source#builder()}.
         *
         * When the {@link Consumer} completes, {@link Source.Builder#build()} is called immediately and its result is
         * passed to {@link #source(Source)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(Source)
         */
        default Builder source(Consumer<Source.Builder> source) {
            return source(Source.builder().applyMutation(source).build());
        }

        /**
         * Sets the value of the SourceFailoverConfig property for this object.
         *
         * @param sourceFailoverConfig
         *        The new value for the SourceFailoverConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFailoverConfig(FailoverConfig sourceFailoverConfig);

        /**
         * Sets the value of the SourceFailoverConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link FailoverConfig.Builder} avoiding the need to
         * create one manually via {@link FailoverConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link FailoverConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceFailoverConfig(FailoverConfig)}.
         * 
         * @param sourceFailoverConfig
         *        a consumer that will call methods on {@link FailoverConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceFailoverConfig(FailoverConfig)
         */
        default Builder sourceFailoverConfig(Consumer<FailoverConfig.Builder> sourceFailoverConfig) {
            return sourceFailoverConfig(FailoverConfig.builder().applyMutation(sourceFailoverConfig).build());
        }

        /**
         * Sets the value of the Sources property for this object.
         *
         * @param sources
         *        The new value for the Sources property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<Source> sources);

        /**
         * Sets the value of the Sources property for this object.
         *
         * @param sources
         *        The new value for the Sources property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Source... sources);

        /**
         * Sets the value of the Sources property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<Source>.Builder} avoiding the need to
         * create one manually via {@link List<Source>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Source>.Builder#build()} is called immediately and its
         * result is passed to {@link #sources(List<Source>)}.
         * 
         * @param sources
         *        a consumer that will call methods on {@link List<Source>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(List<Source>)
         */
        Builder sources(Consumer<Source.Builder>... sources);

        /**
         * The current status of the flow.
         * 
         * @param status
         *        The current status of the flow.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * The current status of the flow.
         * 
         * @param status
         *        The current status of the flow.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * The VPC Interfaces for this flow.
         * 
         * @param vpcInterfaces
         *        The VPC Interfaces for this flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcInterfaces(Collection<VpcInterface> vpcInterfaces);

        /**
         * The VPC Interfaces for this flow.
         * 
         * @param vpcInterfaces
         *        The VPC Interfaces for this flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcInterfaces(VpcInterface... vpcInterfaces);

        /**
         * The VPC Interfaces for this flow. This is a convenience that creates an instance of the {@link List
         * <VpcInterface>.Builder} avoiding the need to create one manually via {@link List<VpcInterface>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VpcInterface>.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcInterfaces(List<VpcInterface>)}.
         * 
         * @param vpcInterfaces
         *        a consumer that will call methods on {@link List<VpcInterface>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcInterfaces(List<VpcInterface>)
         */
        Builder vpcInterfaces(Consumer<VpcInterface.Builder>... vpcInterfaces);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String description;

        private String egressIp;

        private List<Entitlement> entitlements = DefaultSdkAutoConstructList.getInstance();

        private String flowArn;

        private List<MediaStream> mediaStreams = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private List<Output> outputs = DefaultSdkAutoConstructList.getInstance();

        private Source source;

        private FailoverConfig sourceFailoverConfig;

        private List<Source> sources = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private List<VpcInterface> vpcInterfaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Flow model) {
            availabilityZone(model.availabilityZone);
            description(model.description);
            egressIp(model.egressIp);
            entitlements(model.entitlements);
            flowArn(model.flowArn);
            mediaStreams(model.mediaStreams);
            name(model.name);
            outputs(model.outputs);
            source(model.source);
            sourceFailoverConfig(model.sourceFailoverConfig);
            sources(model.sources);
            status(model.status);
            vpcInterfaces(model.vpcInterfaces);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEgressIp() {
            return egressIp;
        }

        @Override
        public final Builder egressIp(String egressIp) {
            this.egressIp = egressIp;
            return this;
        }

        public final void setEgressIp(String egressIp) {
            this.egressIp = egressIp;
        }

        public final List<Entitlement.Builder> getEntitlements() {
            List<Entitlement.Builder> result = ___listOfEntitlementCopier.copyToBuilder(this.entitlements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder entitlements(Collection<Entitlement> entitlements) {
            this.entitlements = ___listOfEntitlementCopier.copy(entitlements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Entitlement... entitlements) {
            entitlements(Arrays.asList(entitlements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Consumer<Entitlement.Builder>... entitlements) {
            entitlements(Stream.of(entitlements).map(c -> Entitlement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEntitlements(Collection<Entitlement.BuilderImpl> entitlements) {
            this.entitlements = ___listOfEntitlementCopier.copyFromBuilder(entitlements);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        public final List<MediaStream.Builder> getMediaStreams() {
            List<MediaStream.Builder> result = ___listOfMediaStreamCopier.copyToBuilder(this.mediaStreams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder mediaStreams(Collection<MediaStream> mediaStreams) {
            this.mediaStreams = ___listOfMediaStreamCopier.copy(mediaStreams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaStreams(MediaStream... mediaStreams) {
            mediaStreams(Arrays.asList(mediaStreams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaStreams(Consumer<MediaStream.Builder>... mediaStreams) {
            mediaStreams(Stream.of(mediaStreams).map(c -> MediaStream.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMediaStreams(Collection<MediaStream.BuilderImpl> mediaStreams) {
            this.mediaStreams = ___listOfMediaStreamCopier.copyFromBuilder(mediaStreams);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final List<Output.Builder> getOutputs() {
            List<Output.Builder> result = ___listOfOutputCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = ___listOfOutputCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<Output.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> Output.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = ___listOfOutputCopier.copyFromBuilder(outputs);
        }

        public final Source.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final FailoverConfig.Builder getSourceFailoverConfig() {
            return sourceFailoverConfig != null ? sourceFailoverConfig.toBuilder() : null;
        }

        @Override
        public final Builder sourceFailoverConfig(FailoverConfig sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig;
            return this;
        }

        public final void setSourceFailoverConfig(FailoverConfig.BuilderImpl sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig != null ? sourceFailoverConfig.build() : null;
        }

        public final List<Source.Builder> getSources() {
            List<Source.Builder> result = ___listOfSourceCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder sources(Collection<Source> sources) {
            this.sources = ___listOfSourceCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Source... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<Source.Builder>... sources) {
            sources(Stream.of(sources).map(c -> Source.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSources(Collection<Source.BuilderImpl> sources) {
            this.sources = ___listOfSourceCopier.copyFromBuilder(sources);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final List<VpcInterface.Builder> getVpcInterfaces() {
            List<VpcInterface.Builder> result = ___listOfVpcInterfaceCopier.copyToBuilder(this.vpcInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder vpcInterfaces(Collection<VpcInterface> vpcInterfaces) {
            this.vpcInterfaces = ___listOfVpcInterfaceCopier.copy(vpcInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcInterfaces(VpcInterface... vpcInterfaces) {
            vpcInterfaces(Arrays.asList(vpcInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcInterfaces(Consumer<VpcInterface.Builder>... vpcInterfaces) {
            vpcInterfaces(Stream.of(vpcInterfaces).map(c -> VpcInterface.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVpcInterfaces(Collection<VpcInterface.BuilderImpl> vpcInterfaces) {
            this.vpcInterfaces = ___listOfVpcInterfaceCopier.copyFromBuilder(vpcInterfaces);
        }

        @Override
        public Flow build() {
            return new Flow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
