/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The transport parameters that are associated with an incoming media stream.
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<InputConfiguration.Builder, InputConfiguration> {
    private static final SdkField<String> INPUT_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputIp").getter(getter(InputConfiguration::inputIp)).setter(setter(Builder::inputIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputIp").build()).build();

    private static final SdkField<Integer> INPUT_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InputPort").getter(getter(InputConfiguration::inputPort)).setter(setter(Builder::inputPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputPort").build()).build();

    private static final SdkField<Interface> INTERFACE_FIELD = SdkField.<Interface> builder(MarshallingType.SDK_POJO)
            .memberName("Interface").getter(getter(InputConfiguration::interfaceValue)).setter(setter(Builder::interfaceValue))
            .constructor(Interface::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interface").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_IP_FIELD,
            INPUT_PORT_FIELD, INTERFACE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inputIp;

    private final Integer inputPort;

    private final Interface interfaceValue;

    private InputConfiguration(BuilderImpl builder) {
        this.inputIp = builder.inputIp;
        this.inputPort = builder.inputPort;
        this.interfaceValue = builder.interfaceValue;
    }

    /**
     * The IP address that the flow listens on for incoming content for a media stream.
     * 
     * @return The IP address that the flow listens on for incoming content for a media stream.
     */
    public final String inputIp() {
        return inputIp;
    }

    /**
     * The port that the flow listens on for an incoming media stream.
     * 
     * @return The port that the flow listens on for an incoming media stream.
     */
    public final Integer inputPort() {
        return inputPort;
    }

    /**
     * The VPC interface where the media stream comes in from.
     * 
     * @return The VPC interface where the media stream comes in from.
     */
    public final Interface interfaceValue() {
        return interfaceValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputIp());
        hashCode = 31 * hashCode + Objects.hashCode(inputPort());
        hashCode = 31 * hashCode + Objects.hashCode(interfaceValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputConfiguration)) {
            return false;
        }
        InputConfiguration other = (InputConfiguration) obj;
        return Objects.equals(inputIp(), other.inputIp()) && Objects.equals(inputPort(), other.inputPort())
                && Objects.equals(interfaceValue(), other.interfaceValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputConfiguration").add("InputIp", inputIp()).add("InputPort", inputPort())
                .add("Interface", interfaceValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputIp":
            return Optional.ofNullable(clazz.cast(inputIp()));
        case "InputPort":
            return Optional.ofNullable(clazz.cast(inputPort()));
        case "Interface":
            return Optional.ofNullable(clazz.cast(interfaceValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputConfiguration, T> g) {
        return obj -> g.apply((InputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputConfiguration> {
        /**
         * The IP address that the flow listens on for incoming content for a media stream.
         * 
         * @param inputIp
         *        The IP address that the flow listens on for incoming content for a media stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputIp(String inputIp);

        /**
         * The port that the flow listens on for an incoming media stream.
         * 
         * @param inputPort
         *        The port that the flow listens on for an incoming media stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputPort(Integer inputPort);

        /**
         * The VPC interface where the media stream comes in from.
         * 
         * @param interfaceValue
         *        The VPC interface where the media stream comes in from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceValue(Interface interfaceValue);

        /**
         * The VPC interface where the media stream comes in from. This is a convenience that creates an instance of the
         * {@link Interface.Builder} avoiding the need to create one manually via {@link Interface#builder()}.
         *
         * When the {@link Consumer} completes, {@link Interface.Builder#build()} is called immediately and its result
         * is passed to {@link #interfaceValue(Interface)}.
         * 
         * @param interfaceValue
         *        a consumer that will call methods on {@link Interface.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interfaceValue(Interface)
         */
        default Builder interfaceValue(Consumer<Interface.Builder> interfaceValue) {
            return interfaceValue(Interface.builder().applyMutation(interfaceValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String inputIp;

        private Integer inputPort;

        private Interface interfaceValue;

        private BuilderImpl() {
        }

        private BuilderImpl(InputConfiguration model) {
            inputIp(model.inputIp);
            inputPort(model.inputPort);
            interfaceValue(model.interfaceValue);
        }

        public final String getInputIp() {
            return inputIp;
        }

        @Override
        public final Builder inputIp(String inputIp) {
            this.inputIp = inputIp;
            return this;
        }

        public final void setInputIp(String inputIp) {
            this.inputIp = inputIp;
        }

        public final Integer getInputPort() {
            return inputPort;
        }

        @Override
        public final Builder inputPort(Integer inputPort) {
            this.inputPort = inputPort;
            return this;
        }

        public final void setInputPort(Integer inputPort) {
            this.inputPort = inputPort;
        }

        public final Interface.Builder getInterfaceValue() {
            return interfaceValue != null ? interfaceValue.toBuilder() : null;
        }

        @Override
        public final Builder interfaceValue(Interface interfaceValue) {
            this.interfaceValue = interfaceValue;
            return this;
        }

        public final void setInterfaceValue(Interface.BuilderImpl interfaceValue) {
            this.interfaceValue = interfaceValue != null ? interfaceValue.build() : null;
        }

        @Override
        public InputConfiguration build() {
            return new InputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
