/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddFlowVpcInterfacesResponse extends MediaConnectResponse implements
        ToCopyableBuilder<AddFlowVpcInterfacesResponse.Builder, AddFlowVpcInterfacesResponse> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(AddFlowVpcInterfacesResponse::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final SdkField<List<VpcInterface>> VPC_INTERFACES_FIELD = SdkField
            .<List<VpcInterface>> builder(MarshallingType.LIST)
            .memberName("VpcInterfaces")
            .getter(getter(AddFlowVpcInterfacesResponse::vpcInterfaces))
            .setter(setter(Builder::vpcInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpcInterface> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcInterface::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD,
            VPC_INTERFACES_FIELD));

    private final String flowArn;

    private final List<VpcInterface> vpcInterfaces;

    private AddFlowVpcInterfacesResponse(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.vpcInterfaces = builder.vpcInterfaces;
    }

    /**
     * The ARN of the flow that these VPC interfaces were added to.
     * 
     * @return The ARN of the flow that these VPC interfaces were added to.
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * Returns true if the VpcInterfaces property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasVpcInterfaces() {
        return vpcInterfaces != null && !(vpcInterfaces instanceof SdkAutoConstructList);
    }

    /**
     * The details of the newly added VPC interfaces.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVpcInterfaces()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The details of the newly added VPC interfaces.
     */
    public final List<VpcInterface> vpcInterfaces() {
        return vpcInterfaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcInterfaces() ? vpcInterfaces() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddFlowVpcInterfacesResponse)) {
            return false;
        }
        AddFlowVpcInterfacesResponse other = (AddFlowVpcInterfacesResponse) obj;
        return Objects.equals(flowArn(), other.flowArn()) && hasVpcInterfaces() == other.hasVpcInterfaces()
                && Objects.equals(vpcInterfaces(), other.vpcInterfaces());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddFlowVpcInterfacesResponse").add("FlowArn", flowArn())
                .add("VpcInterfaces", hasVpcInterfaces() ? vpcInterfaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "VpcInterfaces":
            return Optional.ofNullable(clazz.cast(vpcInterfaces()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddFlowVpcInterfacesResponse, T> g) {
        return obj -> g.apply((AddFlowVpcInterfacesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AddFlowVpcInterfacesResponse> {
        /**
         * The ARN of the flow that these VPC interfaces were added to.
         * 
         * @param flowArn
         *        The ARN of the flow that these VPC interfaces were added to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * The details of the newly added VPC interfaces.
         * 
         * @param vpcInterfaces
         *        The details of the newly added VPC interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcInterfaces(Collection<VpcInterface> vpcInterfaces);

        /**
         * The details of the newly added VPC interfaces.
         * 
         * @param vpcInterfaces
         *        The details of the newly added VPC interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcInterfaces(VpcInterface... vpcInterfaces);

        /**
         * The details of the newly added VPC interfaces. This is a convenience that creates an instance of the
         * {@link List<VpcInterface>.Builder} avoiding the need to create one manually via {@link List
         * <VpcInterface>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VpcInterface>.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcInterfaces(List<VpcInterface>)}.
         * 
         * @param vpcInterfaces
         *        a consumer that will call methods on {@link List<VpcInterface>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcInterfaces(List<VpcInterface>)
         */
        Builder vpcInterfaces(Consumer<VpcInterface.Builder>... vpcInterfaces);
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private String flowArn;

        private List<VpcInterface> vpcInterfaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddFlowVpcInterfacesResponse model) {
            super(model);
            flowArn(model.flowArn);
            vpcInterfaces(model.vpcInterfaces);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        public final List<VpcInterface.Builder> getVpcInterfaces() {
            List<VpcInterface.Builder> result = ___listOfVpcInterfaceCopier.copyToBuilder(this.vpcInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder vpcInterfaces(Collection<VpcInterface> vpcInterfaces) {
            this.vpcInterfaces = ___listOfVpcInterfaceCopier.copy(vpcInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcInterfaces(VpcInterface... vpcInterfaces) {
            vpcInterfaces(Arrays.asList(vpcInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcInterfaces(Consumer<VpcInterface.Builder>... vpcInterfaces) {
            vpcInterfaces(Stream.of(vpcInterfaces).map(c -> VpcInterface.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVpcInterfaces(Collection<VpcInterface.BuilderImpl> vpcInterfaces) {
            this.vpcInterfaces = ___listOfVpcInterfaceCopier.copyFromBuilder(vpcInterfaces);
        }

        @Override
        public AddFlowVpcInterfacesResponse build() {
            return new AddFlowVpcInterfacesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
