/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The media stream that you want to associate with the output, and the parameters for that association.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaStreamOutputConfigurationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaStreamOutputConfigurationRequest.Builder, MediaStreamOutputConfigurationRequest> {
    private static final SdkField<List<DestinationConfigurationRequest>> DESTINATION_CONFIGURATIONS_FIELD = SdkField
            .<List<DestinationConfigurationRequest>> builder(MarshallingType.LIST)
            .memberName("DestinationConfigurations")
            .getter(getter(MediaStreamOutputConfigurationRequest::destinationConfigurations))
            .setter(setter(Builder::destinationConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DestinationConfigurationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(DestinationConfigurationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENCODING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncodingName").getter(getter(MediaStreamOutputConfigurationRequest::encodingNameAsString))
            .setter(setter(Builder::encodingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encodingName").build()).build();

    private static final SdkField<EncodingParametersRequest> ENCODING_PARAMETERS_FIELD = SdkField
            .<EncodingParametersRequest> builder(MarshallingType.SDK_POJO).memberName("EncodingParameters")
            .getter(getter(MediaStreamOutputConfigurationRequest::encodingParameters))
            .setter(setter(Builder::encodingParameters)).constructor(EncodingParametersRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encodingParameters").build())
            .build();

    private static final SdkField<String> MEDIA_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaStreamName").getter(getter(MediaStreamOutputConfigurationRequest::mediaStreamName))
            .setter(setter(Builder::mediaStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreamName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DESTINATION_CONFIGURATIONS_FIELD, ENCODING_NAME_FIELD, ENCODING_PARAMETERS_FIELD, MEDIA_STREAM_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DestinationConfigurationRequest> destinationConfigurations;

    private final String encodingName;

    private final EncodingParametersRequest encodingParameters;

    private final String mediaStreamName;

    private MediaStreamOutputConfigurationRequest(BuilderImpl builder) {
        this.destinationConfigurations = builder.destinationConfigurations;
        this.encodingName = builder.encodingName;
        this.encodingParameters = builder.encodingParameters;
        this.mediaStreamName = builder.mediaStreamName;
    }

    /**
     * Returns true if the DestinationConfigurations property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDestinationConfigurations() {
        return destinationConfigurations != null && !(destinationConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * The transport parameters that you want to associate with the media stream.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDestinationConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The transport parameters that you want to associate with the media stream.
     */
    public final List<DestinationConfigurationRequest> destinationConfigurations() {
        return destinationConfigurations;
    }

    /**
     * The format that will be used to encode the data. For ancillary data streams, set the encoding name to smpte291.
     * For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For
     * video, JPEG XS streams, set the encoding name to jxsv.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encodingName} will
     * return {@link EncodingName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #encodingNameAsString}.
     * </p>
     * 
     * @return The format that will be used to encode the data. For ancillary data streams, set the encoding name to
     *         smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name
     *         to raw. For video, JPEG XS streams, set the encoding name to jxsv.
     * @see EncodingName
     */
    public final EncodingName encodingName() {
        return EncodingName.fromValue(encodingName);
    }

    /**
     * The format that will be used to encode the data. For ancillary data streams, set the encoding name to smpte291.
     * For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For
     * video, JPEG XS streams, set the encoding name to jxsv.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encodingName} will
     * return {@link EncodingName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #encodingNameAsString}.
     * </p>
     * 
     * @return The format that will be used to encode the data. For ancillary data streams, set the encoding name to
     *         smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name
     *         to raw. For video, JPEG XS streams, set the encoding name to jxsv.
     * @see EncodingName
     */
    public final String encodingNameAsString() {
        return encodingName;
    }

    /**
     * A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to
     * outputs on flows that have a CDI source.
     * 
     * @return A collection of parameters that determine how MediaConnect will convert the content. These fields only
     *         apply to outputs on flows that have a CDI source.
     */
    public final EncodingParametersRequest encodingParameters() {
        return encodingParameters;
    }

    /**
     * The name of the media stream that is associated with the output.
     * 
     * @return The name of the media stream that is associated with the output.
     */
    public final String mediaStreamName() {
        return mediaStreamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationConfigurations() ? destinationConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(encodingNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encodingParameters());
        hashCode = 31 * hashCode + Objects.hashCode(mediaStreamName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaStreamOutputConfigurationRequest)) {
            return false;
        }
        MediaStreamOutputConfigurationRequest other = (MediaStreamOutputConfigurationRequest) obj;
        return hasDestinationConfigurations() == other.hasDestinationConfigurations()
                && Objects.equals(destinationConfigurations(), other.destinationConfigurations())
                && Objects.equals(encodingNameAsString(), other.encodingNameAsString())
                && Objects.equals(encodingParameters(), other.encodingParameters())
                && Objects.equals(mediaStreamName(), other.mediaStreamName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaStreamOutputConfigurationRequest")
                .add("DestinationConfigurations", hasDestinationConfigurations() ? destinationConfigurations() : null)
                .add("EncodingName", encodingNameAsString()).add("EncodingParameters", encodingParameters())
                .add("MediaStreamName", mediaStreamName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationConfigurations":
            return Optional.ofNullable(clazz.cast(destinationConfigurations()));
        case "EncodingName":
            return Optional.ofNullable(clazz.cast(encodingNameAsString()));
        case "EncodingParameters":
            return Optional.ofNullable(clazz.cast(encodingParameters()));
        case "MediaStreamName":
            return Optional.ofNullable(clazz.cast(mediaStreamName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MediaStreamOutputConfigurationRequest, T> g) {
        return obj -> g.apply((MediaStreamOutputConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaStreamOutputConfigurationRequest> {
        /**
         * The transport parameters that you want to associate with the media stream.
         * 
         * @param destinationConfigurations
         *        The transport parameters that you want to associate with the media stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfigurations(Collection<DestinationConfigurationRequest> destinationConfigurations);

        /**
         * The transport parameters that you want to associate with the media stream.
         * 
         * @param destinationConfigurations
         *        The transport parameters that you want to associate with the media stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfigurations(DestinationConfigurationRequest... destinationConfigurations);

        /**
         * The transport parameters that you want to associate with the media stream. This is a convenience that creates
         * an instance of the {@link List<DestinationConfigurationRequest>.Builder} avoiding the need to create one
         * manually via {@link List<DestinationConfigurationRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DestinationConfigurationRequest>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #destinationConfigurations(List<DestinationConfigurationRequest>)}.
         * 
         * @param destinationConfigurations
         *        a consumer that will call methods on {@link List<DestinationConfigurationRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConfigurations(List<DestinationConfigurationRequest>)
         */
        Builder destinationConfigurations(Consumer<DestinationConfigurationRequest.Builder>... destinationConfigurations);

        /**
         * The format that will be used to encode the data. For ancillary data streams, set the encoding name to
         * smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to
         * raw. For video, JPEG XS streams, set the encoding name to jxsv.
         * 
         * @param encodingName
         *        The format that will be used to encode the data. For ancillary data streams, set the encoding name to
         *        smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding
         *        name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
         * @see EncodingName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingName
         */
        Builder encodingName(String encodingName);

        /**
         * The format that will be used to encode the data. For ancillary data streams, set the encoding name to
         * smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to
         * raw. For video, JPEG XS streams, set the encoding name to jxsv.
         * 
         * @param encodingName
         *        The format that will be used to encode the data. For ancillary data streams, set the encoding name to
         *        smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding
         *        name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
         * @see EncodingName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingName
         */
        Builder encodingName(EncodingName encodingName);

        /**
         * A collection of parameters that determine how MediaConnect will convert the content. These fields only apply
         * to outputs on flows that have a CDI source.
         * 
         * @param encodingParameters
         *        A collection of parameters that determine how MediaConnect will convert the content. These fields only
         *        apply to outputs on flows that have a CDI source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encodingParameters(EncodingParametersRequest encodingParameters);

        /**
         * A collection of parameters that determine how MediaConnect will convert the content. These fields only apply
         * to outputs on flows that have a CDI source. This is a convenience that creates an instance of the
         * {@link EncodingParametersRequest.Builder} avoiding the need to create one manually via
         * {@link EncodingParametersRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link EncodingParametersRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #encodingParameters(EncodingParametersRequest)}.
         * 
         * @param encodingParameters
         *        a consumer that will call methods on {@link EncodingParametersRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encodingParameters(EncodingParametersRequest)
         */
        default Builder encodingParameters(Consumer<EncodingParametersRequest.Builder> encodingParameters) {
            return encodingParameters(EncodingParametersRequest.builder().applyMutation(encodingParameters).build());
        }

        /**
         * The name of the media stream that is associated with the output.
         * 
         * @param mediaStreamName
         *        The name of the media stream that is associated with the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStreamName(String mediaStreamName);
    }

    static final class BuilderImpl implements Builder {
        private List<DestinationConfigurationRequest> destinationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String encodingName;

        private EncodingParametersRequest encodingParameters;

        private String mediaStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaStreamOutputConfigurationRequest model) {
            destinationConfigurations(model.destinationConfigurations);
            encodingName(model.encodingName);
            encodingParameters(model.encodingParameters);
            mediaStreamName(model.mediaStreamName);
        }

        public final List<DestinationConfigurationRequest.Builder> getDestinationConfigurations() {
            List<DestinationConfigurationRequest.Builder> result = ___listOfDestinationConfigurationRequestCopier
                    .copyToBuilder(this.destinationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder destinationConfigurations(Collection<DestinationConfigurationRequest> destinationConfigurations) {
            this.destinationConfigurations = ___listOfDestinationConfigurationRequestCopier.copy(destinationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationConfigurations(DestinationConfigurationRequest... destinationConfigurations) {
            destinationConfigurations(Arrays.asList(destinationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationConfigurations(
                Consumer<DestinationConfigurationRequest.Builder>... destinationConfigurations) {
            destinationConfigurations(Stream.of(destinationConfigurations)
                    .map(c -> DestinationConfigurationRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDestinationConfigurations(
                Collection<DestinationConfigurationRequest.BuilderImpl> destinationConfigurations) {
            this.destinationConfigurations = ___listOfDestinationConfigurationRequestCopier
                    .copyFromBuilder(destinationConfigurations);
        }

        public final String getEncodingName() {
            return encodingName;
        }

        @Override
        public final Builder encodingName(String encodingName) {
            this.encodingName = encodingName;
            return this;
        }

        @Override
        public final Builder encodingName(EncodingName encodingName) {
            this.encodingName(encodingName == null ? null : encodingName.toString());
            return this;
        }

        public final void setEncodingName(String encodingName) {
            this.encodingName = encodingName;
        }

        public final EncodingParametersRequest.Builder getEncodingParameters() {
            return encodingParameters != null ? encodingParameters.toBuilder() : null;
        }

        @Override
        public final Builder encodingParameters(EncodingParametersRequest encodingParameters) {
            this.encodingParameters = encodingParameters;
            return this;
        }

        public final void setEncodingParameters(EncodingParametersRequest.BuilderImpl encodingParameters) {
            this.encodingParameters = encodingParameters != null ? encodingParameters.build() : null;
        }

        public final String getMediaStreamName() {
            return mediaStreamName;
        }

        @Override
        public final Builder mediaStreamName(String mediaStreamName) {
            this.mediaStreamName = mediaStreamName;
            return this;
        }

        public final void setMediaStreamName(String mediaStreamName) {
            this.mediaStreamName = mediaStreamName;
        }

        @Override
        public MediaStreamOutputConfigurationRequest build() {
            return new MediaStreamOutputConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
