/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The settings for a flow entitlement.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Entitlement implements SdkPojo, Serializable, ToCopyableBuilder<Entitlement.Builder, Entitlement> {
    private static final SdkField<Integer> DATA_TRANSFER_SUBSCRIBER_FEE_PERCENT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DataTransferSubscriberFeePercent")
            .getter(getter(Entitlement::dataTransferSubscriberFeePercent))
            .setter(setter(Builder::dataTransferSubscriberFeePercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTransferSubscriberFeePercent")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Entitlement::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.<Encryption> builder(MarshallingType.SDK_POJO)
            .memberName("Encryption").getter(getter(Entitlement::encryption)).setter(setter(Builder::encryption))
            .constructor(Encryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()).build();

    private static final SdkField<String> ENTITLEMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntitlementArn").getter(getter(Entitlement::entitlementArn)).setter(setter(Builder::entitlementArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlementArn").build()).build();

    private static final SdkField<String> ENTITLEMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntitlementStatus").getter(getter(Entitlement::entitlementStatusAsString))
            .setter(setter(Builder::entitlementStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlementStatus").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Entitlement::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> SUBSCRIBERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Subscribers")
            .getter(getter(Entitlement::subscribers))
            .setter(setter(Builder::subscribers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_TRANSFER_SUBSCRIBER_FEE_PERCENT_FIELD, DESCRIPTION_FIELD, ENCRYPTION_FIELD, ENTITLEMENT_ARN_FIELD,
            ENTITLEMENT_STATUS_FIELD, NAME_FIELD, SUBSCRIBERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer dataTransferSubscriberFeePercent;

    private final String description;

    private final Encryption encryption;

    private final String entitlementArn;

    private final String entitlementStatus;

    private final String name;

    private final List<String> subscribers;

    private Entitlement(BuilderImpl builder) {
        this.dataTransferSubscriberFeePercent = builder.dataTransferSubscriberFeePercent;
        this.description = builder.description;
        this.encryption = builder.encryption;
        this.entitlementArn = builder.entitlementArn;
        this.entitlementStatus = builder.entitlementStatus;
        this.name = builder.name;
        this.subscribers = builder.subscribers;
    }

    /**
     * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
     * 
     * @return Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
     */
    public final Integer dataTransferSubscriberFeePercent() {
        return dataTransferSubscriberFeePercent;
    }

    /**
     * A description of the entitlement.
     * 
     * @return A description of the entitlement.
     */
    public final String description() {
        return description;
    }

    /**
     * The type of encryption that will be used on the output that is associated with this entitlement.
     * 
     * @return The type of encryption that will be used on the output that is associated with this entitlement.
     */
    public final Encryption encryption() {
        return encryption;
    }

    /**
     * The ARN of the entitlement.
     * 
     * @return The ARN of the entitlement.
     */
    public final String entitlementArn() {
        return entitlementArn;
    }

    /**
     * An indication of whether the entitlement is enabled.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entitlementStatus}
     * will return {@link EntitlementStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #entitlementStatusAsString}.
     * </p>
     * 
     * @return An indication of whether the entitlement is enabled.
     * @see EntitlementStatus
     */
    public final EntitlementStatus entitlementStatus() {
        return EntitlementStatus.fromValue(entitlementStatus);
    }

    /**
     * An indication of whether the entitlement is enabled.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entitlementStatus}
     * will return {@link EntitlementStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #entitlementStatusAsString}.
     * </p>
     * 
     * @return An indication of whether the entitlement is enabled.
     * @see EntitlementStatus
     */
    public final String entitlementStatusAsString() {
        return entitlementStatus;
    }

    /**
     * The name of the entitlement.
     * 
     * @return The name of the entitlement.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subscribers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubscribers() {
        return subscribers != null && !(subscribers instanceof SdkAutoConstructList);
    }

    /**
     * The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be
     * allowed to create their own flow using your content as the source.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubscribers} method.
     * </p>
     * 
     * @return The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will
     *         be allowed to create their own flow using your content as the source.
     */
    public final List<String> subscribers() {
        return subscribers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataTransferSubscriberFeePercent());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(entitlementArn());
        hashCode = 31 * hashCode + Objects.hashCode(entitlementStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscribers() ? subscribers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entitlement)) {
            return false;
        }
        Entitlement other = (Entitlement) obj;
        return Objects.equals(dataTransferSubscriberFeePercent(), other.dataTransferSubscriberFeePercent())
                && Objects.equals(description(), other.description()) && Objects.equals(encryption(), other.encryption())
                && Objects.equals(entitlementArn(), other.entitlementArn())
                && Objects.equals(entitlementStatusAsString(), other.entitlementStatusAsString())
                && Objects.equals(name(), other.name()) && hasSubscribers() == other.hasSubscribers()
                && Objects.equals(subscribers(), other.subscribers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Entitlement").add("DataTransferSubscriberFeePercent", dataTransferSubscriberFeePercent())
                .add("Description", description()).add("Encryption", encryption()).add("EntitlementArn", entitlementArn())
                .add("EntitlementStatus", entitlementStatusAsString()).add("Name", name())
                .add("Subscribers", hasSubscribers() ? subscribers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataTransferSubscriberFeePercent":
            return Optional.ofNullable(clazz.cast(dataTransferSubscriberFeePercent()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "EntitlementArn":
            return Optional.ofNullable(clazz.cast(entitlementArn()));
        case "EntitlementStatus":
            return Optional.ofNullable(clazz.cast(entitlementStatusAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Subscribers":
            return Optional.ofNullable(clazz.cast(subscribers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Entitlement, T> g) {
        return obj -> g.apply((Entitlement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Entitlement> {
        /**
         * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
         * 
         * @param dataTransferSubscriberFeePercent
         *        Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTransferSubscriberFeePercent(Integer dataTransferSubscriberFeePercent);

        /**
         * A description of the entitlement.
         * 
         * @param description
         *        A description of the entitlement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The type of encryption that will be used on the output that is associated with this entitlement.
         * 
         * @param encryption
         *        The type of encryption that will be used on the output that is associated with this entitlement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(Encryption encryption);

        /**
         * The type of encryption that will be used on the output that is associated with this entitlement. This is a
         * convenience that creates an instance of the {@link Encryption.Builder} avoiding the need to create one
         * manually via {@link Encryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link Encryption.Builder#build()} is called immediately and its result
         * is passed to {@link #encryption(Encryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link Encryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(Encryption)
         */
        default Builder encryption(Consumer<Encryption.Builder> encryption) {
            return encryption(Encryption.builder().applyMutation(encryption).build());
        }

        /**
         * The ARN of the entitlement.
         * 
         * @param entitlementArn
         *        The ARN of the entitlement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlementArn(String entitlementArn);

        /**
         * An indication of whether the entitlement is enabled.
         * 
         * @param entitlementStatus
         *        An indication of whether the entitlement is enabled.
         * @see EntitlementStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntitlementStatus
         */
        Builder entitlementStatus(String entitlementStatus);

        /**
         * An indication of whether the entitlement is enabled.
         * 
         * @param entitlementStatus
         *        An indication of whether the entitlement is enabled.
         * @see EntitlementStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntitlementStatus
         */
        Builder entitlementStatus(EntitlementStatus entitlementStatus);

        /**
         * The name of the entitlement.
         * 
         * @param name
         *        The name of the entitlement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be
         * allowed to create their own flow using your content as the source.
         * 
         * @param subscribers
         *        The AWS account IDs that you want to share your content with. The receiving accounts (subscribers)
         *        will be allowed to create their own flow using your content as the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(Collection<String> subscribers);

        /**
         * The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be
         * allowed to create their own flow using your content as the source.
         * 
         * @param subscribers
         *        The AWS account IDs that you want to share your content with. The receiving accounts (subscribers)
         *        will be allowed to create their own flow using your content as the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(String... subscribers);
    }

    static final class BuilderImpl implements Builder {
        private Integer dataTransferSubscriberFeePercent;

        private String description;

        private Encryption encryption;

        private String entitlementArn;

        private String entitlementStatus;

        private String name;

        private List<String> subscribers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Entitlement model) {
            dataTransferSubscriberFeePercent(model.dataTransferSubscriberFeePercent);
            description(model.description);
            encryption(model.encryption);
            entitlementArn(model.entitlementArn);
            entitlementStatus(model.entitlementStatus);
            name(model.name);
            subscribers(model.subscribers);
        }

        public final Integer getDataTransferSubscriberFeePercent() {
            return dataTransferSubscriberFeePercent;
        }

        public final void setDataTransferSubscriberFeePercent(Integer dataTransferSubscriberFeePercent) {
            this.dataTransferSubscriberFeePercent = dataTransferSubscriberFeePercent;
        }

        @Override
        @Transient
        public final Builder dataTransferSubscriberFeePercent(Integer dataTransferSubscriberFeePercent) {
            this.dataTransferSubscriberFeePercent = dataTransferSubscriberFeePercent;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Encryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        @Transient
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final String getEntitlementArn() {
            return entitlementArn;
        }

        public final void setEntitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
        }

        @Override
        @Transient
        public final Builder entitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
            return this;
        }

        public final String getEntitlementStatus() {
            return entitlementStatus;
        }

        public final void setEntitlementStatus(String entitlementStatus) {
            this.entitlementStatus = entitlementStatus;
        }

        @Override
        @Transient
        public final Builder entitlementStatus(String entitlementStatus) {
            this.entitlementStatus = entitlementStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder entitlementStatus(EntitlementStatus entitlementStatus) {
            this.entitlementStatus(entitlementStatus == null ? null : entitlementStatus.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getSubscribers() {
            if (subscribers instanceof SdkAutoConstructList) {
                return null;
            }
            return subscribers;
        }

        public final void setSubscribers(Collection<String> subscribers) {
            this.subscribers = ___listOf__stringCopier.copy(subscribers);
        }

        @Override
        @Transient
        public final Builder subscribers(Collection<String> subscribers) {
            this.subscribers = ___listOf__stringCopier.copy(subscribers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subscribers(String... subscribers) {
            subscribers(Arrays.asList(subscribers));
            return this;
        }

        @Override
        public Entitlement build() {
            return new Entitlement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
