/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The media stream that is associated with the source, and the parameters for that association.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaStreamSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaStreamSourceConfiguration.Builder, MediaStreamSourceConfiguration> {
    private static final SdkField<String> ENCODING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncodingName").getter(getter(MediaStreamSourceConfiguration::encodingNameAsString))
            .setter(setter(Builder::encodingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encodingName").build()).build();

    private static final SdkField<List<InputConfiguration>> INPUT_CONFIGURATIONS_FIELD = SdkField
            .<List<InputConfiguration>> builder(MarshallingType.LIST)
            .memberName("InputConfigurations")
            .getter(getter(MediaStreamSourceConfiguration::inputConfigurations))
            .setter(setter(Builder::inputConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MEDIA_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaStreamName").getter(getter(MediaStreamSourceConfiguration::mediaStreamName))
            .setter(setter(Builder::mediaStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreamName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCODING_NAME_FIELD,
            INPUT_CONFIGURATIONS_FIELD, MEDIA_STREAM_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String encodingName;

    private final List<InputConfiguration> inputConfigurations;

    private final String mediaStreamName;

    private MediaStreamSourceConfiguration(BuilderImpl builder) {
        this.encodingName = builder.encodingName;
        this.inputConfigurations = builder.inputConfigurations;
        this.mediaStreamName = builder.mediaStreamName;
    }

    /**
     * The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For
     * audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video,
     * JPEG XS streams, set the encoding name to jxsv.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encodingName} will
     * return {@link EncodingName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #encodingNameAsString}.
     * </p>
     * 
     * @return The format that was used to encode the data. For ancillary data streams, set the encoding name to
     *         smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name
     *         to raw. For video, JPEG XS streams, set the encoding name to jxsv.
     * @see EncodingName
     */
    public final EncodingName encodingName() {
        return EncodingName.fromValue(encodingName);
    }

    /**
     * The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For
     * audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video,
     * JPEG XS streams, set the encoding name to jxsv.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encodingName} will
     * return {@link EncodingName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #encodingNameAsString}.
     * </p>
     * 
     * @return The format that was used to encode the data. For ancillary data streams, set the encoding name to
     *         smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name
     *         to raw. For video, JPEG XS streams, set the encoding name to jxsv.
     * @see EncodingName
     */
    public final String encodingNameAsString() {
        return encodingName;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputConfigurations() {
        return inputConfigurations != null && !(inputConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * The transport parameters that are associated with an incoming media stream.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputConfigurations} method.
     * </p>
     * 
     * @return The transport parameters that are associated with an incoming media stream.
     */
    public final List<InputConfiguration> inputConfigurations() {
        return inputConfigurations;
    }

    /**
     * The name of the media stream.
     * 
     * @return The name of the media stream.
     */
    public final String mediaStreamName() {
        return mediaStreamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encodingNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputConfigurations() ? inputConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(mediaStreamName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaStreamSourceConfiguration)) {
            return false;
        }
        MediaStreamSourceConfiguration other = (MediaStreamSourceConfiguration) obj;
        return Objects.equals(encodingNameAsString(), other.encodingNameAsString())
                && hasInputConfigurations() == other.hasInputConfigurations()
                && Objects.equals(inputConfigurations(), other.inputConfigurations())
                && Objects.equals(mediaStreamName(), other.mediaStreamName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaStreamSourceConfiguration").add("EncodingName", encodingNameAsString())
                .add("InputConfigurations", hasInputConfigurations() ? inputConfigurations() : null)
                .add("MediaStreamName", mediaStreamName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncodingName":
            return Optional.ofNullable(clazz.cast(encodingNameAsString()));
        case "InputConfigurations":
            return Optional.ofNullable(clazz.cast(inputConfigurations()));
        case "MediaStreamName":
            return Optional.ofNullable(clazz.cast(mediaStreamName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MediaStreamSourceConfiguration, T> g) {
        return obj -> g.apply((MediaStreamSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaStreamSourceConfiguration> {
        /**
         * The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291.
         * For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For
         * video, JPEG XS streams, set the encoding name to jxsv.
         * 
         * @param encodingName
         *        The format that was used to encode the data. For ancillary data streams, set the encoding name to
         *        smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding
         *        name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
         * @see EncodingName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingName
         */
        Builder encodingName(String encodingName);

        /**
         * The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291.
         * For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For
         * video, JPEG XS streams, set the encoding name to jxsv.
         * 
         * @param encodingName
         *        The format that was used to encode the data. For ancillary data streams, set the encoding name to
         *        smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding
         *        name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
         * @see EncodingName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingName
         */
        Builder encodingName(EncodingName encodingName);

        /**
         * The transport parameters that are associated with an incoming media stream.
         * 
         * @param inputConfigurations
         *        The transport parameters that are associated with an incoming media stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfigurations(Collection<InputConfiguration> inputConfigurations);

        /**
         * The transport parameters that are associated with an incoming media stream.
         * 
         * @param inputConfigurations
         *        The transport parameters that are associated with an incoming media stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfigurations(InputConfiguration... inputConfigurations);

        /**
         * The transport parameters that are associated with an incoming media stream. This is a convenience that
         * creates an instance of the {@link List<InputConfiguration>.Builder} avoiding the need to create one manually
         * via {@link List<InputConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InputConfiguration>.Builder#build()} is called immediately
         * and its result is passed to {@link #inputConfigurations(List<InputConfiguration>)}.
         * 
         * @param inputConfigurations
         *        a consumer that will call methods on {@link List<InputConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputConfigurations(List<InputConfiguration>)
         */
        Builder inputConfigurations(Consumer<InputConfiguration.Builder>... inputConfigurations);

        /**
         * The name of the media stream.
         * 
         * @param mediaStreamName
         *        The name of the media stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStreamName(String mediaStreamName);
    }

    static final class BuilderImpl implements Builder {
        private String encodingName;

        private List<InputConfiguration> inputConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String mediaStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaStreamSourceConfiguration model) {
            encodingName(model.encodingName);
            inputConfigurations(model.inputConfigurations);
            mediaStreamName(model.mediaStreamName);
        }

        public final String getEncodingName() {
            return encodingName;
        }

        public final void setEncodingName(String encodingName) {
            this.encodingName = encodingName;
        }

        @Override
        @Transient
        public final Builder encodingName(String encodingName) {
            this.encodingName = encodingName;
            return this;
        }

        @Override
        @Transient
        public final Builder encodingName(EncodingName encodingName) {
            this.encodingName(encodingName == null ? null : encodingName.toString());
            return this;
        }

        public final List<InputConfiguration.Builder> getInputConfigurations() {
            List<InputConfiguration.Builder> result = ___listOfInputConfigurationCopier.copyToBuilder(this.inputConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputConfigurations(Collection<InputConfiguration.BuilderImpl> inputConfigurations) {
            this.inputConfigurations = ___listOfInputConfigurationCopier.copyFromBuilder(inputConfigurations);
        }

        @Override
        @Transient
        public final Builder inputConfigurations(Collection<InputConfiguration> inputConfigurations) {
            this.inputConfigurations = ___listOfInputConfigurationCopier.copy(inputConfigurations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inputConfigurations(InputConfiguration... inputConfigurations) {
            inputConfigurations(Arrays.asList(inputConfigurations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inputConfigurations(Consumer<InputConfiguration.Builder>... inputConfigurations) {
            inputConfigurations(Stream.of(inputConfigurations).map(c -> InputConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMediaStreamName() {
            return mediaStreamName;
        }

        public final void setMediaStreamName(String mediaStreamName) {
            this.mediaStreamName = mediaStreamName;
        }

        @Override
        @Transient
        public final Builder mediaStreamName(String mediaStreamName) {
            this.mediaStreamName = mediaStreamName;
            return this;
        }

        @Override
        public MediaStreamSourceConfiguration build() {
            return new MediaStreamSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
