/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to update the source of a flow.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFlowSourceRequest extends MediaConnectRequest implements
        ToCopyableBuilder<UpdateFlowSourceRequest.Builder, UpdateFlowSourceRequest> {
    private static final SdkField<UpdateEncryption> DECRYPTION_FIELD = SdkField
            .<UpdateEncryption> builder(MarshallingType.SDK_POJO).memberName("Decryption")
            .getter(getter(UpdateFlowSourceRequest::decryption)).setter(setter(Builder::decryption))
            .constructor(UpdateEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decryption").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateFlowSourceRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENTITLEMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntitlementArn").getter(getter(UpdateFlowSourceRequest::entitlementArn))
            .setter(setter(Builder::entitlementArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlementArn").build()).build();

    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(UpdateFlowSourceRequest::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowArn").build()).build();

    private static final SdkField<Integer> INGEST_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("IngestPort").getter(getter(UpdateFlowSourceRequest::ingestPort)).setter(setter(Builder::ingestPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestPort").build()).build();

    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxBitrate").getter(getter(UpdateFlowSourceRequest::maxBitrate)).setter(setter(Builder::maxBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()).build();

    private static final SdkField<Integer> MAX_LATENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxLatency").getter(getter(UpdateFlowSourceRequest::maxLatency)).setter(setter(Builder::maxLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLatency").build()).build();

    private static final SdkField<Integer> MAX_SYNC_BUFFER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSyncBuffer").getter(getter(UpdateFlowSourceRequest::maxSyncBuffer))
            .setter(setter(Builder::maxSyncBuffer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSyncBuffer").build()).build();

    private static final SdkField<List<MediaStreamSourceConfigurationRequest>> MEDIA_STREAM_SOURCE_CONFIGURATIONS_FIELD = SdkField
            .<List<MediaStreamSourceConfigurationRequest>> builder(MarshallingType.LIST)
            .memberName("MediaStreamSourceConfigurations")
            .getter(getter(UpdateFlowSourceRequest::mediaStreamSourceConfigurations))
            .setter(setter(Builder::mediaStreamSourceConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreamSourceConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MediaStreamSourceConfigurationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaStreamSourceConfigurationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MIN_LATENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinLatency").getter(getter(UpdateFlowSourceRequest::minLatency)).setter(setter(Builder::minLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minLatency").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(UpdateFlowSourceRequest::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<Integer> SENDER_CONTROL_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SenderControlPort").getter(getter(UpdateFlowSourceRequest::senderControlPort))
            .setter(setter(Builder::senderControlPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("senderControlPort").build()).build();

    private static final SdkField<String> SENDER_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SenderIpAddress").getter(getter(UpdateFlowSourceRequest::senderIpAddress))
            .setter(setter(Builder::senderIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("senderIpAddress").build()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceArn").getter(getter(UpdateFlowSourceRequest::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sourceArn").build()).build();

    private static final SdkField<String> STREAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamId").getter(getter(UpdateFlowSourceRequest::streamId)).setter(setter(Builder::streamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()).build();

    private static final SdkField<String> VPC_INTERFACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcInterfaceName").getter(getter(UpdateFlowSourceRequest::vpcInterfaceName))
            .setter(setter(Builder::vpcInterfaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaceName").build()).build();

    private static final SdkField<String> WHITELIST_CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WhitelistCidr").getter(getter(UpdateFlowSourceRequest::whitelistCidr))
            .setter(setter(Builder::whitelistCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("whitelistCidr").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECRYPTION_FIELD,
            DESCRIPTION_FIELD, ENTITLEMENT_ARN_FIELD, FLOW_ARN_FIELD, INGEST_PORT_FIELD, MAX_BITRATE_FIELD, MAX_LATENCY_FIELD,
            MAX_SYNC_BUFFER_FIELD, MEDIA_STREAM_SOURCE_CONFIGURATIONS_FIELD, MIN_LATENCY_FIELD, PROTOCOL_FIELD,
            SENDER_CONTROL_PORT_FIELD, SENDER_IP_ADDRESS_FIELD, SOURCE_ARN_FIELD, STREAM_ID_FIELD, VPC_INTERFACE_NAME_FIELD,
            WHITELIST_CIDR_FIELD));

    private final UpdateEncryption decryption;

    private final String description;

    private final String entitlementArn;

    private final String flowArn;

    private final Integer ingestPort;

    private final Integer maxBitrate;

    private final Integer maxLatency;

    private final Integer maxSyncBuffer;

    private final List<MediaStreamSourceConfigurationRequest> mediaStreamSourceConfigurations;

    private final Integer minLatency;

    private final String protocol;

    private final Integer senderControlPort;

    private final String senderIpAddress;

    private final String sourceArn;

    private final String streamId;

    private final String vpcInterfaceName;

    private final String whitelistCidr;

    private UpdateFlowSourceRequest(BuilderImpl builder) {
        super(builder);
        this.decryption = builder.decryption;
        this.description = builder.description;
        this.entitlementArn = builder.entitlementArn;
        this.flowArn = builder.flowArn;
        this.ingestPort = builder.ingestPort;
        this.maxBitrate = builder.maxBitrate;
        this.maxLatency = builder.maxLatency;
        this.maxSyncBuffer = builder.maxSyncBuffer;
        this.mediaStreamSourceConfigurations = builder.mediaStreamSourceConfigurations;
        this.minLatency = builder.minLatency;
        this.protocol = builder.protocol;
        this.senderControlPort = builder.senderControlPort;
        this.senderIpAddress = builder.senderIpAddress;
        this.sourceArn = builder.sourceArn;
        this.streamId = builder.streamId;
        this.vpcInterfaceName = builder.vpcInterfaceName;
        this.whitelistCidr = builder.whitelistCidr;
    }

    /**
     * The type of encryption used on the content ingested from this source.
     * 
     * @return The type of encryption used on the content ingested from this source.
     */
    public final UpdateEncryption decryption() {
        return decryption;
    }

    /**
     * A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect
     * account.
     * 
     * @return A description for the source. This value is not used or seen outside of the current AWS Elemental
     *         MediaConnect account.
     */
    public final String description() {
        return description;
    }

    /**
     * The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow
     * originator, and the ARN is generated as part of the originator's flow.
     * 
     * @return The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow
     *         originator, and the ARN is generated as part of the originator's flow.
     */
    public final String entitlementArn() {
        return entitlementArn;
    }

    /**
     * The flow that is associated with the source that you want to update.
     * 
     * @return The flow that is associated with the source that you want to update.
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * The port that the flow will be listening on for incoming content.
     * 
     * @return The port that the flow will be listening on for incoming content.
     */
    public final Integer ingestPort() {
        return ingestPort;
    }

    /**
     * The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
     * 
     * @return The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
     */
    public final Integer maxBitrate() {
        return maxBitrate;
    }

    /**
     * The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based
     * streams.
     * 
     * @return The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and
     *         Fujitsu-based streams.
     */
    public final Integer maxLatency() {
        return maxLatency;
    }

    /**
     * The size of the buffer (in milliseconds) to use to sync incoming source data.
     * 
     * @return The size of the buffer (in milliseconds) to use to sync incoming source data.
     */
    public final Integer maxSyncBuffer() {
        return maxSyncBuffer;
    }

    /**
     * For responses, this returns true if the service returned a value for the MediaStreamSourceConfigurations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasMediaStreamSourceConfigurations() {
        return mediaStreamSourceConfigurations != null && !(mediaStreamSourceConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * The media streams that are associated with the source, and the parameters for those associations.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMediaStreamSourceConfigurations}
     * method.
     * </p>
     * 
     * @return The media streams that are associated with the source, and the parameters for those associations.
     */
    public final List<MediaStreamSourceConfigurationRequest> mediaStreamSourceConfigurations() {
        return mediaStreamSourceConfigurations;
    }

    /**
     * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that
     * you set on your MediaConnect source or output represents the minimal potential latency of that connection. The
     * latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s
     * minimum latency.
     * 
     * @return The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this
     *         value that you set on your MediaConnect source or output represents the minimal potential latency of that
     *         connection. The latency of the stream is set to the highest number between the sender’s minimum latency
     *         and the receiver’s minimum latency.
     */
    public final Integer minLatency() {
        return minLatency;
    }

    /**
     * The protocol that is used by the source.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol that is used by the source.
     * @see Protocol
     */
    public final Protocol protocol() {
        return Protocol.fromValue(protocol);
    }

    /**
     * The protocol that is used by the source.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol that is used by the source.
     * @see Protocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * The port that the flow uses to send outbound requests to initiate connection with the sender.
     * 
     * @return The port that the flow uses to send outbound requests to initiate connection with the sender.
     */
    public final Integer senderControlPort() {
        return senderControlPort;
    }

    /**
     * The IP address that the flow communicates with to initiate connection with the sender.
     * 
     * @return The IP address that the flow communicates with to initiate connection with the sender.
     */
    public final String senderIpAddress() {
        return senderIpAddress;
    }

    /**
     * The ARN of the source that you want to update.
     * 
     * @return The ARN of the source that you want to update.
     */
    public final String sourceArn() {
        return sourceArn;
    }

    /**
     * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
     * 
     * @return The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
     */
    public final String streamId() {
        return streamId;
    }

    /**
     * The name of the VPC interface to use for this source.
     * 
     * @return The name of the VPC interface to use for this source.
     */
    public final String vpcInterfaceName() {
        return vpcInterfaceName;
    }

    /**
     * The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should
     * be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     * 
     * @return The range of IP addresses that should be allowed to contribute content to your source. These IP addresses
     *         should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     */
    public final String whitelistCidr() {
        return whitelistCidr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(decryption());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(entitlementArn());
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(ingestPort());
        hashCode = 31 * hashCode + Objects.hashCode(maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(maxLatency());
        hashCode = 31 * hashCode + Objects.hashCode(maxSyncBuffer());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasMediaStreamSourceConfigurations() ? mediaStreamSourceConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(minLatency());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(senderControlPort());
        hashCode = 31 * hashCode + Objects.hashCode(senderIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(streamId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcInterfaceName());
        hashCode = 31 * hashCode + Objects.hashCode(whitelistCidr());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowSourceRequest)) {
            return false;
        }
        UpdateFlowSourceRequest other = (UpdateFlowSourceRequest) obj;
        return Objects.equals(decryption(), other.decryption()) && Objects.equals(description(), other.description())
                && Objects.equals(entitlementArn(), other.entitlementArn()) && Objects.equals(flowArn(), other.flowArn())
                && Objects.equals(ingestPort(), other.ingestPort()) && Objects.equals(maxBitrate(), other.maxBitrate())
                && Objects.equals(maxLatency(), other.maxLatency()) && Objects.equals(maxSyncBuffer(), other.maxSyncBuffer())
                && hasMediaStreamSourceConfigurations() == other.hasMediaStreamSourceConfigurations()
                && Objects.equals(mediaStreamSourceConfigurations(), other.mediaStreamSourceConfigurations())
                && Objects.equals(minLatency(), other.minLatency())
                && Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(senderControlPort(), other.senderControlPort())
                && Objects.equals(senderIpAddress(), other.senderIpAddress()) && Objects.equals(sourceArn(), other.sourceArn())
                && Objects.equals(streamId(), other.streamId()) && Objects.equals(vpcInterfaceName(), other.vpcInterfaceName())
                && Objects.equals(whitelistCidr(), other.whitelistCidr());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateFlowSourceRequest")
                .add("Decryption", decryption())
                .add("Description", description())
                .add("EntitlementArn", entitlementArn())
                .add("FlowArn", flowArn())
                .add("IngestPort", ingestPort())
                .add("MaxBitrate", maxBitrate())
                .add("MaxLatency", maxLatency())
                .add("MaxSyncBuffer", maxSyncBuffer())
                .add("MediaStreamSourceConfigurations",
                        hasMediaStreamSourceConfigurations() ? mediaStreamSourceConfigurations() : null)
                .add("MinLatency", minLatency()).add("Protocol", protocolAsString())
                .add("SenderControlPort", senderControlPort()).add("SenderIpAddress", senderIpAddress())
                .add("SourceArn", sourceArn()).add("StreamId", streamId()).add("VpcInterfaceName", vpcInterfaceName())
                .add("WhitelistCidr", whitelistCidr()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Decryption":
            return Optional.ofNullable(clazz.cast(decryption()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EntitlementArn":
            return Optional.ofNullable(clazz.cast(entitlementArn()));
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "IngestPort":
            return Optional.ofNullable(clazz.cast(ingestPort()));
        case "MaxBitrate":
            return Optional.ofNullable(clazz.cast(maxBitrate()));
        case "MaxLatency":
            return Optional.ofNullable(clazz.cast(maxLatency()));
        case "MaxSyncBuffer":
            return Optional.ofNullable(clazz.cast(maxSyncBuffer()));
        case "MediaStreamSourceConfigurations":
            return Optional.ofNullable(clazz.cast(mediaStreamSourceConfigurations()));
        case "MinLatency":
            return Optional.ofNullable(clazz.cast(minLatency()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "SenderControlPort":
            return Optional.ofNullable(clazz.cast(senderControlPort()));
        case "SenderIpAddress":
            return Optional.ofNullable(clazz.cast(senderIpAddress()));
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "StreamId":
            return Optional.ofNullable(clazz.cast(streamId()));
        case "VpcInterfaceName":
            return Optional.ofNullable(clazz.cast(vpcInterfaceName()));
        case "WhitelistCidr":
            return Optional.ofNullable(clazz.cast(whitelistCidr()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowSourceRequest, T> g) {
        return obj -> g.apply((UpdateFlowSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFlowSourceRequest> {
        /**
         * The type of encryption used on the content ingested from this source.
         * 
         * @param decryption
         *        The type of encryption used on the content ingested from this source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decryption(UpdateEncryption decryption);

        /**
         * The type of encryption used on the content ingested from this source. This is a convenience that creates an
         * instance of the {@link UpdateEncryption.Builder} avoiding the need to create one manually via
         * {@link UpdateEncryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateEncryption.Builder#build()} is called immediately and its
         * result is passed to {@link #decryption(UpdateEncryption)}.
         * 
         * @param decryption
         *        a consumer that will call methods on {@link UpdateEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #decryption(UpdateEncryption)
         */
        default Builder decryption(Consumer<UpdateEncryption.Builder> decryption) {
            return decryption(UpdateEncryption.builder().applyMutation(decryption).build());
        }

        /**
         * A description for the source. This value is not used or seen outside of the current AWS Elemental
         * MediaConnect account.
         * 
         * @param description
         *        A description for the source. This value is not used or seen outside of the current AWS Elemental
         *        MediaConnect account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow
         * originator, and the ARN is generated as part of the originator's flow.
         * 
         * @param entitlementArn
         *        The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the
         *        flow originator, and the ARN is generated as part of the originator's flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlementArn(String entitlementArn);

        /**
         * The flow that is associated with the source that you want to update.
         * 
         * @param flowArn
         *        The flow that is associated with the source that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * The port that the flow will be listening on for incoming content.
         * 
         * @param ingestPort
         *        The port that the flow will be listening on for incoming content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestPort(Integer ingestPort);

        /**
         * The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
         * 
         * @param maxBitrate
         *        The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBitrate(Integer maxBitrate);

        /**
         * The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based
         * streams.
         * 
         * @param maxLatency
         *        The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and
         *        Fujitsu-based streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxLatency(Integer maxLatency);

        /**
         * The size of the buffer (in milliseconds) to use to sync incoming source data.
         * 
         * @param maxSyncBuffer
         *        The size of the buffer (in milliseconds) to use to sync incoming source data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSyncBuffer(Integer maxSyncBuffer);

        /**
         * The media streams that are associated with the source, and the parameters for those associations.
         * 
         * @param mediaStreamSourceConfigurations
         *        The media streams that are associated with the source, and the parameters for those associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStreamSourceConfigurations(Collection<MediaStreamSourceConfigurationRequest> mediaStreamSourceConfigurations);

        /**
         * The media streams that are associated with the source, and the parameters for those associations.
         * 
         * @param mediaStreamSourceConfigurations
         *        The media streams that are associated with the source, and the parameters for those associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStreamSourceConfigurations(MediaStreamSourceConfigurationRequest... mediaStreamSourceConfigurations);

        /**
         * The media streams that are associated with the source, and the parameters for those associations. This is a
         * convenience that creates an instance of the {@link List<MediaStreamSourceConfigurationRequest>.Builder}
         * avoiding the need to create one manually via {@link List<MediaStreamSourceConfigurationRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MediaStreamSourceConfigurationRequest>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #mediaStreamSourceConfigurations(List<MediaStreamSourceConfigurationRequest>)}.
         * 
         * @param mediaStreamSourceConfigurations
         *        a consumer that will call methods on {@link List<MediaStreamSourceConfigurationRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaStreamSourceConfigurations(List<MediaStreamSourceConfigurationRequest>)
         */
        Builder mediaStreamSourceConfigurations(
                Consumer<MediaStreamSourceConfigurationRequest.Builder>... mediaStreamSourceConfigurations);

        /**
         * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value
         * that you set on your MediaConnect source or output represents the minimal potential latency of that
         * connection. The latency of the stream is set to the highest number between the sender’s minimum latency and
         * the receiver’s minimum latency.
         * 
         * @param minLatency
         *        The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this
         *        value that you set on your MediaConnect source or output represents the minimal potential latency of
         *        that connection. The latency of the stream is set to the highest number between the sender’s minimum
         *        latency and the receiver’s minimum latency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minLatency(Integer minLatency);

        /**
         * The protocol that is used by the source.
         * 
         * @param protocol
         *        The protocol that is used by the source.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * The protocol that is used by the source.
         * 
         * @param protocol
         *        The protocol that is used by the source.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);

        /**
         * The port that the flow uses to send outbound requests to initiate connection with the sender.
         * 
         * @param senderControlPort
         *        The port that the flow uses to send outbound requests to initiate connection with the sender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderControlPort(Integer senderControlPort);

        /**
         * The IP address that the flow communicates with to initiate connection with the sender.
         * 
         * @param senderIpAddress
         *        The IP address that the flow communicates with to initiate connection with the sender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderIpAddress(String senderIpAddress);

        /**
         * The ARN of the source that you want to update.
         * 
         * @param sourceArn
         *        The ARN of the source that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
         * 
         * @param streamId
         *        The stream ID that you want to use for this transport. This parameter applies only to Zixi-based
         *        streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamId(String streamId);

        /**
         * The name of the VPC interface to use for this source.
         * 
         * @param vpcInterfaceName
         *        The name of the VPC interface to use for this source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcInterfaceName(String vpcInterfaceName);

        /**
         * The range of IP addresses that should be allowed to contribute content to your source. These IP addresses
         * should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         * 
         * @param whitelistCidr
         *        The range of IP addresses that should be allowed to contribute content to your source. These IP
         *        addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example,
         *        10.0.0.0/16.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whitelistCidr(String whitelistCidr);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConnectRequest.BuilderImpl implements Builder {
        private UpdateEncryption decryption;

        private String description;

        private String entitlementArn;

        private String flowArn;

        private Integer ingestPort;

        private Integer maxBitrate;

        private Integer maxLatency;

        private Integer maxSyncBuffer;

        private List<MediaStreamSourceConfigurationRequest> mediaStreamSourceConfigurations = DefaultSdkAutoConstructList
                .getInstance();

        private Integer minLatency;

        private String protocol;

        private Integer senderControlPort;

        private String senderIpAddress;

        private String sourceArn;

        private String streamId;

        private String vpcInterfaceName;

        private String whitelistCidr;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowSourceRequest model) {
            super(model);
            decryption(model.decryption);
            description(model.description);
            entitlementArn(model.entitlementArn);
            flowArn(model.flowArn);
            ingestPort(model.ingestPort);
            maxBitrate(model.maxBitrate);
            maxLatency(model.maxLatency);
            maxSyncBuffer(model.maxSyncBuffer);
            mediaStreamSourceConfigurations(model.mediaStreamSourceConfigurations);
            minLatency(model.minLatency);
            protocol(model.protocol);
            senderControlPort(model.senderControlPort);
            senderIpAddress(model.senderIpAddress);
            sourceArn(model.sourceArn);
            streamId(model.streamId);
            vpcInterfaceName(model.vpcInterfaceName);
            whitelistCidr(model.whitelistCidr);
        }

        public final UpdateEncryption.Builder getDecryption() {
            return decryption != null ? decryption.toBuilder() : null;
        }

        public final void setDecryption(UpdateEncryption.BuilderImpl decryption) {
            this.decryption = decryption != null ? decryption.build() : null;
        }

        @Override
        @Transient
        public final Builder decryption(UpdateEncryption decryption) {
            this.decryption = decryption;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEntitlementArn() {
            return entitlementArn;
        }

        public final void setEntitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
        }

        @Override
        @Transient
        public final Builder entitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
            return this;
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        @Transient
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final Integer getIngestPort() {
            return ingestPort;
        }

        public final void setIngestPort(Integer ingestPort) {
            this.ingestPort = ingestPort;
        }

        @Override
        @Transient
        public final Builder ingestPort(Integer ingestPort) {
            this.ingestPort = ingestPort;
            return this;
        }

        public final Integer getMaxBitrate() {
            return maxBitrate;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        @Override
        @Transient
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final Integer getMaxLatency() {
            return maxLatency;
        }

        public final void setMaxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
        }

        @Override
        @Transient
        public final Builder maxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
            return this;
        }

        public final Integer getMaxSyncBuffer() {
            return maxSyncBuffer;
        }

        public final void setMaxSyncBuffer(Integer maxSyncBuffer) {
            this.maxSyncBuffer = maxSyncBuffer;
        }

        @Override
        @Transient
        public final Builder maxSyncBuffer(Integer maxSyncBuffer) {
            this.maxSyncBuffer = maxSyncBuffer;
            return this;
        }

        public final List<MediaStreamSourceConfigurationRequest.Builder> getMediaStreamSourceConfigurations() {
            List<MediaStreamSourceConfigurationRequest.Builder> result = ___listOfMediaStreamSourceConfigurationRequestCopier
                    .copyToBuilder(this.mediaStreamSourceConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaStreamSourceConfigurations(
                Collection<MediaStreamSourceConfigurationRequest.BuilderImpl> mediaStreamSourceConfigurations) {
            this.mediaStreamSourceConfigurations = ___listOfMediaStreamSourceConfigurationRequestCopier
                    .copyFromBuilder(mediaStreamSourceConfigurations);
        }

        @Override
        @Transient
        public final Builder mediaStreamSourceConfigurations(
                Collection<MediaStreamSourceConfigurationRequest> mediaStreamSourceConfigurations) {
            this.mediaStreamSourceConfigurations = ___listOfMediaStreamSourceConfigurationRequestCopier
                    .copy(mediaStreamSourceConfigurations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder mediaStreamSourceConfigurations(
                MediaStreamSourceConfigurationRequest... mediaStreamSourceConfigurations) {
            mediaStreamSourceConfigurations(Arrays.asList(mediaStreamSourceConfigurations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder mediaStreamSourceConfigurations(
                Consumer<MediaStreamSourceConfigurationRequest.Builder>... mediaStreamSourceConfigurations) {
            mediaStreamSourceConfigurations(Stream.of(mediaStreamSourceConfigurations)
                    .map(c -> MediaStreamSourceConfigurationRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getMinLatency() {
            return minLatency;
        }

        public final void setMinLatency(Integer minLatency) {
            this.minLatency = minLatency;
        }

        @Override
        @Transient
        public final Builder minLatency(Integer minLatency) {
            this.minLatency = minLatency;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        @Transient
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        @Transient
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Integer getSenderControlPort() {
            return senderControlPort;
        }

        public final void setSenderControlPort(Integer senderControlPort) {
            this.senderControlPort = senderControlPort;
        }

        @Override
        @Transient
        public final Builder senderControlPort(Integer senderControlPort) {
            this.senderControlPort = senderControlPort;
            return this;
        }

        public final String getSenderIpAddress() {
            return senderIpAddress;
        }

        public final void setSenderIpAddress(String senderIpAddress) {
            this.senderIpAddress = senderIpAddress;
        }

        @Override
        @Transient
        public final Builder senderIpAddress(String senderIpAddress) {
            this.senderIpAddress = senderIpAddress;
            return this;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        @Transient
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getStreamId() {
            return streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        @Transient
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final String getVpcInterfaceName() {
            return vpcInterfaceName;
        }

        public final void setVpcInterfaceName(String vpcInterfaceName) {
            this.vpcInterfaceName = vpcInterfaceName;
        }

        @Override
        @Transient
        public final Builder vpcInterfaceName(String vpcInterfaceName) {
            this.vpcInterfaceName = vpcInterfaceName;
            return this;
        }

        public final String getWhitelistCidr() {
            return whitelistCidr;
        }

        public final void setWhitelistCidr(String whitelistCidr) {
            this.whitelistCidr = whitelistCidr;
        }

        @Override
        @Transient
        public final Builder whitelistCidr(String whitelistCidr) {
            this.whitelistCidr = whitelistCidr;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFlowSourceRequest build() {
            return new UpdateFlowSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
