/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to add sources to the flow.
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddFlowSourcesRequest extends MediaConnectRequest implements
        ToCopyableBuilder<AddFlowSourcesRequest.Builder, AddFlowSourcesRequest> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(AddFlowSourcesRequest::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowArn").build()).build();

    private static final SdkField<List<SetSourceRequest>> SOURCES_FIELD = SdkField
            .<List<SetSourceRequest>> builder(MarshallingType.LIST)
            .memberName("Sources")
            .getter(getter(AddFlowSourcesRequest::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SetSourceRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(SetSourceRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(FLOW_ARN_FIELD, SOURCES_FIELD));

    private final String flowArn;

    private final List<SetSourceRequest> sources;

    private AddFlowSourcesRequest(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.sources = builder.sources;
    }

    /**
     * The flow that you want to mutate.
     * 
     * @return The flow that you want to mutate.
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * A list of sources that you want to add.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return A list of sources that you want to add.
     */
    public final List<SetSourceRequest> sources() {
        return sources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddFlowSourcesRequest)) {
            return false;
        }
        AddFlowSourcesRequest other = (AddFlowSourcesRequest) obj;
        return Objects.equals(flowArn(), other.flowArn()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddFlowSourcesRequest").add("FlowArn", flowArn())
                .add("Sources", hasSources() ? sources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "Sources":
            return Optional.ofNullable(clazz.cast(sources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddFlowSourcesRequest, T> g) {
        return obj -> g.apply((AddFlowSourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddFlowSourcesRequest> {
        /**
         * The flow that you want to mutate.
         * 
         * @param flowArn
         *        The flow that you want to mutate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * A list of sources that you want to add.
         * 
         * @param sources
         *        A list of sources that you want to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<SetSourceRequest> sources);

        /**
         * A list of sources that you want to add.
         * 
         * @param sources
         *        A list of sources that you want to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(SetSourceRequest... sources);

        /**
         * A list of sources that you want to add. This is a convenience method that creates an instance of the
         * {@link List<SetSourceRequest>.Builder} avoiding the need to create one manually via {@link List
         * <SetSourceRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SetSourceRequest>.Builder#build()} is called immediately and
         * its result is passed to {@link #sources(List<SetSourceRequest>)}.
         * 
         * @param sources
         *        a consumer that will call methods on {@link List<SetSourceRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(List<SetSourceRequest>)
         */
        Builder sources(Consumer<SetSourceRequest.Builder>... sources);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConnectRequest.BuilderImpl implements Builder {
        private String flowArn;

        private List<SetSourceRequest> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddFlowSourcesRequest model) {
            super(model);
            flowArn(model.flowArn);
            sources(model.sources);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final List<SetSourceRequest.Builder> getSources() {
            List<SetSourceRequest.Builder> result = ___listOfSetSourceRequestCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<SetSourceRequest.BuilderImpl> sources) {
            this.sources = ___listOfSetSourceRequestCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<SetSourceRequest> sources) {
            this.sources = ___listOfSetSourceRequestCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(SetSourceRequest... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<SetSourceRequest.Builder>... sources) {
            sources(Stream.of(sources).map(c -> SetSourceRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddFlowSourcesRequest build() {
            return new AddFlowSourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
