/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFlowEntitlementResponse extends MediaConnectResponse implements
        ToCopyableBuilder<UpdateFlowEntitlementResponse.Builder, UpdateFlowEntitlementResponse> {
    private static final SdkField<Entitlement> ENTITLEMENT_FIELD = SdkField.<Entitlement> builder(MarshallingType.SDK_POJO)
            .memberName("Entitlement").getter(getter(UpdateFlowEntitlementResponse::entitlement))
            .setter(setter(Builder::entitlement)).constructor(Entitlement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlement").build()).build();

    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(UpdateFlowEntitlementResponse::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITLEMENT_FIELD,
            FLOW_ARN_FIELD));

    private final Entitlement entitlement;

    private final String flowArn;

    private UpdateFlowEntitlementResponse(BuilderImpl builder) {
        super(builder);
        this.entitlement = builder.entitlement;
        this.flowArn = builder.flowArn;
    }

    /**
     * The new configuration of the entitlement that you updated.
     * 
     * @return The new configuration of the entitlement that you updated.
     */
    public final Entitlement entitlement() {
        return entitlement;
    }

    /**
     * The ARN of the flow that this entitlement was granted on.
     * 
     * @return The ARN of the flow that this entitlement was granted on.
     */
    public final String flowArn() {
        return flowArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(entitlement());
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowEntitlementResponse)) {
            return false;
        }
        UpdateFlowEntitlementResponse other = (UpdateFlowEntitlementResponse) obj;
        return Objects.equals(entitlement(), other.entitlement()) && Objects.equals(flowArn(), other.flowArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFlowEntitlementResponse").add("Entitlement", entitlement()).add("FlowArn", flowArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Entitlement":
            return Optional.ofNullable(clazz.cast(entitlement()));
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowEntitlementResponse, T> g) {
        return obj -> g.apply((UpdateFlowEntitlementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateFlowEntitlementResponse> {
        /**
         * The new configuration of the entitlement that you updated.
         * 
         * @param entitlement
         *        The new configuration of the entitlement that you updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlement(Entitlement entitlement);

        /**
         * The new configuration of the entitlement that you updated. This is a convenience method that creates an
         * instance of the {@link Entitlement.Builder} avoiding the need to create one manually via
         * {@link Entitlement#builder()}.
         *
         * When the {@link Consumer} completes, {@link Entitlement.Builder#build()} is called immediately and its result
         * is passed to {@link #entitlement(Entitlement)}.
         * 
         * @param entitlement
         *        a consumer that will call methods on {@link Entitlement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entitlement(Entitlement)
         */
        default Builder entitlement(Consumer<Entitlement.Builder> entitlement) {
            return entitlement(Entitlement.builder().applyMutation(entitlement).build());
        }

        /**
         * The ARN of the flow that this entitlement was granted on.
         * 
         * @param flowArn
         *        The ARN of the flow that this entitlement was granted on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private Entitlement entitlement;

        private String flowArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowEntitlementResponse model) {
            super(model);
            entitlement(model.entitlement);
            flowArn(model.flowArn);
        }

        public final Entitlement.Builder getEntitlement() {
            return entitlement != null ? entitlement.toBuilder() : null;
        }

        public final void setEntitlement(Entitlement.BuilderImpl entitlement) {
            this.entitlement = entitlement != null ? entitlement.build() : null;
        }

        @Override
        public final Builder entitlement(Entitlement entitlement) {
            this.entitlement = entitlement;
            return this;
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        @Override
        public UpdateFlowEntitlementResponse build() {
            return new UpdateFlowEntitlementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
