/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFlowMediaStreamResponse extends MediaConnectResponse implements
        ToCopyableBuilder<UpdateFlowMediaStreamResponse.Builder, UpdateFlowMediaStreamResponse> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(UpdateFlowMediaStreamResponse::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final SdkField<MediaStream> MEDIA_STREAM_FIELD = SdkField.<MediaStream> builder(MarshallingType.SDK_POJO)
            .memberName("MediaStream").getter(getter(UpdateFlowMediaStreamResponse::mediaStream))
            .setter(setter(Builder::mediaStream)).constructor(MediaStream::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStream").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD,
            MEDIA_STREAM_FIELD));

    private final String flowArn;

    private final MediaStream mediaStream;

    private UpdateFlowMediaStreamResponse(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.mediaStream = builder.mediaStream;
    }

    /**
     * The ARN of the flow that is associated with the media stream that you updated.
     * 
     * @return The ARN of the flow that is associated with the media stream that you updated.
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * The media stream that you updated.
     * 
     * @return The media stream that you updated.
     */
    public final MediaStream mediaStream() {
        return mediaStream;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(mediaStream());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowMediaStreamResponse)) {
            return false;
        }
        UpdateFlowMediaStreamResponse other = (UpdateFlowMediaStreamResponse) obj;
        return Objects.equals(flowArn(), other.flowArn()) && Objects.equals(mediaStream(), other.mediaStream());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFlowMediaStreamResponse").add("FlowArn", flowArn()).add("MediaStream", mediaStream())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "MediaStream":
            return Optional.ofNullable(clazz.cast(mediaStream()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowMediaStreamResponse, T> g) {
        return obj -> g.apply((UpdateFlowMediaStreamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateFlowMediaStreamResponse> {
        /**
         * The ARN of the flow that is associated with the media stream that you updated.
         * 
         * @param flowArn
         *        The ARN of the flow that is associated with the media stream that you updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * The media stream that you updated.
         * 
         * @param mediaStream
         *        The media stream that you updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStream(MediaStream mediaStream);

        /**
         * The media stream that you updated. This is a convenience method that creates an instance of the
         * {@link MediaStream.Builder} avoiding the need to create one manually via {@link MediaStream#builder()}.
         *
         * When the {@link Consumer} completes, {@link MediaStream.Builder#build()} is called immediately and its result
         * is passed to {@link #mediaStream(MediaStream)}.
         * 
         * @param mediaStream
         *        a consumer that will call methods on {@link MediaStream.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaStream(MediaStream)
         */
        default Builder mediaStream(Consumer<MediaStream.Builder> mediaStream) {
            return mediaStream(MediaStream.builder().applyMutation(mediaStream).build());
        }
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private String flowArn;

        private MediaStream mediaStream;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowMediaStreamResponse model) {
            super(model);
            flowArn(model.flowArn);
            mediaStream(model.mediaStream);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final MediaStream.Builder getMediaStream() {
            return mediaStream != null ? mediaStream.toBuilder() : null;
        }

        public final void setMediaStream(MediaStream.BuilderImpl mediaStream) {
            this.mediaStream = mediaStream != null ? mediaStream.build() : null;
        }

        @Override
        public final Builder mediaStream(MediaStream mediaStream) {
            this.mediaStream = mediaStream;
            return this;
        }

        @Override
        public UpdateFlowMediaStreamResponse build() {
            return new UpdateFlowMediaStreamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
