/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The transport parameters that you want to associate with an incoming media stream.
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputConfigurationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<InputConfigurationRequest.Builder, InputConfigurationRequest> {
    private static final SdkField<Integer> INPUT_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InputPort").getter(getter(InputConfigurationRequest::inputPort)).setter(setter(Builder::inputPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputPort").build()).build();

    private static final SdkField<InterfaceRequest> INTERFACE_FIELD = SdkField
            .<InterfaceRequest> builder(MarshallingType.SDK_POJO).memberName("Interface")
            .getter(getter(InputConfigurationRequest::interfaceValue)).setter(setter(Builder::interfaceValue))
            .constructor(InterfaceRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interface").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_PORT_FIELD,
            INTERFACE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer inputPort;

    private final InterfaceRequest interfaceValue;

    private InputConfigurationRequest(BuilderImpl builder) {
        this.inputPort = builder.inputPort;
        this.interfaceValue = builder.interfaceValue;
    }

    /**
     * The port that you want the flow to listen on for an incoming media stream.
     * 
     * @return The port that you want the flow to listen on for an incoming media stream.
     */
    public final Integer inputPort() {
        return inputPort;
    }

    /**
     * The VPC interface that you want to use for the incoming media stream.
     * 
     * @return The VPC interface that you want to use for the incoming media stream.
     */
    public final InterfaceRequest interfaceValue() {
        return interfaceValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputPort());
        hashCode = 31 * hashCode + Objects.hashCode(interfaceValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputConfigurationRequest)) {
            return false;
        }
        InputConfigurationRequest other = (InputConfigurationRequest) obj;
        return Objects.equals(inputPort(), other.inputPort()) && Objects.equals(interfaceValue(), other.interfaceValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputConfigurationRequest").add("InputPort", inputPort()).add("Interface", interfaceValue())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputPort":
            return Optional.ofNullable(clazz.cast(inputPort()));
        case "Interface":
            return Optional.ofNullable(clazz.cast(interfaceValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputConfigurationRequest, T> g) {
        return obj -> g.apply((InputConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputConfigurationRequest> {
        /**
         * The port that you want the flow to listen on for an incoming media stream.
         * 
         * @param inputPort
         *        The port that you want the flow to listen on for an incoming media stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputPort(Integer inputPort);

        /**
         * The VPC interface that you want to use for the incoming media stream.
         * 
         * @param interfaceValue
         *        The VPC interface that you want to use for the incoming media stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceValue(InterfaceRequest interfaceValue);

        /**
         * The VPC interface that you want to use for the incoming media stream. This is a convenience method that
         * creates an instance of the {@link InterfaceRequest.Builder} avoiding the need to create one manually via
         * {@link InterfaceRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link InterfaceRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #interfaceValue(InterfaceRequest)}.
         * 
         * @param interfaceValue
         *        a consumer that will call methods on {@link InterfaceRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interfaceValue(InterfaceRequest)
         */
        default Builder interfaceValue(Consumer<InterfaceRequest.Builder> interfaceValue) {
            return interfaceValue(InterfaceRequest.builder().applyMutation(interfaceValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer inputPort;

        private InterfaceRequest interfaceValue;

        private BuilderImpl() {
        }

        private BuilderImpl(InputConfigurationRequest model) {
            inputPort(model.inputPort);
            interfaceValue(model.interfaceValue);
        }

        public final Integer getInputPort() {
            return inputPort;
        }

        public final void setInputPort(Integer inputPort) {
            this.inputPort = inputPort;
        }

        @Override
        public final Builder inputPort(Integer inputPort) {
            this.inputPort = inputPort;
            return this;
        }

        public final InterfaceRequest.Builder getInterfaceValue() {
            return interfaceValue != null ? interfaceValue.toBuilder() : null;
        }

        public final void setInterfaceValue(InterfaceRequest.BuilderImpl interfaceValue) {
            this.interfaceValue = interfaceValue != null ? interfaceValue.build() : null;
        }

        @Override
        public final Builder interfaceValue(InterfaceRequest interfaceValue) {
            this.interfaceValue = interfaceValue;
            return this;
        }

        @Override
        public InputConfigurationRequest build() {
            return new InputConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
