/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The fields that you want to update in the media stream.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFlowMediaStreamRequest extends MediaConnectRequest implements
        ToCopyableBuilder<UpdateFlowMediaStreamRequest.Builder, UpdateFlowMediaStreamRequest> {
    private static final SdkField<MediaStreamAttributesRequest> ATTRIBUTES_FIELD = SdkField
            .<MediaStreamAttributesRequest> builder(MarshallingType.SDK_POJO).memberName("Attributes")
            .getter(getter(UpdateFlowMediaStreamRequest::attributes)).setter(setter(Builder::attributes))
            .constructor(MediaStreamAttributesRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build()).build();

    private static final SdkField<Integer> CLOCK_RATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ClockRate").getter(getter(UpdateFlowMediaStreamRequest::clockRate)).setter(setter(Builder::clockRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clockRate").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateFlowMediaStreamRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(UpdateFlowMediaStreamRequest::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowArn").build()).build();

    private static final SdkField<String> MEDIA_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaStreamName").getter(getter(UpdateFlowMediaStreamRequest::mediaStreamName))
            .setter(setter(Builder::mediaStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("mediaStreamName").build()).build();

    private static final SdkField<String> MEDIA_STREAM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaStreamType").getter(getter(UpdateFlowMediaStreamRequest::mediaStreamTypeAsString))
            .setter(setter(Builder::mediaStreamType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreamType").build()).build();

    private static final SdkField<String> VIDEO_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VideoFormat").getter(getter(UpdateFlowMediaStreamRequest::videoFormat))
            .setter(setter(Builder::videoFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD,
            CLOCK_RATE_FIELD, DESCRIPTION_FIELD, FLOW_ARN_FIELD, MEDIA_STREAM_NAME_FIELD, MEDIA_STREAM_TYPE_FIELD,
            VIDEO_FORMAT_FIELD));

    private final MediaStreamAttributesRequest attributes;

    private final Integer clockRate;

    private final String description;

    private final String flowArn;

    private final String mediaStreamName;

    private final String mediaStreamType;

    private final String videoFormat;

    private UpdateFlowMediaStreamRequest(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
        this.clockRate = builder.clockRate;
        this.description = builder.description;
        this.flowArn = builder.flowArn;
        this.mediaStreamName = builder.mediaStreamName;
        this.mediaStreamType = builder.mediaStreamType;
        this.videoFormat = builder.videoFormat;
    }

    /**
     * The attributes that you want to assign to the media stream.
     * 
     * @return The attributes that you want to assign to the media stream.
     */
    public final MediaStreamAttributesRequest attributes() {
        return attributes;
    }

    /**
     * The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to
     * 90000. If the media stream type is audio, set this value to either 48000 or 96000.
     * 
     * @return The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this
     *         value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
     */
    public final Integer clockRate() {
        return clockRate;
    }

    /**
     * Description
     * 
     * @return Description
     */
    public final String description() {
        return description;
    }

    /**
     * The Amazon Resource Name (ARN) of the flow.
     * 
     * @return The Amazon Resource Name (ARN) of the flow.
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * The name of the media stream that you want to update.
     * 
     * @return The name of the media stream that you want to update.
     */
    public final String mediaStreamName() {
        return mediaStreamName;
    }

    /**
     * The type of media stream.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaStreamType}
     * will return {@link MediaStreamType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mediaStreamTypeAsString}.
     * </p>
     * 
     * @return The type of media stream.
     * @see MediaStreamType
     */
    public final MediaStreamType mediaStreamType() {
        return MediaStreamType.fromValue(mediaStreamType);
    }

    /**
     * The type of media stream.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaStreamType}
     * will return {@link MediaStreamType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mediaStreamTypeAsString}.
     * </p>
     * 
     * @return The type of media stream.
     * @see MediaStreamType
     */
    public final String mediaStreamTypeAsString() {
        return mediaStreamType;
    }

    /**
     * The resolution of the video.
     * 
     * @return The resolution of the video.
     */
    public final String videoFormat() {
        return videoFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(clockRate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(mediaStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(mediaStreamTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(videoFormat());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowMediaStreamRequest)) {
            return false;
        }
        UpdateFlowMediaStreamRequest other = (UpdateFlowMediaStreamRequest) obj;
        return Objects.equals(attributes(), other.attributes()) && Objects.equals(clockRate(), other.clockRate())
                && Objects.equals(description(), other.description()) && Objects.equals(flowArn(), other.flowArn())
                && Objects.equals(mediaStreamName(), other.mediaStreamName())
                && Objects.equals(mediaStreamTypeAsString(), other.mediaStreamTypeAsString())
                && Objects.equals(videoFormat(), other.videoFormat());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFlowMediaStreamRequest").add("Attributes", attributes()).add("ClockRate", clockRate())
                .add("Description", description()).add("FlowArn", flowArn()).add("MediaStreamName", mediaStreamName())
                .add("MediaStreamType", mediaStreamTypeAsString()).add("VideoFormat", videoFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "ClockRate":
            return Optional.ofNullable(clazz.cast(clockRate()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "MediaStreamName":
            return Optional.ofNullable(clazz.cast(mediaStreamName()));
        case "MediaStreamType":
            return Optional.ofNullable(clazz.cast(mediaStreamTypeAsString()));
        case "VideoFormat":
            return Optional.ofNullable(clazz.cast(videoFormat()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowMediaStreamRequest, T> g) {
        return obj -> g.apply((UpdateFlowMediaStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFlowMediaStreamRequest> {
        /**
         * The attributes that you want to assign to the media stream.
         * 
         * @param attributes
         *        The attributes that you want to assign to the media stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(MediaStreamAttributesRequest attributes);

        /**
         * The attributes that you want to assign to the media stream. This is a convenience method that creates an
         * instance of the {@link MediaStreamAttributesRequest.Builder} avoiding the need to create one manually via
         * {@link MediaStreamAttributesRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link MediaStreamAttributesRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #attributes(MediaStreamAttributesRequest)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link MediaStreamAttributesRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(MediaStreamAttributesRequest)
         */
        default Builder attributes(Consumer<MediaStreamAttributesRequest.Builder> attributes) {
            return attributes(MediaStreamAttributesRequest.builder().applyMutation(attributes).build());
        }

        /**
         * The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value
         * to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
         * 
         * @param clockRate
         *        The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this
         *        value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clockRate(Integer clockRate);

        /**
         * Description
         * 
         * @param description
         *        Description
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The Amazon Resource Name (ARN) of the flow.
         * 
         * @param flowArn
         *        The Amazon Resource Name (ARN) of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * The name of the media stream that you want to update.
         * 
         * @param mediaStreamName
         *        The name of the media stream that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStreamName(String mediaStreamName);

        /**
         * The type of media stream.
         * 
         * @param mediaStreamType
         *        The type of media stream.
         * @see MediaStreamType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaStreamType
         */
        Builder mediaStreamType(String mediaStreamType);

        /**
         * The type of media stream.
         * 
         * @param mediaStreamType
         *        The type of media stream.
         * @see MediaStreamType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaStreamType
         */
        Builder mediaStreamType(MediaStreamType mediaStreamType);

        /**
         * The resolution of the video.
         * 
         * @param videoFormat
         *        The resolution of the video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoFormat(String videoFormat);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConnectRequest.BuilderImpl implements Builder {
        private MediaStreamAttributesRequest attributes;

        private Integer clockRate;

        private String description;

        private String flowArn;

        private String mediaStreamName;

        private String mediaStreamType;

        private String videoFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowMediaStreamRequest model) {
            super(model);
            attributes(model.attributes);
            clockRate(model.clockRate);
            description(model.description);
            flowArn(model.flowArn);
            mediaStreamName(model.mediaStreamName);
            mediaStreamType(model.mediaStreamType);
            videoFormat(model.videoFormat);
        }

        public final MediaStreamAttributesRequest.Builder getAttributes() {
            return attributes != null ? attributes.toBuilder() : null;
        }

        public final void setAttributes(MediaStreamAttributesRequest.BuilderImpl attributes) {
            this.attributes = attributes != null ? attributes.build() : null;
        }

        @Override
        public final Builder attributes(MediaStreamAttributesRequest attributes) {
            this.attributes = attributes;
            return this;
        }

        public final Integer getClockRate() {
            return clockRate;
        }

        public final void setClockRate(Integer clockRate) {
            this.clockRate = clockRate;
        }

        @Override
        public final Builder clockRate(Integer clockRate) {
            this.clockRate = clockRate;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final String getMediaStreamName() {
            return mediaStreamName;
        }

        public final void setMediaStreamName(String mediaStreamName) {
            this.mediaStreamName = mediaStreamName;
        }

        @Override
        public final Builder mediaStreamName(String mediaStreamName) {
            this.mediaStreamName = mediaStreamName;
            return this;
        }

        public final String getMediaStreamType() {
            return mediaStreamType;
        }

        public final void setMediaStreamType(String mediaStreamType) {
            this.mediaStreamType = mediaStreamType;
        }

        @Override
        public final Builder mediaStreamType(String mediaStreamType) {
            this.mediaStreamType = mediaStreamType;
            return this;
        }

        @Override
        public final Builder mediaStreamType(MediaStreamType mediaStreamType) {
            this.mediaStreamType(mediaStreamType == null ? null : mediaStreamType.toString());
            return this;
        }

        public final String getVideoFormat() {
            return videoFormat;
        }

        public final void setVideoFormat(String videoFormat) {
            this.videoFormat = videoFormat;
        }

        @Override
        public final Builder videoFormat(String videoFormat) {
            this.videoFormat = videoFormat;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFlowMediaStreamRequest build() {
            return new UpdateFlowMediaStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
