/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GrantFlowEntitlementsResponse extends MediaConnectResponse implements
        ToCopyableBuilder<GrantFlowEntitlementsResponse.Builder, GrantFlowEntitlementsResponse> {
    private static final SdkField<List<Entitlement>> ENTITLEMENTS_FIELD = SdkField
            .<List<Entitlement>> builder(MarshallingType.LIST)
            .memberName("Entitlements")
            .getter(getter(GrantFlowEntitlementsResponse::entitlements))
            .setter(setter(Builder::entitlements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Entitlement> builder(MarshallingType.SDK_POJO)
                                            .constructor(Entitlement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(GrantFlowEntitlementsResponse::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITLEMENTS_FIELD,
            FLOW_ARN_FIELD));

    private final List<Entitlement> entitlements;

    private final String flowArn;

    private GrantFlowEntitlementsResponse(BuilderImpl builder) {
        super(builder);
        this.entitlements = builder.entitlements;
        this.flowArn = builder.flowArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entitlements property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntitlements() {
        return entitlements != null && !(entitlements instanceof SdkAutoConstructList);
    }

    /**
     * The entitlements that were just granted.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntitlements} method.
     * </p>
     * 
     * @return The entitlements that were just granted.
     */
    public final List<Entitlement> entitlements() {
        return entitlements;
    }

    /**
     * The ARN of the flow that these entitlements were granted to.
     * 
     * @return The ARN of the flow that these entitlements were granted to.
     */
    public final String flowArn() {
        return flowArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEntitlements() ? entitlements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrantFlowEntitlementsResponse)) {
            return false;
        }
        GrantFlowEntitlementsResponse other = (GrantFlowEntitlementsResponse) obj;
        return hasEntitlements() == other.hasEntitlements() && Objects.equals(entitlements(), other.entitlements())
                && Objects.equals(flowArn(), other.flowArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GrantFlowEntitlementsResponse").add("Entitlements", hasEntitlements() ? entitlements() : null)
                .add("FlowArn", flowArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Entitlements":
            return Optional.ofNullable(clazz.cast(entitlements()));
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GrantFlowEntitlementsResponse, T> g) {
        return obj -> g.apply((GrantFlowEntitlementsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GrantFlowEntitlementsResponse> {
        /**
         * The entitlements that were just granted.
         * 
         * @param entitlements
         *        The entitlements that were just granted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(Collection<Entitlement> entitlements);

        /**
         * The entitlements that were just granted.
         * 
         * @param entitlements
         *        The entitlements that were just granted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(Entitlement... entitlements);

        /**
         * The entitlements that were just granted. This is a convenience method that creates an instance of the
         * {@link List<Entitlement>.Builder} avoiding the need to create one manually via {@link List
         * <Entitlement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Entitlement>.Builder#build()} is called immediately and its
         * result is passed to {@link #entitlements(List<Entitlement>)}.
         * 
         * @param entitlements
         *        a consumer that will call methods on {@link List<Entitlement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entitlements(List<Entitlement>)
         */
        Builder entitlements(Consumer<Entitlement.Builder>... entitlements);

        /**
         * The ARN of the flow that these entitlements were granted to.
         * 
         * @param flowArn
         *        The ARN of the flow that these entitlements were granted to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private List<Entitlement> entitlements = DefaultSdkAutoConstructList.getInstance();

        private String flowArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GrantFlowEntitlementsResponse model) {
            super(model);
            entitlements(model.entitlements);
            flowArn(model.flowArn);
        }

        public final List<Entitlement.Builder> getEntitlements() {
            List<Entitlement.Builder> result = ___listOfEntitlementCopier.copyToBuilder(this.entitlements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntitlements(Collection<Entitlement.BuilderImpl> entitlements) {
            this.entitlements = ___listOfEntitlementCopier.copyFromBuilder(entitlements);
        }

        @Override
        public final Builder entitlements(Collection<Entitlement> entitlements) {
            this.entitlements = ___listOfEntitlementCopier.copy(entitlements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Entitlement... entitlements) {
            entitlements(Arrays.asList(entitlements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Consumer<Entitlement.Builder>... entitlements) {
            entitlements(Stream.of(entitlements).map(c -> Entitlement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        @Override
        public GrantFlowEntitlementsResponse build() {
            return new GrantFlowEntitlementsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
