/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The transport parameters that are associated with an outbound media stream.
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationConfiguration.Builder, DestinationConfiguration> {
    private static final SdkField<String> DESTINATION_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationIp").getter(getter(DestinationConfiguration::destinationIp))
            .setter(setter(Builder::destinationIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationIp").build()).build();

    private static final SdkField<Integer> DESTINATION_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DestinationPort").getter(getter(DestinationConfiguration::destinationPort))
            .setter(setter(Builder::destinationPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPort").build()).build();

    private static final SdkField<Interface> INTERFACE_FIELD = SdkField.<Interface> builder(MarshallingType.SDK_POJO)
            .memberName("Interface").getter(getter(DestinationConfiguration::interfaceValue))
            .setter(setter(Builder::interfaceValue)).constructor(Interface::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interface").build()).build();

    private static final SdkField<String> OUTBOUND_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutboundIp").getter(getter(DestinationConfiguration::outboundIp)).setter(setter(Builder::outboundIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outboundIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_IP_FIELD,
            DESTINATION_PORT_FIELD, INTERFACE_FIELD, OUTBOUND_IP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destinationIp;

    private final Integer destinationPort;

    private final Interface interfaceValue;

    private final String outboundIp;

    private DestinationConfiguration(BuilderImpl builder) {
        this.destinationIp = builder.destinationIp;
        this.destinationPort = builder.destinationPort;
        this.interfaceValue = builder.interfaceValue;
        this.outboundIp = builder.outboundIp;
    }

    /**
     * The IP address where contents of the media stream will be sent.
     * 
     * @return The IP address where contents of the media stream will be sent.
     */
    public final String destinationIp() {
        return destinationIp;
    }

    /**
     * The port to use when the content of the media stream is distributed to the output.
     * 
     * @return The port to use when the content of the media stream is distributed to the output.
     */
    public final Integer destinationPort() {
        return destinationPort;
    }

    /**
     * The VPC interface that is used for the media stream associated with the output.
     * 
     * @return The VPC interface that is used for the media stream associated with the output.
     */
    public final Interface interfaceValue() {
        return interfaceValue;
    }

    /**
     * The IP address that the receiver requires in order to establish a connection with the flow. This value is
     * represented by the elastic network interface IP address of the VPC. This field applies only to outputs that use
     * the CDI or ST 2110 JPEG XS protocol.
     * 
     * @return The IP address that the receiver requires in order to establish a connection with the flow. This value is
     *         represented by the elastic network interface IP address of the VPC. This field applies only to outputs
     *         that use the CDI or ST 2110 JPEG XS protocol.
     */
    public final String outboundIp() {
        return outboundIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationIp());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPort());
        hashCode = 31 * hashCode + Objects.hashCode(interfaceValue());
        hashCode = 31 * hashCode + Objects.hashCode(outboundIp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationConfiguration)) {
            return false;
        }
        DestinationConfiguration other = (DestinationConfiguration) obj;
        return Objects.equals(destinationIp(), other.destinationIp())
                && Objects.equals(destinationPort(), other.destinationPort())
                && Objects.equals(interfaceValue(), other.interfaceValue()) && Objects.equals(outboundIp(), other.outboundIp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationConfiguration").add("DestinationIp", destinationIp())
                .add("DestinationPort", destinationPort()).add("Interface", interfaceValue()).add("OutboundIp", outboundIp())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationIp":
            return Optional.ofNullable(clazz.cast(destinationIp()));
        case "DestinationPort":
            return Optional.ofNullable(clazz.cast(destinationPort()));
        case "Interface":
            return Optional.ofNullable(clazz.cast(interfaceValue()));
        case "OutboundIp":
            return Optional.ofNullable(clazz.cast(outboundIp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationConfiguration, T> g) {
        return obj -> g.apply((DestinationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationConfiguration> {
        /**
         * The IP address where contents of the media stream will be sent.
         * 
         * @param destinationIp
         *        The IP address where contents of the media stream will be sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationIp(String destinationIp);

        /**
         * The port to use when the content of the media stream is distributed to the output.
         * 
         * @param destinationPort
         *        The port to use when the content of the media stream is distributed to the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPort(Integer destinationPort);

        /**
         * The VPC interface that is used for the media stream associated with the output.
         * 
         * @param interfaceValue
         *        The VPC interface that is used for the media stream associated with the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceValue(Interface interfaceValue);

        /**
         * The VPC interface that is used for the media stream associated with the output. This is a convenience method
         * that creates an instance of the {@link Interface.Builder} avoiding the need to create one manually via
         * {@link Interface#builder()}.
         *
         * When the {@link Consumer} completes, {@link Interface.Builder#build()} is called immediately and its result
         * is passed to {@link #interfaceValue(Interface)}.
         * 
         * @param interfaceValue
         *        a consumer that will call methods on {@link Interface.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interfaceValue(Interface)
         */
        default Builder interfaceValue(Consumer<Interface.Builder> interfaceValue) {
            return interfaceValue(Interface.builder().applyMutation(interfaceValue).build());
        }

        /**
         * The IP address that the receiver requires in order to establish a connection with the flow. This value is
         * represented by the elastic network interface IP address of the VPC. This field applies only to outputs that
         * use the CDI or ST 2110 JPEG XS protocol.
         * 
         * @param outboundIp
         *        The IP address that the receiver requires in order to establish a connection with the flow. This value
         *        is represented by the elastic network interface IP address of the VPC. This field applies only to
         *        outputs that use the CDI or ST 2110 JPEG XS protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundIp(String outboundIp);
    }

    static final class BuilderImpl implements Builder {
        private String destinationIp;

        private Integer destinationPort;

        private Interface interfaceValue;

        private String outboundIp;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationConfiguration model) {
            destinationIp(model.destinationIp);
            destinationPort(model.destinationPort);
            interfaceValue(model.interfaceValue);
            outboundIp(model.outboundIp);
        }

        public final String getDestinationIp() {
            return destinationIp;
        }

        public final void setDestinationIp(String destinationIp) {
            this.destinationIp = destinationIp;
        }

        @Override
        public final Builder destinationIp(String destinationIp) {
            this.destinationIp = destinationIp;
            return this;
        }

        public final Integer getDestinationPort() {
            return destinationPort;
        }

        public final void setDestinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
        }

        @Override
        public final Builder destinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public final Interface.Builder getInterfaceValue() {
            return interfaceValue != null ? interfaceValue.toBuilder() : null;
        }

        public final void setInterfaceValue(Interface.BuilderImpl interfaceValue) {
            this.interfaceValue = interfaceValue != null ? interfaceValue.build() : null;
        }

        @Override
        public final Builder interfaceValue(Interface interfaceValue) {
            this.interfaceValue = interfaceValue;
            return this;
        }

        public final String getOutboundIp() {
            return outboundIp;
        }

        public final void setOutboundIp(String outboundIp) {
            this.outboundIp = outboundIp;
        }

        @Override
        public final Builder outboundIp(String outboundIp) {
            this.outboundIp = outboundIp;
            return this;
        }

        @Override
        public DestinationConfiguration build() {
            return new DestinationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
