/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The fields that you want to update in the output.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFlowOutputRequest extends MediaConnectRequest implements
        ToCopyableBuilder<UpdateFlowOutputRequest.Builder, UpdateFlowOutputRequest> {
    private static final SdkField<List<String>> CIDR_ALLOW_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CidrAllowList")
            .getter(getter(UpdateFlowOutputRequest::cidrAllowList))
            .setter(setter(Builder::cidrAllowList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidrAllowList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateFlowOutputRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Destination").getter(getter(UpdateFlowOutputRequest::destination)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<UpdateEncryption> ENCRYPTION_FIELD = SdkField
            .<UpdateEncryption> builder(MarshallingType.SDK_POJO).memberName("Encryption")
            .getter(getter(UpdateFlowOutputRequest::encryption)).setter(setter(Builder::encryption))
            .constructor(UpdateEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()).build();

    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(UpdateFlowOutputRequest::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowArn").build()).build();

    private static final SdkField<Integer> MAX_LATENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxLatency").getter(getter(UpdateFlowOutputRequest::maxLatency)).setter(setter(Builder::maxLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLatency").build()).build();

    private static final SdkField<List<MediaStreamOutputConfigurationRequest>> MEDIA_STREAM_OUTPUT_CONFIGURATIONS_FIELD = SdkField
            .<List<MediaStreamOutputConfigurationRequest>> builder(MarshallingType.LIST)
            .memberName("MediaStreamOutputConfigurations")
            .getter(getter(UpdateFlowOutputRequest::mediaStreamOutputConfigurations))
            .setter(setter(Builder::mediaStreamOutputConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreamOutputConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MediaStreamOutputConfigurationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaStreamOutputConfigurationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MIN_LATENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinLatency").getter(getter(UpdateFlowOutputRequest::minLatency)).setter(setter(Builder::minLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minLatency").build()).build();

    private static final SdkField<String> OUTPUT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputArn").getter(getter(UpdateFlowOutputRequest::outputArn)).setter(setter(Builder::outputArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("outputArn").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(UpdateFlowOutputRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(UpdateFlowOutputRequest::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<String> REMOTE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RemoteId").getter(getter(UpdateFlowOutputRequest::remoteId)).setter(setter(Builder::remoteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteId").build()).build();

    private static final SdkField<Integer> SENDER_CONTROL_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SenderControlPort").getter(getter(UpdateFlowOutputRequest::senderControlPort))
            .setter(setter(Builder::senderControlPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("senderControlPort").build()).build();

    private static final SdkField<String> SENDER_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SenderIpAddress").getter(getter(UpdateFlowOutputRequest::senderIpAddress))
            .setter(setter(Builder::senderIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("senderIpAddress").build()).build();

    private static final SdkField<Integer> SMOOTHING_LATENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SmoothingLatency").getter(getter(UpdateFlowOutputRequest::smoothingLatency))
            .setter(setter(Builder::smoothingLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smoothingLatency").build()).build();

    private static final SdkField<String> STREAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamId").getter(getter(UpdateFlowOutputRequest::streamId)).setter(setter(Builder::streamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()).build();

    private static final SdkField<VpcInterfaceAttachment> VPC_INTERFACE_ATTACHMENT_FIELD = SdkField
            .<VpcInterfaceAttachment> builder(MarshallingType.SDK_POJO).memberName("VpcInterfaceAttachment")
            .getter(getter(UpdateFlowOutputRequest::vpcInterfaceAttachment)).setter(setter(Builder::vpcInterfaceAttachment))
            .constructor(VpcInterfaceAttachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaceAttachment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_ALLOW_LIST_FIELD,
            DESCRIPTION_FIELD, DESTINATION_FIELD, ENCRYPTION_FIELD, FLOW_ARN_FIELD, MAX_LATENCY_FIELD,
            MEDIA_STREAM_OUTPUT_CONFIGURATIONS_FIELD, MIN_LATENCY_FIELD, OUTPUT_ARN_FIELD, PORT_FIELD, PROTOCOL_FIELD,
            REMOTE_ID_FIELD, SENDER_CONTROL_PORT_FIELD, SENDER_IP_ADDRESS_FIELD, SMOOTHING_LATENCY_FIELD, STREAM_ID_FIELD,
            VPC_INTERFACE_ATTACHMENT_FIELD));

    private final List<String> cidrAllowList;

    private final String description;

    private final String destination;

    private final UpdateEncryption encryption;

    private final String flowArn;

    private final Integer maxLatency;

    private final List<MediaStreamOutputConfigurationRequest> mediaStreamOutputConfigurations;

    private final Integer minLatency;

    private final String outputArn;

    private final Integer port;

    private final String protocol;

    private final String remoteId;

    private final Integer senderControlPort;

    private final String senderIpAddress;

    private final Integer smoothingLatency;

    private final String streamId;

    private final VpcInterfaceAttachment vpcInterfaceAttachment;

    private UpdateFlowOutputRequest(BuilderImpl builder) {
        super(builder);
        this.cidrAllowList = builder.cidrAllowList;
        this.description = builder.description;
        this.destination = builder.destination;
        this.encryption = builder.encryption;
        this.flowArn = builder.flowArn;
        this.maxLatency = builder.maxLatency;
        this.mediaStreamOutputConfigurations = builder.mediaStreamOutputConfigurations;
        this.minLatency = builder.minLatency;
        this.outputArn = builder.outputArn;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.remoteId = builder.remoteId;
        this.senderControlPort = builder.senderControlPort;
        this.senderIpAddress = builder.senderIpAddress;
        this.smoothingLatency = builder.smoothingLatency;
        this.streamId = builder.streamId;
        this.vpcInterfaceAttachment = builder.vpcInterfaceAttachment;
    }

    /**
     * For responses, this returns true if the service returned a value for the CidrAllowList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCidrAllowList() {
        return cidrAllowList != null && !(cidrAllowList instanceof SdkAutoConstructList);
    }

    /**
     * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses
     * should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCidrAllowList} method.
     * </p>
     * 
     * @return The range of IP addresses that should be allowed to initiate output requests to this flow. These IP
     *         addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example,
     *         10.0.0.0/16.
     */
    public final List<String> cidrAllowList() {
        return cidrAllowList;
    }

    /**
     * A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not
     * be seen by the end user.
     * 
     * @return A description of the output. This description appears only on the AWS Elemental MediaConnect console and
     *         will not be seen by the end user.
     */
    public final String description() {
        return description;
    }

    /**
     * The IP address where you want to send the output.
     * 
     * @return The IP address where you want to send the output.
     */
    public final String destination() {
        return destination;
    }

    /**
     * The type of key used for the encryption. If no keyType is provided, the service will use the default setting
     * (static-key).
     * 
     * @return The type of key used for the encryption. If no keyType is provided, the service will use the default
     *         setting (static-key).
     */
    public final UpdateEncryption encryption() {
        return encryption;
    }

    /**
     * The flow that is associated with the output that you want to update.
     * 
     * @return The flow that is associated with the output that you want to update.
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based
     * streams.
     * 
     * @return The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and
     *         Fujitsu-based streams.
     */
    public final Integer maxLatency() {
        return maxLatency;
    }

    /**
     * For responses, this returns true if the service returned a value for the MediaStreamOutputConfigurations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasMediaStreamOutputConfigurations() {
        return mediaStreamOutputConfigurations != null && !(mediaStreamOutputConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * The media streams that are associated with the output, and the parameters for those associations.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMediaStreamOutputConfigurations}
     * method.
     * </p>
     * 
     * @return The media streams that are associated with the output, and the parameters for those associations.
     */
    public final List<MediaStreamOutputConfigurationRequest> mediaStreamOutputConfigurations() {
        return mediaStreamOutputConfigurations;
    }

    /**
     * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that
     * you set on your MediaConnect source or output represents the minimal potential latency of that connection. The
     * latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s
     * minimum latency.
     * 
     * @return The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this
     *         value that you set on your MediaConnect source or output represents the minimal potential latency of that
     *         connection. The latency of the stream is set to the highest number between the sender’s minimum latency
     *         and the receiver’s minimum latency.
     */
    public final Integer minLatency() {
        return minLatency;
    }

    /**
     * The ARN of the output that you want to update.
     * 
     * @return The ARN of the output that you want to update.
     */
    public final String outputArn() {
        return outputArn;
    }

    /**
     * The port to use when content is distributed to this output.
     * 
     * @return The port to use when content is distributed to this output.
     */
    public final Integer port() {
        return port;
    }

    /**
     * The protocol to use for the output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol to use for the output.
     * @see Protocol
     */
    public final Protocol protocol() {
        return Protocol.fromValue(protocol);
    }

    /**
     * The protocol to use for the output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol to use for the output.
     * @see Protocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * The remote ID for the Zixi-pull stream.
     * 
     * @return The remote ID for the Zixi-pull stream.
     */
    public final String remoteId() {
        return remoteId;
    }

    /**
     * The port that the flow uses to send outbound requests to initiate connection with the sender.
     * 
     * @return The port that the flow uses to send outbound requests to initiate connection with the sender.
     */
    public final Integer senderControlPort() {
        return senderControlPort;
    }

    /**
     * The IP address that the flow communicates with to initiate connection with the sender.
     * 
     * @return The IP address that the flow communicates with to initiate connection with the sender.
     */
    public final String senderIpAddress() {
        return senderIpAddress;
    }

    /**
     * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
     * 
     * @return The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
     */
    public final Integer smoothingLatency() {
        return smoothingLatency;
    }

    /**
     * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
     * 
     * @return The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
     */
    public final String streamId() {
        return streamId;
    }

    /**
     * The name of the VPC interface attachment to use for this output.
     * 
     * @return The name of the VPC interface attachment to use for this output.
     */
    public final VpcInterfaceAttachment vpcInterfaceAttachment() {
        return vpcInterfaceAttachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCidrAllowList() ? cidrAllowList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxLatency());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasMediaStreamOutputConfigurations() ? mediaStreamOutputConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(minLatency());
        hashCode = 31 * hashCode + Objects.hashCode(outputArn());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(remoteId());
        hashCode = 31 * hashCode + Objects.hashCode(senderControlPort());
        hashCode = 31 * hashCode + Objects.hashCode(senderIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(smoothingLatency());
        hashCode = 31 * hashCode + Objects.hashCode(streamId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcInterfaceAttachment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowOutputRequest)) {
            return false;
        }
        UpdateFlowOutputRequest other = (UpdateFlowOutputRequest) obj;
        return hasCidrAllowList() == other.hasCidrAllowList() && Objects.equals(cidrAllowList(), other.cidrAllowList())
                && Objects.equals(description(), other.description()) && Objects.equals(destination(), other.destination())
                && Objects.equals(encryption(), other.encryption()) && Objects.equals(flowArn(), other.flowArn())
                && Objects.equals(maxLatency(), other.maxLatency())
                && hasMediaStreamOutputConfigurations() == other.hasMediaStreamOutputConfigurations()
                && Objects.equals(mediaStreamOutputConfigurations(), other.mediaStreamOutputConfigurations())
                && Objects.equals(minLatency(), other.minLatency()) && Objects.equals(outputArn(), other.outputArn())
                && Objects.equals(port(), other.port()) && Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(remoteId(), other.remoteId()) && Objects.equals(senderControlPort(), other.senderControlPort())
                && Objects.equals(senderIpAddress(), other.senderIpAddress())
                && Objects.equals(smoothingLatency(), other.smoothingLatency()) && Objects.equals(streamId(), other.streamId())
                && Objects.equals(vpcInterfaceAttachment(), other.vpcInterfaceAttachment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateFlowOutputRequest")
                .add("CidrAllowList", hasCidrAllowList() ? cidrAllowList() : null)
                .add("Description", description())
                .add("Destination", destination())
                .add("Encryption", encryption())
                .add("FlowArn", flowArn())
                .add("MaxLatency", maxLatency())
                .add("MediaStreamOutputConfigurations",
                        hasMediaStreamOutputConfigurations() ? mediaStreamOutputConfigurations() : null)
                .add("MinLatency", minLatency()).add("OutputArn", outputArn()).add("Port", port())
                .add("Protocol", protocolAsString()).add("RemoteId", remoteId()).add("SenderControlPort", senderControlPort())
                .add("SenderIpAddress", senderIpAddress()).add("SmoothingLatency", smoothingLatency())
                .add("StreamId", streamId()).add("VpcInterfaceAttachment", vpcInterfaceAttachment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrAllowList":
            return Optional.ofNullable(clazz.cast(cidrAllowList()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "MaxLatency":
            return Optional.ofNullable(clazz.cast(maxLatency()));
        case "MediaStreamOutputConfigurations":
            return Optional.ofNullable(clazz.cast(mediaStreamOutputConfigurations()));
        case "MinLatency":
            return Optional.ofNullable(clazz.cast(minLatency()));
        case "OutputArn":
            return Optional.ofNullable(clazz.cast(outputArn()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "RemoteId":
            return Optional.ofNullable(clazz.cast(remoteId()));
        case "SenderControlPort":
            return Optional.ofNullable(clazz.cast(senderControlPort()));
        case "SenderIpAddress":
            return Optional.ofNullable(clazz.cast(senderIpAddress()));
        case "SmoothingLatency":
            return Optional.ofNullable(clazz.cast(smoothingLatency()));
        case "StreamId":
            return Optional.ofNullable(clazz.cast(streamId()));
        case "VpcInterfaceAttachment":
            return Optional.ofNullable(clazz.cast(vpcInterfaceAttachment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowOutputRequest, T> g) {
        return obj -> g.apply((UpdateFlowOutputRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFlowOutputRequest> {
        /**
         * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses
         * should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         * 
         * @param cidrAllowList
         *        The range of IP addresses that should be allowed to initiate output requests to this flow. These IP
         *        addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example,
         *        10.0.0.0/16.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrAllowList(Collection<String> cidrAllowList);

        /**
         * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses
         * should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         * 
         * @param cidrAllowList
         *        The range of IP addresses that should be allowed to initiate output requests to this flow. These IP
         *        addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example,
         *        10.0.0.0/16.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrAllowList(String... cidrAllowList);

        /**
         * A description of the output. This description appears only on the AWS Elemental MediaConnect console and will
         * not be seen by the end user.
         * 
         * @param description
         *        A description of the output. This description appears only on the AWS Elemental MediaConnect console
         *        and will not be seen by the end user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The IP address where you want to send the output.
         * 
         * @param destination
         *        The IP address where you want to send the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * The type of key used for the encryption. If no keyType is provided, the service will use the default setting
         * (static-key).
         * 
         * @param encryption
         *        The type of key used for the encryption. If no keyType is provided, the service will use the default
         *        setting (static-key).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(UpdateEncryption encryption);

        /**
         * The type of key used for the encryption. If no keyType is provided, the service will use the default setting
         * (static-key). This is a convenience method that creates an instance of the {@link UpdateEncryption.Builder}
         * avoiding the need to create one manually via {@link UpdateEncryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateEncryption.Builder#build()} is called immediately and its
         * result is passed to {@link #encryption(UpdateEncryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link UpdateEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(UpdateEncryption)
         */
        default Builder encryption(Consumer<UpdateEncryption.Builder> encryption) {
            return encryption(UpdateEncryption.builder().applyMutation(encryption).build());
        }

        /**
         * The flow that is associated with the output that you want to update.
         * 
         * @param flowArn
         *        The flow that is associated with the output that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based
         * streams.
         * 
         * @param maxLatency
         *        The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and
         *        Fujitsu-based streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxLatency(Integer maxLatency);

        /**
         * The media streams that are associated with the output, and the parameters for those associations.
         * 
         * @param mediaStreamOutputConfigurations
         *        The media streams that are associated with the output, and the parameters for those associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStreamOutputConfigurations(Collection<MediaStreamOutputConfigurationRequest> mediaStreamOutputConfigurations);

        /**
         * The media streams that are associated with the output, and the parameters for those associations.
         * 
         * @param mediaStreamOutputConfigurations
         *        The media streams that are associated with the output, and the parameters for those associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStreamOutputConfigurations(MediaStreamOutputConfigurationRequest... mediaStreamOutputConfigurations);

        /**
         * The media streams that are associated with the output, and the parameters for those associations. This is a
         * convenience method that creates an instance of the {@link List
         * <MediaStreamOutputConfigurationRequest>.Builder} avoiding the need to create one manually via {@link List
         * <MediaStreamOutputConfigurationRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MediaStreamOutputConfigurationRequest>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #mediaStreamOutputConfigurations(List<MediaStreamOutputConfigurationRequest>)}.
         * 
         * @param mediaStreamOutputConfigurations
         *        a consumer that will call methods on {@link List<MediaStreamOutputConfigurationRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaStreamOutputConfigurations(List<MediaStreamOutputConfigurationRequest>)
         */
        Builder mediaStreamOutputConfigurations(
                Consumer<MediaStreamOutputConfigurationRequest.Builder>... mediaStreamOutputConfigurations);

        /**
         * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value
         * that you set on your MediaConnect source or output represents the minimal potential latency of that
         * connection. The latency of the stream is set to the highest number between the sender’s minimum latency and
         * the receiver’s minimum latency.
         * 
         * @param minLatency
         *        The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this
         *        value that you set on your MediaConnect source or output represents the minimal potential latency of
         *        that connection. The latency of the stream is set to the highest number between the sender’s minimum
         *        latency and the receiver’s minimum latency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minLatency(Integer minLatency);

        /**
         * The ARN of the output that you want to update.
         * 
         * @param outputArn
         *        The ARN of the output that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputArn(String outputArn);

        /**
         * The port to use when content is distributed to this output.
         * 
         * @param port
         *        The port to use when content is distributed to this output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * The protocol to use for the output.
         * 
         * @param protocol
         *        The protocol to use for the output.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * The protocol to use for the output.
         * 
         * @param protocol
         *        The protocol to use for the output.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);

        /**
         * The remote ID for the Zixi-pull stream.
         * 
         * @param remoteId
         *        The remote ID for the Zixi-pull stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteId(String remoteId);

        /**
         * The port that the flow uses to send outbound requests to initiate connection with the sender.
         * 
         * @param senderControlPort
         *        The port that the flow uses to send outbound requests to initiate connection with the sender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderControlPort(Integer senderControlPort);

        /**
         * The IP address that the flow communicates with to initiate connection with the sender.
         * 
         * @param senderIpAddress
         *        The IP address that the flow communicates with to initiate connection with the sender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderIpAddress(String senderIpAddress);

        /**
         * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
         * 
         * @param smoothingLatency
         *        The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smoothingLatency(Integer smoothingLatency);

        /**
         * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
         * 
         * @param streamId
         *        The stream ID that you want to use for this transport. This parameter applies only to Zixi-based
         *        streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamId(String streamId);

        /**
         * The name of the VPC interface attachment to use for this output.
         * 
         * @param vpcInterfaceAttachment
         *        The name of the VPC interface attachment to use for this output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcInterfaceAttachment(VpcInterfaceAttachment vpcInterfaceAttachment);

        /**
         * The name of the VPC interface attachment to use for this output. This is a convenience method that creates an
         * instance of the {@link VpcInterfaceAttachment.Builder} avoiding the need to create one manually via
         * {@link VpcInterfaceAttachment#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcInterfaceAttachment.Builder#build()} is called immediately and
         * its result is passed to {@link #vpcInterfaceAttachment(VpcInterfaceAttachment)}.
         * 
         * @param vpcInterfaceAttachment
         *        a consumer that will call methods on {@link VpcInterfaceAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcInterfaceAttachment(VpcInterfaceAttachment)
         */
        default Builder vpcInterfaceAttachment(Consumer<VpcInterfaceAttachment.Builder> vpcInterfaceAttachment) {
            return vpcInterfaceAttachment(VpcInterfaceAttachment.builder().applyMutation(vpcInterfaceAttachment).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConnectRequest.BuilderImpl implements Builder {
        private List<String> cidrAllowList = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String destination;

        private UpdateEncryption encryption;

        private String flowArn;

        private Integer maxLatency;

        private List<MediaStreamOutputConfigurationRequest> mediaStreamOutputConfigurations = DefaultSdkAutoConstructList
                .getInstance();

        private Integer minLatency;

        private String outputArn;

        private Integer port;

        private String protocol;

        private String remoteId;

        private Integer senderControlPort;

        private String senderIpAddress;

        private Integer smoothingLatency;

        private String streamId;

        private VpcInterfaceAttachment vpcInterfaceAttachment;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowOutputRequest model) {
            super(model);
            cidrAllowList(model.cidrAllowList);
            description(model.description);
            destination(model.destination);
            encryption(model.encryption);
            flowArn(model.flowArn);
            maxLatency(model.maxLatency);
            mediaStreamOutputConfigurations(model.mediaStreamOutputConfigurations);
            minLatency(model.minLatency);
            outputArn(model.outputArn);
            port(model.port);
            protocol(model.protocol);
            remoteId(model.remoteId);
            senderControlPort(model.senderControlPort);
            senderIpAddress(model.senderIpAddress);
            smoothingLatency(model.smoothingLatency);
            streamId(model.streamId);
            vpcInterfaceAttachment(model.vpcInterfaceAttachment);
        }

        public final Collection<String> getCidrAllowList() {
            if (cidrAllowList instanceof SdkAutoConstructList) {
                return null;
            }
            return cidrAllowList;
        }

        public final void setCidrAllowList(Collection<String> cidrAllowList) {
            this.cidrAllowList = ___listOf__stringCopier.copy(cidrAllowList);
        }

        @Override
        public final Builder cidrAllowList(Collection<String> cidrAllowList) {
            this.cidrAllowList = ___listOf__stringCopier.copy(cidrAllowList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrAllowList(String... cidrAllowList) {
            cidrAllowList(Arrays.asList(cidrAllowList));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final UpdateEncryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        public final void setEncryption(UpdateEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(UpdateEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final Integer getMaxLatency() {
            return maxLatency;
        }

        public final void setMaxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
        }

        @Override
        public final Builder maxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
            return this;
        }

        public final List<MediaStreamOutputConfigurationRequest.Builder> getMediaStreamOutputConfigurations() {
            List<MediaStreamOutputConfigurationRequest.Builder> result = ___listOfMediaStreamOutputConfigurationRequestCopier
                    .copyToBuilder(this.mediaStreamOutputConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaStreamOutputConfigurations(
                Collection<MediaStreamOutputConfigurationRequest.BuilderImpl> mediaStreamOutputConfigurations) {
            this.mediaStreamOutputConfigurations = ___listOfMediaStreamOutputConfigurationRequestCopier
                    .copyFromBuilder(mediaStreamOutputConfigurations);
        }

        @Override
        public final Builder mediaStreamOutputConfigurations(
                Collection<MediaStreamOutputConfigurationRequest> mediaStreamOutputConfigurations) {
            this.mediaStreamOutputConfigurations = ___listOfMediaStreamOutputConfigurationRequestCopier
                    .copy(mediaStreamOutputConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaStreamOutputConfigurations(
                MediaStreamOutputConfigurationRequest... mediaStreamOutputConfigurations) {
            mediaStreamOutputConfigurations(Arrays.asList(mediaStreamOutputConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaStreamOutputConfigurations(
                Consumer<MediaStreamOutputConfigurationRequest.Builder>... mediaStreamOutputConfigurations) {
            mediaStreamOutputConfigurations(Stream.of(mediaStreamOutputConfigurations)
                    .map(c -> MediaStreamOutputConfigurationRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getMinLatency() {
            return minLatency;
        }

        public final void setMinLatency(Integer minLatency) {
            this.minLatency = minLatency;
        }

        @Override
        public final Builder minLatency(Integer minLatency) {
            this.minLatency = minLatency;
            return this;
        }

        public final String getOutputArn() {
            return outputArn;
        }

        public final void setOutputArn(String outputArn) {
            this.outputArn = outputArn;
        }

        @Override
        public final Builder outputArn(String outputArn) {
            this.outputArn = outputArn;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getRemoteId() {
            return remoteId;
        }

        public final void setRemoteId(String remoteId) {
            this.remoteId = remoteId;
        }

        @Override
        public final Builder remoteId(String remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public final Integer getSenderControlPort() {
            return senderControlPort;
        }

        public final void setSenderControlPort(Integer senderControlPort) {
            this.senderControlPort = senderControlPort;
        }

        @Override
        public final Builder senderControlPort(Integer senderControlPort) {
            this.senderControlPort = senderControlPort;
            return this;
        }

        public final String getSenderIpAddress() {
            return senderIpAddress;
        }

        public final void setSenderIpAddress(String senderIpAddress) {
            this.senderIpAddress = senderIpAddress;
        }

        @Override
        public final Builder senderIpAddress(String senderIpAddress) {
            this.senderIpAddress = senderIpAddress;
            return this;
        }

        public final Integer getSmoothingLatency() {
            return smoothingLatency;
        }

        public final void setSmoothingLatency(Integer smoothingLatency) {
            this.smoothingLatency = smoothingLatency;
        }

        @Override
        public final Builder smoothingLatency(Integer smoothingLatency) {
            this.smoothingLatency = smoothingLatency;
            return this;
        }

        public final String getStreamId() {
            return streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final VpcInterfaceAttachment.Builder getVpcInterfaceAttachment() {
            return vpcInterfaceAttachment != null ? vpcInterfaceAttachment.toBuilder() : null;
        }

        public final void setVpcInterfaceAttachment(VpcInterfaceAttachment.BuilderImpl vpcInterfaceAttachment) {
            this.vpcInterfaceAttachment = vpcInterfaceAttachment != null ? vpcInterfaceAttachment.build() : null;
        }

        @Override
        public final Builder vpcInterfaceAttachment(VpcInterfaceAttachment vpcInterfaceAttachment) {
            this.vpcInterfaceAttachment = vpcInterfaceAttachment;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFlowOutputRequest build() {
            return new UpdateFlowOutputRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
