/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFlowSourceResponse extends MediaConnectResponse implements
        ToCopyableBuilder<UpdateFlowSourceResponse.Builder, UpdateFlowSourceResponse> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(UpdateFlowSourceResponse::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final SdkField<Source> SOURCE_FIELD = SdkField.<Source> builder(MarshallingType.SDK_POJO).memberName("Source")
            .getter(getter(UpdateFlowSourceResponse::source)).setter(setter(Builder::source)).constructor(Source::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD, SOURCE_FIELD));

    private final String flowArn;

    private final Source source;

    private UpdateFlowSourceResponse(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.source = builder.source;
    }

    /**
     * The ARN of the flow that you want to update.
     * 
     * @return The ARN of the flow that you want to update.
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * The settings for the source of the flow.
     * 
     * @return The settings for the source of the flow.
     */
    public final Source source() {
        return source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowSourceResponse)) {
            return false;
        }
        UpdateFlowSourceResponse other = (UpdateFlowSourceResponse) obj;
        return Objects.equals(flowArn(), other.flowArn()) && Objects.equals(source(), other.source());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFlowSourceResponse").add("FlowArn", flowArn()).add("Source", source()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowSourceResponse, T> g) {
        return obj -> g.apply((UpdateFlowSourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFlowSourceResponse> {
        /**
         * The ARN of the flow that you want to update.
         * 
         * @param flowArn
         *        The ARN of the flow that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * The settings for the source of the flow.
         * 
         * @param source
         *        The settings for the source of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(Source source);

        /**
         * The settings for the source of the flow. This is a convenience method that creates an instance of the
         * {@link Source.Builder} avoiding the need to create one manually via {@link Source#builder()}.
         *
         * When the {@link Consumer} completes, {@link Source.Builder#build()} is called immediately and its result is
         * passed to {@link #source(Source)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(Source)
         */
        default Builder source(Consumer<Source.Builder> source) {
            return source(Source.builder().applyMutation(source).build());
        }
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private String flowArn;

        private Source source;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowSourceResponse model) {
            super(model);
            flowArn(model.flowArn);
            source(model.source);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final Source.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        @Override
        public UpdateFlowSourceResponse build() {
            return new UpdateFlowSourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
