/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The transport parameters that you want to associate with an outbound media stream.
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationConfigurationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationConfigurationRequest.Builder, DestinationConfigurationRequest> {
    private static final SdkField<String> DESTINATION_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationIp").getter(getter(DestinationConfigurationRequest::destinationIp))
            .setter(setter(Builder::destinationIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationIp").build()).build();

    private static final SdkField<Integer> DESTINATION_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DestinationPort").getter(getter(DestinationConfigurationRequest::destinationPort))
            .setter(setter(Builder::destinationPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPort").build()).build();

    private static final SdkField<InterfaceRequest> INTERFACE_FIELD = SdkField
            .<InterfaceRequest> builder(MarshallingType.SDK_POJO).memberName("Interface")
            .getter(getter(DestinationConfigurationRequest::interfaceValue)).setter(setter(Builder::interfaceValue))
            .constructor(InterfaceRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interface").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_IP_FIELD,
            DESTINATION_PORT_FIELD, INTERFACE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destinationIp;

    private final Integer destinationPort;

    private final InterfaceRequest interfaceValue;

    private DestinationConfigurationRequest(BuilderImpl builder) {
        this.destinationIp = builder.destinationIp;
        this.destinationPort = builder.destinationPort;
        this.interfaceValue = builder.interfaceValue;
    }

    /**
     * The IP address where you want MediaConnect to send contents of the media stream.
     * 
     * @return The IP address where you want MediaConnect to send contents of the media stream.
     */
    public final String destinationIp() {
        return destinationIp;
    }

    /**
     * The port that you want MediaConnect to use when it distributes the media stream to the output.
     * 
     * @return The port that you want MediaConnect to use when it distributes the media stream to the output.
     */
    public final Integer destinationPort() {
        return destinationPort;
    }

    /**
     * The VPC interface that you want to use for the media stream associated with the output.
     * 
     * @return The VPC interface that you want to use for the media stream associated with the output.
     */
    public final InterfaceRequest interfaceValue() {
        return interfaceValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationIp());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPort());
        hashCode = 31 * hashCode + Objects.hashCode(interfaceValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationConfigurationRequest)) {
            return false;
        }
        DestinationConfigurationRequest other = (DestinationConfigurationRequest) obj;
        return Objects.equals(destinationIp(), other.destinationIp())
                && Objects.equals(destinationPort(), other.destinationPort())
                && Objects.equals(interfaceValue(), other.interfaceValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationConfigurationRequest").add("DestinationIp", destinationIp())
                .add("DestinationPort", destinationPort()).add("Interface", interfaceValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationIp":
            return Optional.ofNullable(clazz.cast(destinationIp()));
        case "DestinationPort":
            return Optional.ofNullable(clazz.cast(destinationPort()));
        case "Interface":
            return Optional.ofNullable(clazz.cast(interfaceValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationConfigurationRequest, T> g) {
        return obj -> g.apply((DestinationConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationConfigurationRequest> {
        /**
         * The IP address where you want MediaConnect to send contents of the media stream.
         * 
         * @param destinationIp
         *        The IP address where you want MediaConnect to send contents of the media stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationIp(String destinationIp);

        /**
         * The port that you want MediaConnect to use when it distributes the media stream to the output.
         * 
         * @param destinationPort
         *        The port that you want MediaConnect to use when it distributes the media stream to the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPort(Integer destinationPort);

        /**
         * The VPC interface that you want to use for the media stream associated with the output.
         * 
         * @param interfaceValue
         *        The VPC interface that you want to use for the media stream associated with the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceValue(InterfaceRequest interfaceValue);

        /**
         * The VPC interface that you want to use for the media stream associated with the output. This is a convenience
         * that creates an instance of the {@link InterfaceRequest.Builder} avoiding the need to create one manually via
         * {@link InterfaceRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link InterfaceRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #interfaceValue(InterfaceRequest)}.
         * 
         * @param interfaceValue
         *        a consumer that will call methods on {@link InterfaceRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interfaceValue(InterfaceRequest)
         */
        default Builder interfaceValue(Consumer<InterfaceRequest.Builder> interfaceValue) {
            return interfaceValue(InterfaceRequest.builder().applyMutation(interfaceValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String destinationIp;

        private Integer destinationPort;

        private InterfaceRequest interfaceValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationConfigurationRequest model) {
            destinationIp(model.destinationIp);
            destinationPort(model.destinationPort);
            interfaceValue(model.interfaceValue);
        }

        public final String getDestinationIp() {
            return destinationIp;
        }

        public final void setDestinationIp(String destinationIp) {
            this.destinationIp = destinationIp;
        }

        @Override
        @Transient
        public final Builder destinationIp(String destinationIp) {
            this.destinationIp = destinationIp;
            return this;
        }

        public final Integer getDestinationPort() {
            return destinationPort;
        }

        public final void setDestinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
        }

        @Override
        @Transient
        public final Builder destinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public final InterfaceRequest.Builder getInterfaceValue() {
            return interfaceValue != null ? interfaceValue.toBuilder() : null;
        }

        public final void setInterfaceValue(InterfaceRequest.BuilderImpl interfaceValue) {
            this.interfaceValue = interfaceValue != null ? interfaceValue.build() : null;
        }

        @Override
        @Transient
        public final Builder interfaceValue(InterfaceRequest interfaceValue) {
            this.interfaceValue = interfaceValue;
            return this;
        }

        @Override
        public DestinationConfigurationRequest build() {
            return new DestinationConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
