/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to
 * outputs on flows that have a CDI source.
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncodingParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<EncodingParameters.Builder, EncodingParameters> {
    private static final SdkField<Double> COMPRESSION_FACTOR_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("CompressionFactor").getter(getter(EncodingParameters::compressionFactor))
            .setter(setter(Builder::compressionFactor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compressionFactor").build()).build();

    private static final SdkField<String> ENCODER_PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncoderProfile").getter(getter(EncodingParameters::encoderProfileAsString))
            .setter(setter(Builder::encoderProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encoderProfile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPRESSION_FACTOR_FIELD,
            ENCODER_PROFILE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double compressionFactor;

    private final String encoderProfile;

    private EncodingParameters(BuilderImpl builder) {
        this.compressionFactor = builder.compressionFactor;
        this.encoderProfile = builder.encoderProfile;
    }

    /**
     * A value that is used to calculate compression for an output. The bitrate of the output is calculated as follows:
     * Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to outputs that use the ST
     * 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid values are floating point numbers in
     * the range of 3.0 to 10.0, inclusive.
     * 
     * @return A value that is used to calculate compression for an output. The bitrate of the output is calculated as
     *         follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to
     *         outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid
     *         values are floating point numbers in the range of 3.0 to 10.0, inclusive.
     */
    public final Double compressionFactor() {
        return compressionFactor;
    }

    /**
     * A setting on the encoder that drives compression settings. This property only applies to video media streams
     * associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encoderProfile}
     * will return {@link EncoderProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encoderProfileAsString}.
     * </p>
     * 
     * @return A setting on the encoder that drives compression settings. This property only applies to video media
     *         streams associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the
     *         CDI protocol.
     * @see EncoderProfile
     */
    public final EncoderProfile encoderProfile() {
        return EncoderProfile.fromValue(encoderProfile);
    }

    /**
     * A setting on the encoder that drives compression settings. This property only applies to video media streams
     * associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encoderProfile}
     * will return {@link EncoderProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encoderProfileAsString}.
     * </p>
     * 
     * @return A setting on the encoder that drives compression settings. This property only applies to video media
     *         streams associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the
     *         CDI protocol.
     * @see EncoderProfile
     */
    public final String encoderProfileAsString() {
        return encoderProfile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(compressionFactor());
        hashCode = 31 * hashCode + Objects.hashCode(encoderProfileAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncodingParameters)) {
            return false;
        }
        EncodingParameters other = (EncodingParameters) obj;
        return Objects.equals(compressionFactor(), other.compressionFactor())
                && Objects.equals(encoderProfileAsString(), other.encoderProfileAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EncodingParameters").add("CompressionFactor", compressionFactor())
                .add("EncoderProfile", encoderProfileAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompressionFactor":
            return Optional.ofNullable(clazz.cast(compressionFactor()));
        case "EncoderProfile":
            return Optional.ofNullable(clazz.cast(encoderProfileAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncodingParameters, T> g) {
        return obj -> g.apply((EncodingParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncodingParameters> {
        /**
         * A value that is used to calculate compression for an output. The bitrate of the output is calculated as
         * follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to outputs
         * that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid values are
         * floating point numbers in the range of 3.0 to 10.0, inclusive.
         * 
         * @param compressionFactor
         *        A value that is used to calculate compression for an output. The bitrate of the output is calculated
         *        as follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to
         *        outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid
         *        values are floating point numbers in the range of 3.0 to 10.0, inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compressionFactor(Double compressionFactor);

        /**
         * A setting on the encoder that drives compression settings. This property only applies to video media streams
         * associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol.
         * 
         * @param encoderProfile
         *        A setting on the encoder that drives compression settings. This property only applies to video media
         *        streams associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses
         *        the CDI protocol.
         * @see EncoderProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncoderProfile
         */
        Builder encoderProfile(String encoderProfile);

        /**
         * A setting on the encoder that drives compression settings. This property only applies to video media streams
         * associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol.
         * 
         * @param encoderProfile
         *        A setting on the encoder that drives compression settings. This property only applies to video media
         *        streams associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses
         *        the CDI protocol.
         * @see EncoderProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncoderProfile
         */
        Builder encoderProfile(EncoderProfile encoderProfile);
    }

    static final class BuilderImpl implements Builder {
        private Double compressionFactor;

        private String encoderProfile;

        private BuilderImpl() {
        }

        private BuilderImpl(EncodingParameters model) {
            compressionFactor(model.compressionFactor);
            encoderProfile(model.encoderProfile);
        }

        public final Double getCompressionFactor() {
            return compressionFactor;
        }

        public final void setCompressionFactor(Double compressionFactor) {
            this.compressionFactor = compressionFactor;
        }

        @Override
        @Transient
        public final Builder compressionFactor(Double compressionFactor) {
            this.compressionFactor = compressionFactor;
            return this;
        }

        public final String getEncoderProfile() {
            return encoderProfile;
        }

        public final void setEncoderProfile(String encoderProfile) {
            this.encoderProfile = encoderProfile;
        }

        @Override
        @Transient
        public final Builder encoderProfile(String encoderProfile) {
            this.encoderProfile = encoderProfile;
            return this;
        }

        @Override
        @Transient
        public final Builder encoderProfile(EncoderProfile encoderProfile) {
            this.encoderProfile(encoderProfile == null ? null : encoderProfile.toString());
            return this;
        }

        @Override
        public EncodingParameters build() {
            return new EncodingParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
