/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * FMTP
 */
@Generated("software.amazon.awssdk:codegen")
public final class Fmtp implements SdkPojo, Serializable, ToCopyableBuilder<Fmtp.Builder, Fmtp> {
    private static final SdkField<String> CHANNEL_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelOrder").getter(getter(Fmtp::channelOrder)).setter(setter(Builder::channelOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelOrder").build()).build();

    private static final SdkField<String> COLORIMETRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Colorimetry").getter(getter(Fmtp::colorimetryAsString)).setter(setter(Builder::colorimetry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorimetry").build()).build();

    private static final SdkField<String> EXACT_FRAMERATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExactFramerate").getter(getter(Fmtp::exactFramerate)).setter(setter(Builder::exactFramerate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exactFramerate").build()).build();

    private static final SdkField<String> PAR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Par")
            .getter(getter(Fmtp::par)).setter(setter(Builder::par))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("par").build()).build();

    private static final SdkField<String> RANGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Range")
            .getter(getter(Fmtp::rangeAsString)).setter(setter(Builder::range))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("range").build()).build();

    private static final SdkField<String> SCAN_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScanMode").getter(getter(Fmtp::scanModeAsString)).setter(setter(Builder::scanMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanMode").build()).build();

    private static final SdkField<String> TCS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tcs")
            .getter(getter(Fmtp::tcsAsString)).setter(setter(Builder::tcs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tcs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ORDER_FIELD,
            COLORIMETRY_FIELD, EXACT_FRAMERATE_FIELD, PAR_FIELD, RANGE_FIELD, SCAN_MODE_FIELD, TCS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String channelOrder;

    private final String colorimetry;

    private final String exactFramerate;

    private final String par;

    private final String range;

    private final String scanMode;

    private final String tcs;

    private Fmtp(BuilderImpl builder) {
        this.channelOrder = builder.channelOrder;
        this.colorimetry = builder.colorimetry;
        this.exactFramerate = builder.exactFramerate;
        this.par = builder.par;
        this.range = builder.range;
        this.scanMode = builder.scanMode;
        this.tcs = builder.tcs;
    }

    /**
     * The format of the audio channel.
     * 
     * @return The format of the audio channel.
     */
    public final String channelOrder() {
        return channelOrder;
    }

    /**
     * The format that is used for the representation of color.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #colorimetry} will
     * return {@link Colorimetry#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #colorimetryAsString}.
     * </p>
     * 
     * @return The format that is used for the representation of color.
     * @see Colorimetry
     */
    public final Colorimetry colorimetry() {
        return Colorimetry.fromValue(colorimetry);
    }

    /**
     * The format that is used for the representation of color.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #colorimetry} will
     * return {@link Colorimetry#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #colorimetryAsString}.
     * </p>
     * 
     * @return The format that is used for the representation of color.
     * @see Colorimetry
     */
    public final String colorimetryAsString() {
        return colorimetry;
    }

    /**
     * The frame rate for the video stream, in frames/second. For example: 60000/1001. If you specify a whole number,
     * MediaConnect uses a ratio of N/1. For example, if you specify 60, MediaConnect uses 60/1 as the exactFramerate.
     * 
     * @return The frame rate for the video stream, in frames/second. For example: 60000/1001. If you specify a whole
     *         number, MediaConnect uses a ratio of N/1. For example, if you specify 60, MediaConnect uses 60/1 as the
     *         exactFramerate.
     */
    public final String exactFramerate() {
        return exactFramerate;
    }

    /**
     * The pixel aspect ratio (PAR) of the video.
     * 
     * @return The pixel aspect ratio (PAR) of the video.
     */
    public final String par() {
        return par;
    }

    /**
     * The encoding range of the video.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #range} will return
     * {@link Range#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rangeAsString}.
     * </p>
     * 
     * @return The encoding range of the video.
     * @see Range
     */
    public final Range range() {
        return Range.fromValue(range);
    }

    /**
     * The encoding range of the video.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #range} will return
     * {@link Range#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rangeAsString}.
     * </p>
     * 
     * @return The encoding range of the video.
     * @see Range
     */
    public final String rangeAsString() {
        return range;
    }

    /**
     * The type of compression that was used to smooth the video’s appearance
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanMode} will
     * return {@link ScanMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanModeAsString}.
     * </p>
     * 
     * @return The type of compression that was used to smooth the video’s appearance
     * @see ScanMode
     */
    public final ScanMode scanMode() {
        return ScanMode.fromValue(scanMode);
    }

    /**
     * The type of compression that was used to smooth the video’s appearance
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanMode} will
     * return {@link ScanMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanModeAsString}.
     * </p>
     * 
     * @return The type of compression that was used to smooth the video’s appearance
     * @see ScanMode
     */
    public final String scanModeAsString() {
        return scanMode;
    }

    /**
     * The transfer characteristic system (TCS) that is used in the video.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tcs} will return
     * {@link Tcs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from {@link #tcsAsString}.
     * </p>
     * 
     * @return The transfer characteristic system (TCS) that is used in the video.
     * @see Tcs
     */
    public final Tcs tcs() {
        return Tcs.fromValue(tcs);
    }

    /**
     * The transfer characteristic system (TCS) that is used in the video.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tcs} will return
     * {@link Tcs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from {@link #tcsAsString}.
     * </p>
     * 
     * @return The transfer characteristic system (TCS) that is used in the video.
     * @see Tcs
     */
    public final String tcsAsString() {
        return tcs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelOrder());
        hashCode = 31 * hashCode + Objects.hashCode(colorimetryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exactFramerate());
        hashCode = 31 * hashCode + Objects.hashCode(par());
        hashCode = 31 * hashCode + Objects.hashCode(rangeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scanModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tcsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Fmtp)) {
            return false;
        }
        Fmtp other = (Fmtp) obj;
        return Objects.equals(channelOrder(), other.channelOrder())
                && Objects.equals(colorimetryAsString(), other.colorimetryAsString())
                && Objects.equals(exactFramerate(), other.exactFramerate()) && Objects.equals(par(), other.par())
                && Objects.equals(rangeAsString(), other.rangeAsString())
                && Objects.equals(scanModeAsString(), other.scanModeAsString())
                && Objects.equals(tcsAsString(), other.tcsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Fmtp").add("ChannelOrder", channelOrder()).add("Colorimetry", colorimetryAsString())
                .add("ExactFramerate", exactFramerate()).add("Par", par()).add("Range", rangeAsString())
                .add("ScanMode", scanModeAsString()).add("Tcs", tcsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelOrder":
            return Optional.ofNullable(clazz.cast(channelOrder()));
        case "Colorimetry":
            return Optional.ofNullable(clazz.cast(colorimetryAsString()));
        case "ExactFramerate":
            return Optional.ofNullable(clazz.cast(exactFramerate()));
        case "Par":
            return Optional.ofNullable(clazz.cast(par()));
        case "Range":
            return Optional.ofNullable(clazz.cast(rangeAsString()));
        case "ScanMode":
            return Optional.ofNullable(clazz.cast(scanModeAsString()));
        case "Tcs":
            return Optional.ofNullable(clazz.cast(tcsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Fmtp, T> g) {
        return obj -> g.apply((Fmtp) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Fmtp> {
        /**
         * The format of the audio channel.
         * 
         * @param channelOrder
         *        The format of the audio channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelOrder(String channelOrder);

        /**
         * The format that is used for the representation of color.
         * 
         * @param colorimetry
         *        The format that is used for the representation of color.
         * @see Colorimetry
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Colorimetry
         */
        Builder colorimetry(String colorimetry);

        /**
         * The format that is used for the representation of color.
         * 
         * @param colorimetry
         *        The format that is used for the representation of color.
         * @see Colorimetry
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Colorimetry
         */
        Builder colorimetry(Colorimetry colorimetry);

        /**
         * The frame rate for the video stream, in frames/second. For example: 60000/1001. If you specify a whole
         * number, MediaConnect uses a ratio of N/1. For example, if you specify 60, MediaConnect uses 60/1 as the
         * exactFramerate.
         * 
         * @param exactFramerate
         *        The frame rate for the video stream, in frames/second. For example: 60000/1001. If you specify a whole
         *        number, MediaConnect uses a ratio of N/1. For example, if you specify 60, MediaConnect uses 60/1 as
         *        the exactFramerate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exactFramerate(String exactFramerate);

        /**
         * The pixel aspect ratio (PAR) of the video.
         * 
         * @param par
         *        The pixel aspect ratio (PAR) of the video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder par(String par);

        /**
         * The encoding range of the video.
         * 
         * @param range
         *        The encoding range of the video.
         * @see Range
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Range
         */
        Builder range(String range);

        /**
         * The encoding range of the video.
         * 
         * @param range
         *        The encoding range of the video.
         * @see Range
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Range
         */
        Builder range(Range range);

        /**
         * The type of compression that was used to smooth the video’s appearance
         * 
         * @param scanMode
         *        The type of compression that was used to smooth the video’s appearance
         * @see ScanMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanMode
         */
        Builder scanMode(String scanMode);

        /**
         * The type of compression that was used to smooth the video’s appearance
         * 
         * @param scanMode
         *        The type of compression that was used to smooth the video’s appearance
         * @see ScanMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanMode
         */
        Builder scanMode(ScanMode scanMode);

        /**
         * The transfer characteristic system (TCS) that is used in the video.
         * 
         * @param tcs
         *        The transfer characteristic system (TCS) that is used in the video.
         * @see Tcs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tcs
         */
        Builder tcs(String tcs);

        /**
         * The transfer characteristic system (TCS) that is used in the video.
         * 
         * @param tcs
         *        The transfer characteristic system (TCS) that is used in the video.
         * @see Tcs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tcs
         */
        Builder tcs(Tcs tcs);
    }

    static final class BuilderImpl implements Builder {
        private String channelOrder;

        private String colorimetry;

        private String exactFramerate;

        private String par;

        private String range;

        private String scanMode;

        private String tcs;

        private BuilderImpl() {
        }

        private BuilderImpl(Fmtp model) {
            channelOrder(model.channelOrder);
            colorimetry(model.colorimetry);
            exactFramerate(model.exactFramerate);
            par(model.par);
            range(model.range);
            scanMode(model.scanMode);
            tcs(model.tcs);
        }

        public final String getChannelOrder() {
            return channelOrder;
        }

        public final void setChannelOrder(String channelOrder) {
            this.channelOrder = channelOrder;
        }

        @Override
        @Transient
        public final Builder channelOrder(String channelOrder) {
            this.channelOrder = channelOrder;
            return this;
        }

        public final String getColorimetry() {
            return colorimetry;
        }

        public final void setColorimetry(String colorimetry) {
            this.colorimetry = colorimetry;
        }

        @Override
        @Transient
        public final Builder colorimetry(String colorimetry) {
            this.colorimetry = colorimetry;
            return this;
        }

        @Override
        @Transient
        public final Builder colorimetry(Colorimetry colorimetry) {
            this.colorimetry(colorimetry == null ? null : colorimetry.toString());
            return this;
        }

        public final String getExactFramerate() {
            return exactFramerate;
        }

        public final void setExactFramerate(String exactFramerate) {
            this.exactFramerate = exactFramerate;
        }

        @Override
        @Transient
        public final Builder exactFramerate(String exactFramerate) {
            this.exactFramerate = exactFramerate;
            return this;
        }

        public final String getPar() {
            return par;
        }

        public final void setPar(String par) {
            this.par = par;
        }

        @Override
        @Transient
        public final Builder par(String par) {
            this.par = par;
            return this;
        }

        public final String getRange() {
            return range;
        }

        public final void setRange(String range) {
            this.range = range;
        }

        @Override
        @Transient
        public final Builder range(String range) {
            this.range = range;
            return this;
        }

        @Override
        @Transient
        public final Builder range(Range range) {
            this.range(range == null ? null : range.toString());
            return this;
        }

        public final String getScanMode() {
            return scanMode;
        }

        public final void setScanMode(String scanMode) {
            this.scanMode = scanMode;
        }

        @Override
        @Transient
        public final Builder scanMode(String scanMode) {
            this.scanMode = scanMode;
            return this;
        }

        @Override
        @Transient
        public final Builder scanMode(ScanMode scanMode) {
            this.scanMode(scanMode == null ? null : scanMode.toString());
            return this;
        }

        public final String getTcs() {
            return tcs;
        }

        public final void setTcs(String tcs) {
            this.tcs = tcs;
        }

        @Override
        @Transient
        public final Builder tcs(String tcs) {
            this.tcs = tcs;
            return this;
        }

        @Override
        @Transient
        public final Builder tcs(Tcs tcs) {
            this.tcs(tcs == null ? null : tcs.toString());
            return this;
        }

        @Override
        public Fmtp build() {
            return new Fmtp(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
