/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The settings for attaching a VPC interface to an output.
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcInterfaceAttachment implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcInterfaceAttachment.Builder, VpcInterfaceAttachment> {
    private static final SdkField<String> VPC_INTERFACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcInterfaceName").getter(getter(VpcInterfaceAttachment::vpcInterfaceName))
            .setter(setter(Builder::vpcInterfaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_INTERFACE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String vpcInterfaceName;

    private VpcInterfaceAttachment(BuilderImpl builder) {
        this.vpcInterfaceName = builder.vpcInterfaceName;
    }

    /**
     * The name of the VPC interface to use for this output.
     * 
     * @return The name of the VPC interface to use for this output.
     */
    public final String vpcInterfaceName() {
        return vpcInterfaceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcInterfaceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcInterfaceAttachment)) {
            return false;
        }
        VpcInterfaceAttachment other = (VpcInterfaceAttachment) obj;
        return Objects.equals(vpcInterfaceName(), other.vpcInterfaceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcInterfaceAttachment").add("VpcInterfaceName", vpcInterfaceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcInterfaceName":
            return Optional.ofNullable(clazz.cast(vpcInterfaceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcInterfaceAttachment, T> g) {
        return obj -> g.apply((VpcInterfaceAttachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcInterfaceAttachment> {
        /**
         * The name of the VPC interface to use for this output.
         * 
         * @param vpcInterfaceName
         *        The name of the VPC interface to use for this output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcInterfaceName(String vpcInterfaceName);
    }

    static final class BuilderImpl implements Builder {
        private String vpcInterfaceName;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcInterfaceAttachment model) {
            vpcInterfaceName(model.vpcInterfaceName);
        }

        public final String getVpcInterfaceName() {
            return vpcInterfaceName;
        }

        public final void setVpcInterfaceName(String vpcInterfaceName) {
            this.vpcInterfaceName = vpcInterfaceName;
        }

        @Override
        @Transient
        public final Builder vpcInterfaceName(String vpcInterfaceName) {
            this.vpcInterfaceName = vpcInterfaceName;
            return this;
        }

        @Override
        public VpcInterfaceAttachment build() {
            return new VpcInterfaceAttachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
