/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally
 * prioritized streams.
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourcePriority implements SdkPojo, Serializable, ToCopyableBuilder<SourcePriority.Builder, SourcePriority> {
    private static final SdkField<String> PRIMARY_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimarySource").getter(getter(SourcePriority::primarySource)).setter(setter(Builder::primarySource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primarySource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String primarySource;

    private SourcePriority(BuilderImpl builder) {
        this.primarySource = builder.primarySource;
    }

    /**
     * The name of the source you choose as the primary source for this flow.
     * 
     * @return The name of the source you choose as the primary source for this flow.
     */
    public final String primarySource() {
        return primarySource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primarySource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourcePriority)) {
            return false;
        }
        SourcePriority other = (SourcePriority) obj;
        return Objects.equals(primarySource(), other.primarySource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourcePriority").add("PrimarySource", primarySource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrimarySource":
            return Optional.ofNullable(clazz.cast(primarySource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourcePriority, T> g) {
        return obj -> g.apply((SourcePriority) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourcePriority> {
        /**
         * The name of the source you choose as the primary source for this flow.
         * 
         * @param primarySource
         *        The name of the source you choose as the primary source for this flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primarySource(String primarySource);
    }

    static final class BuilderImpl implements Builder {
        private String primarySource;

        private BuilderImpl() {
        }

        private BuilderImpl(SourcePriority model) {
            primarySource(model.primarySource);
        }

        public final String getPrimarySource() {
            return primarySource;
        }

        public final void setPrimarySource(String primarySource) {
            this.primarySource = primarySource;
        }

        @Override
        @Transient
        public final Builder primarySource(String primarySource) {
            this.primarySource = primarySource;
            return this;
        }

        @Override
        public SourcePriority build() {
            return new SourcePriority(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
