/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReservationsResponse extends MediaConnectResponse implements
        ToCopyableBuilder<ListReservationsResponse.Builder, ListReservationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListReservationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<Reservation>> RESERVATIONS_FIELD = SdkField
            .<List<Reservation>> builder(MarshallingType.LIST)
            .memberName("Reservations")
            .getter(getter(ListReservationsResponse::reservations))
            .setter(setter(Builder::reservations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Reservation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Reservation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RESERVATIONS_FIELD));

    private final String nextToken;

    private final List<Reservation> reservations;

    private ListReservationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reservations = builder.reservations;
    }

    /**
     * The token that identifies which batch of results that you want to see. For example, you submit a ListReservations
     * request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value.
     * To see the next batch of results, you can submit the ListReservations request a second time and specify the
     * NextToken value.
     * 
     * @return The token that identifies which batch of results that you want to see. For example, you submit a
     *         ListReservations request with MaxResults set at 5. The service returns the first batch of results (up to
     *         5) and a NextToken value. To see the next batch of results, you can submit the ListReservations request a
     *         second time and specify the NextToken value.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Reservations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReservations() {
        return reservations != null && !(reservations instanceof SdkAutoConstructList);
    }

    /**
     * A list of all reservations that have been purchased by this account in the current AWS Region.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReservations} method.
     * </p>
     * 
     * @return A list of all reservations that have been purchased by this account in the current AWS Region.
     */
    public final List<Reservation> reservations() {
        return reservations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasReservations() ? reservations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReservationsResponse)) {
            return false;
        }
        ListReservationsResponse other = (ListReservationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasReservations() == other.hasReservations()
                && Objects.equals(reservations(), other.reservations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListReservationsResponse").add("NextToken", nextToken())
                .add("Reservations", hasReservations() ? reservations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Reservations":
            return Optional.ofNullable(clazz.cast(reservations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListReservationsResponse, T> g) {
        return obj -> g.apply((ListReservationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListReservationsResponse> {
        /**
         * The token that identifies which batch of results that you want to see. For example, you submit a
         * ListReservations request with MaxResults set at 5. The service returns the first batch of results (up to 5)
         * and a NextToken value. To see the next batch of results, you can submit the ListReservations request a second
         * time and specify the NextToken value.
         * 
         * @param nextToken
         *        The token that identifies which batch of results that you want to see. For example, you submit a
         *        ListReservations request with MaxResults set at 5. The service returns the first batch of results (up
         *        to 5) and a NextToken value. To see the next batch of results, you can submit the ListReservations
         *        request a second time and specify the NextToken value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * A list of all reservations that have been purchased by this account in the current AWS Region.
         * 
         * @param reservations
         *        A list of all reservations that have been purchased by this account in the current AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservations(Collection<Reservation> reservations);

        /**
         * A list of all reservations that have been purchased by this account in the current AWS Region.
         * 
         * @param reservations
         *        A list of all reservations that have been purchased by this account in the current AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservations(Reservation... reservations);

        /**
         * A list of all reservations that have been purchased by this account in the current AWS Region. This is a
         * convenience that creates an instance of the {@link List<Reservation>.Builder} avoiding the need to create one
         * manually via {@link List<Reservation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Reservation>.Builder#build()} is called immediately and its
         * result is passed to {@link #reservations(List<Reservation>)}.
         * 
         * @param reservations
         *        a consumer that will call methods on {@link List<Reservation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservations(List<Reservation>)
         */
        Builder reservations(Consumer<Reservation.Builder>... reservations);
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<Reservation> reservations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListReservationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            reservations(model.reservations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Reservation.Builder> getReservations() {
            List<Reservation.Builder> result = ___listOfReservationCopier.copyToBuilder(this.reservations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservations(Collection<Reservation.BuilderImpl> reservations) {
            this.reservations = ___listOfReservationCopier.copyFromBuilder(reservations);
        }

        @Override
        @Transient
        public final Builder reservations(Collection<Reservation> reservations) {
            this.reservations = ___listOfReservationCopier.copy(reservations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reservations(Reservation... reservations) {
            reservations(Arrays.asList(reservations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reservations(Consumer<Reservation.Builder>... reservations) {
            reservations(Stream.of(reservations).map(c -> Reservation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListReservationsResponse build() {
            return new ListReservationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
