/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Attributes that are related to the media stream.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaStreamAttributesRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaStreamAttributesRequest.Builder, MediaStreamAttributesRequest> {
    private static final SdkField<FmtpRequest> FMTP_FIELD = SdkField.<FmtpRequest> builder(MarshallingType.SDK_POJO)
            .memberName("Fmtp").getter(getter(MediaStreamAttributesRequest::fmtp)).setter(setter(Builder::fmtp))
            .constructor(FmtpRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fmtp").build()).build();

    private static final SdkField<String> LANG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Lang")
            .getter(getter(MediaStreamAttributesRequest::lang)).setter(setter(Builder::lang))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lang").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FMTP_FIELD, LANG_FIELD));

    private static final long serialVersionUID = 1L;

    private final FmtpRequest fmtp;

    private final String lang;

    private MediaStreamAttributesRequest(BuilderImpl builder) {
        this.fmtp = builder.fmtp;
        this.lang = builder.lang;
    }

    /**
     * The settings that you want to use to define the media stream.
     * 
     * @return The settings that you want to use to define the media stream.
     */
    public final FmtpRequest fmtp() {
        return fmtp;
    }

    /**
     * The audio language, in a format that is recognized by the receiver.
     * 
     * @return The audio language, in a format that is recognized by the receiver.
     */
    public final String lang() {
        return lang;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fmtp());
        hashCode = 31 * hashCode + Objects.hashCode(lang());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaStreamAttributesRequest)) {
            return false;
        }
        MediaStreamAttributesRequest other = (MediaStreamAttributesRequest) obj;
        return Objects.equals(fmtp(), other.fmtp()) && Objects.equals(lang(), other.lang());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaStreamAttributesRequest").add("Fmtp", fmtp()).add("Lang", lang()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Fmtp":
            return Optional.ofNullable(clazz.cast(fmtp()));
        case "Lang":
            return Optional.ofNullable(clazz.cast(lang()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MediaStreamAttributesRequest, T> g) {
        return obj -> g.apply((MediaStreamAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaStreamAttributesRequest> {
        /**
         * The settings that you want to use to define the media stream.
         * 
         * @param fmtp
         *        The settings that you want to use to define the media stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fmtp(FmtpRequest fmtp);

        /**
         * The settings that you want to use to define the media stream. This is a convenience that creates an instance
         * of the {@link FmtpRequest.Builder} avoiding the need to create one manually via {@link FmtpRequest#builder()}
         * .
         *
         * When the {@link Consumer} completes, {@link FmtpRequest.Builder#build()} is called immediately and its result
         * is passed to {@link #fmtp(FmtpRequest)}.
         * 
         * @param fmtp
         *        a consumer that will call methods on {@link FmtpRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fmtp(FmtpRequest)
         */
        default Builder fmtp(Consumer<FmtpRequest.Builder> fmtp) {
            return fmtp(FmtpRequest.builder().applyMutation(fmtp).build());
        }

        /**
         * The audio language, in a format that is recognized by the receiver.
         * 
         * @param lang
         *        The audio language, in a format that is recognized by the receiver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lang(String lang);
    }

    static final class BuilderImpl implements Builder {
        private FmtpRequest fmtp;

        private String lang;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaStreamAttributesRequest model) {
            fmtp(model.fmtp);
            lang(model.lang);
        }

        public final FmtpRequest.Builder getFmtp() {
            return fmtp != null ? fmtp.toBuilder() : null;
        }

        public final void setFmtp(FmtpRequest.BuilderImpl fmtp) {
            this.fmtp = fmtp != null ? fmtp.build() : null;
        }

        @Override
        @Transient
        public final Builder fmtp(FmtpRequest fmtp) {
            this.fmtp = fmtp;
            return this;
        }

        public final String getLang() {
            return lang;
        }

        public final void setLang(String lang) {
            this.lang = lang;
        }

        @Override
        @Transient
        public final Builder lang(String lang) {
            this.lang = lang;
            return this;
        }

        @Override
        public MediaStreamAttributesRequest build() {
            return new MediaStreamAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
