/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The settings for the source of the flow.
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetSourceRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<SetSourceRequest.Builder, SetSourceRequest> {
    private static final SdkField<Encryption> DECRYPTION_FIELD = SdkField.<Encryption> builder(MarshallingType.SDK_POJO)
            .memberName("Decryption").getter(getter(SetSourceRequest::decryption)).setter(setter(Builder::decryption))
            .constructor(Encryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decryption").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(SetSourceRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENTITLEMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntitlementArn").getter(getter(SetSourceRequest::entitlementArn))
            .setter(setter(Builder::entitlementArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlementArn").build()).build();

    private static final SdkField<Integer> INGEST_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("IngestPort").getter(getter(SetSourceRequest::ingestPort)).setter(setter(Builder::ingestPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestPort").build()).build();

    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxBitrate").getter(getter(SetSourceRequest::maxBitrate)).setter(setter(Builder::maxBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()).build();

    private static final SdkField<Integer> MAX_LATENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxLatency").getter(getter(SetSourceRequest::maxLatency)).setter(setter(Builder::maxLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLatency").build()).build();

    private static final SdkField<Integer> MAX_SYNC_BUFFER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSyncBuffer").getter(getter(SetSourceRequest::maxSyncBuffer)).setter(setter(Builder::maxSyncBuffer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSyncBuffer").build()).build();

    private static final SdkField<List<MediaStreamSourceConfigurationRequest>> MEDIA_STREAM_SOURCE_CONFIGURATIONS_FIELD = SdkField
            .<List<MediaStreamSourceConfigurationRequest>> builder(MarshallingType.LIST)
            .memberName("MediaStreamSourceConfigurations")
            .getter(getter(SetSourceRequest::mediaStreamSourceConfigurations))
            .setter(setter(Builder::mediaStreamSourceConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreamSourceConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MediaStreamSourceConfigurationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaStreamSourceConfigurationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MIN_LATENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinLatency").getter(getter(SetSourceRequest::minLatency)).setter(setter(Builder::minLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minLatency").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SetSourceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(SetSourceRequest::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<Integer> SENDER_CONTROL_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SenderControlPort").getter(getter(SetSourceRequest::senderControlPort))
            .setter(setter(Builder::senderControlPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("senderControlPort").build()).build();

    private static final SdkField<String> SENDER_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SenderIpAddress").getter(getter(SetSourceRequest::senderIpAddress))
            .setter(setter(Builder::senderIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("senderIpAddress").build()).build();

    private static final SdkField<String> SOURCE_LISTENER_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceListenerAddress").getter(getter(SetSourceRequest::sourceListenerAddress))
            .setter(setter(Builder::sourceListenerAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceListenerAddress").build())
            .build();

    private static final SdkField<Integer> SOURCE_LISTENER_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SourceListenerPort").getter(getter(SetSourceRequest::sourceListenerPort))
            .setter(setter(Builder::sourceListenerPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceListenerPort").build())
            .build();

    private static final SdkField<String> STREAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamId").getter(getter(SetSourceRequest::streamId)).setter(setter(Builder::streamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()).build();

    private static final SdkField<String> VPC_INTERFACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcInterfaceName").getter(getter(SetSourceRequest::vpcInterfaceName))
            .setter(setter(Builder::vpcInterfaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaceName").build()).build();

    private static final SdkField<String> WHITELIST_CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WhitelistCidr").getter(getter(SetSourceRequest::whitelistCidr)).setter(setter(Builder::whitelistCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("whitelistCidr").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECRYPTION_FIELD,
            DESCRIPTION_FIELD, ENTITLEMENT_ARN_FIELD, INGEST_PORT_FIELD, MAX_BITRATE_FIELD, MAX_LATENCY_FIELD,
            MAX_SYNC_BUFFER_FIELD, MEDIA_STREAM_SOURCE_CONFIGURATIONS_FIELD, MIN_LATENCY_FIELD, NAME_FIELD, PROTOCOL_FIELD,
            SENDER_CONTROL_PORT_FIELD, SENDER_IP_ADDRESS_FIELD, SOURCE_LISTENER_ADDRESS_FIELD, SOURCE_LISTENER_PORT_FIELD,
            STREAM_ID_FIELD, VPC_INTERFACE_NAME_FIELD, WHITELIST_CIDR_FIELD));

    private static final long serialVersionUID = 1L;

    private final Encryption decryption;

    private final String description;

    private final String entitlementArn;

    private final Integer ingestPort;

    private final Integer maxBitrate;

    private final Integer maxLatency;

    private final Integer maxSyncBuffer;

    private final List<MediaStreamSourceConfigurationRequest> mediaStreamSourceConfigurations;

    private final Integer minLatency;

    private final String name;

    private final String protocol;

    private final Integer senderControlPort;

    private final String senderIpAddress;

    private final String sourceListenerAddress;

    private final Integer sourceListenerPort;

    private final String streamId;

    private final String vpcInterfaceName;

    private final String whitelistCidr;

    private SetSourceRequest(BuilderImpl builder) {
        this.decryption = builder.decryption;
        this.description = builder.description;
        this.entitlementArn = builder.entitlementArn;
        this.ingestPort = builder.ingestPort;
        this.maxBitrate = builder.maxBitrate;
        this.maxLatency = builder.maxLatency;
        this.maxSyncBuffer = builder.maxSyncBuffer;
        this.mediaStreamSourceConfigurations = builder.mediaStreamSourceConfigurations;
        this.minLatency = builder.minLatency;
        this.name = builder.name;
        this.protocol = builder.protocol;
        this.senderControlPort = builder.senderControlPort;
        this.senderIpAddress = builder.senderIpAddress;
        this.sourceListenerAddress = builder.sourceListenerAddress;
        this.sourceListenerPort = builder.sourceListenerPort;
        this.streamId = builder.streamId;
        this.vpcInterfaceName = builder.vpcInterfaceName;
        this.whitelistCidr = builder.whitelistCidr;
    }

    /**
     * The type of encryption that is used on the content ingested from this source.
     * 
     * @return The type of encryption that is used on the content ingested from this source.
     */
    public final Encryption decryption() {
        return decryption;
    }

    /**
     * A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect
     * account.
     * 
     * @return A description for the source. This value is not used or seen outside of the current AWS Elemental
     *         MediaConnect account.
     */
    public final String description() {
        return description;
    }

    /**
     * The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow
     * originator, and the ARN is generated as part of the originator's flow.
     * 
     * @return The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow
     *         originator, and the ARN is generated as part of the originator's flow.
     */
    public final String entitlementArn() {
        return entitlementArn;
    }

    /**
     * The port that the flow will be listening on for incoming content.
     * 
     * @return The port that the flow will be listening on for incoming content.
     */
    public final Integer ingestPort() {
        return ingestPort;
    }

    /**
     * The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
     * 
     * @return The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
     */
    public final Integer maxBitrate() {
        return maxBitrate;
    }

    /**
     * The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based
     * streams.
     * 
     * @return The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and
     *         Fujitsu-based streams.
     */
    public final Integer maxLatency() {
        return maxLatency;
    }

    /**
     * The size of the buffer (in milliseconds) to use to sync incoming source data.
     * 
     * @return The size of the buffer (in milliseconds) to use to sync incoming source data.
     */
    public final Integer maxSyncBuffer() {
        return maxSyncBuffer;
    }

    /**
     * For responses, this returns true if the service returned a value for the MediaStreamSourceConfigurations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasMediaStreamSourceConfigurations() {
        return mediaStreamSourceConfigurations != null && !(mediaStreamSourceConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * The media streams that are associated with the source, and the parameters for those associations.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMediaStreamSourceConfigurations}
     * method.
     * </p>
     * 
     * @return The media streams that are associated with the source, and the parameters for those associations.
     */
    public final List<MediaStreamSourceConfigurationRequest> mediaStreamSourceConfigurations() {
        return mediaStreamSourceConfigurations;
    }

    /**
     * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that
     * you set on your MediaConnect source or output represents the minimal potential latency of that connection. The
     * latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s
     * minimum latency.
     * 
     * @return The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this
     *         value that you set on your MediaConnect source or output represents the minimal potential latency of that
     *         connection. The latency of the stream is set to the highest number between the sender’s minimum latency
     *         and the receiver’s minimum latency.
     */
    public final Integer minLatency() {
        return minLatency;
    }

    /**
     * The name of the source.
     * 
     * @return The name of the source.
     */
    public final String name() {
        return name;
    }

    /**
     * The protocol that is used by the source.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol that is used by the source.
     * @see Protocol
     */
    public final Protocol protocol() {
        return Protocol.fromValue(protocol);
    }

    /**
     * The protocol that is used by the source.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol that is used by the source.
     * @see Protocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * The port that the flow uses to send outbound requests to initiate connection with the sender.
     * 
     * @return The port that the flow uses to send outbound requests to initiate connection with the sender.
     */
    public final Integer senderControlPort() {
        return senderControlPort;
    }

    /**
     * The IP address that the flow communicates with to initiate connection with the sender.
     * 
     * @return The IP address that the flow communicates with to initiate connection with the sender.
     */
    public final String senderIpAddress() {
        return senderIpAddress;
    }

    /**
     * Source IP or domain name for SRT-caller protocol.
     * 
     * @return Source IP or domain name for SRT-caller protocol.
     */
    public final String sourceListenerAddress() {
        return sourceListenerAddress;
    }

    /**
     * Source port for SRT-caller protocol.
     * 
     * @return Source port for SRT-caller protocol.
     */
    public final Integer sourceListenerPort() {
        return sourceListenerPort;
    }

    /**
     * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
     * 
     * @return The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
     */
    public final String streamId() {
        return streamId;
    }

    /**
     * The name of the VPC interface to use for this source.
     * 
     * @return The name of the VPC interface to use for this source.
     */
    public final String vpcInterfaceName() {
        return vpcInterfaceName;
    }

    /**
     * The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should
     * be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     * 
     * @return The range of IP addresses that should be allowed to contribute content to your source. These IP addresses
     *         should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     */
    public final String whitelistCidr() {
        return whitelistCidr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(decryption());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(entitlementArn());
        hashCode = 31 * hashCode + Objects.hashCode(ingestPort());
        hashCode = 31 * hashCode + Objects.hashCode(maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(maxLatency());
        hashCode = 31 * hashCode + Objects.hashCode(maxSyncBuffer());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasMediaStreamSourceConfigurations() ? mediaStreamSourceConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(minLatency());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(senderControlPort());
        hashCode = 31 * hashCode + Objects.hashCode(senderIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(sourceListenerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(sourceListenerPort());
        hashCode = 31 * hashCode + Objects.hashCode(streamId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcInterfaceName());
        hashCode = 31 * hashCode + Objects.hashCode(whitelistCidr());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetSourceRequest)) {
            return false;
        }
        SetSourceRequest other = (SetSourceRequest) obj;
        return Objects.equals(decryption(), other.decryption()) && Objects.equals(description(), other.description())
                && Objects.equals(entitlementArn(), other.entitlementArn()) && Objects.equals(ingestPort(), other.ingestPort())
                && Objects.equals(maxBitrate(), other.maxBitrate()) && Objects.equals(maxLatency(), other.maxLatency())
                && Objects.equals(maxSyncBuffer(), other.maxSyncBuffer())
                && hasMediaStreamSourceConfigurations() == other.hasMediaStreamSourceConfigurations()
                && Objects.equals(mediaStreamSourceConfigurations(), other.mediaStreamSourceConfigurations())
                && Objects.equals(minLatency(), other.minLatency()) && Objects.equals(name(), other.name())
                && Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(senderControlPort(), other.senderControlPort())
                && Objects.equals(senderIpAddress(), other.senderIpAddress())
                && Objects.equals(sourceListenerAddress(), other.sourceListenerAddress())
                && Objects.equals(sourceListenerPort(), other.sourceListenerPort())
                && Objects.equals(streamId(), other.streamId()) && Objects.equals(vpcInterfaceName(), other.vpcInterfaceName())
                && Objects.equals(whitelistCidr(), other.whitelistCidr());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("SetSourceRequest")
                .add("Decryption", decryption())
                .add("Description", description())
                .add("EntitlementArn", entitlementArn())
                .add("IngestPort", ingestPort())
                .add("MaxBitrate", maxBitrate())
                .add("MaxLatency", maxLatency())
                .add("MaxSyncBuffer", maxSyncBuffer())
                .add("MediaStreamSourceConfigurations",
                        hasMediaStreamSourceConfigurations() ? mediaStreamSourceConfigurations() : null)
                .add("MinLatency", minLatency()).add("Name", name()).add("Protocol", protocolAsString())
                .add("SenderControlPort", senderControlPort()).add("SenderIpAddress", senderIpAddress())
                .add("SourceListenerAddress", sourceListenerAddress()).add("SourceListenerPort", sourceListenerPort())
                .add("StreamId", streamId()).add("VpcInterfaceName", vpcInterfaceName()).add("WhitelistCidr", whitelistCidr())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Decryption":
            return Optional.ofNullable(clazz.cast(decryption()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EntitlementArn":
            return Optional.ofNullable(clazz.cast(entitlementArn()));
        case "IngestPort":
            return Optional.ofNullable(clazz.cast(ingestPort()));
        case "MaxBitrate":
            return Optional.ofNullable(clazz.cast(maxBitrate()));
        case "MaxLatency":
            return Optional.ofNullable(clazz.cast(maxLatency()));
        case "MaxSyncBuffer":
            return Optional.ofNullable(clazz.cast(maxSyncBuffer()));
        case "MediaStreamSourceConfigurations":
            return Optional.ofNullable(clazz.cast(mediaStreamSourceConfigurations()));
        case "MinLatency":
            return Optional.ofNullable(clazz.cast(minLatency()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "SenderControlPort":
            return Optional.ofNullable(clazz.cast(senderControlPort()));
        case "SenderIpAddress":
            return Optional.ofNullable(clazz.cast(senderIpAddress()));
        case "SourceListenerAddress":
            return Optional.ofNullable(clazz.cast(sourceListenerAddress()));
        case "SourceListenerPort":
            return Optional.ofNullable(clazz.cast(sourceListenerPort()));
        case "StreamId":
            return Optional.ofNullable(clazz.cast(streamId()));
        case "VpcInterfaceName":
            return Optional.ofNullable(clazz.cast(vpcInterfaceName()));
        case "WhitelistCidr":
            return Optional.ofNullable(clazz.cast(whitelistCidr()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetSourceRequest, T> g) {
        return obj -> g.apply((SetSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SetSourceRequest> {
        /**
         * The type of encryption that is used on the content ingested from this source.
         * 
         * @param decryption
         *        The type of encryption that is used on the content ingested from this source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decryption(Encryption decryption);

        /**
         * The type of encryption that is used on the content ingested from this source. This is a convenience method
         * that creates an instance of the {@link Encryption.Builder} avoiding the need to create one manually via
         * {@link Encryption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Encryption.Builder#build()} is called immediately and its result
         * is passed to {@link #decryption(Encryption)}.
         * 
         * @param decryption
         *        a consumer that will call methods on {@link Encryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #decryption(Encryption)
         */
        default Builder decryption(Consumer<Encryption.Builder> decryption) {
            return decryption(Encryption.builder().applyMutation(decryption).build());
        }

        /**
         * A description for the source. This value is not used or seen outside of the current AWS Elemental
         * MediaConnect account.
         * 
         * @param description
         *        A description for the source. This value is not used or seen outside of the current AWS Elemental
         *        MediaConnect account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow
         * originator, and the ARN is generated as part of the originator's flow.
         * 
         * @param entitlementArn
         *        The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the
         *        flow originator, and the ARN is generated as part of the originator's flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlementArn(String entitlementArn);

        /**
         * The port that the flow will be listening on for incoming content.
         * 
         * @param ingestPort
         *        The port that the flow will be listening on for incoming content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestPort(Integer ingestPort);

        /**
         * The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
         * 
         * @param maxBitrate
         *        The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBitrate(Integer maxBitrate);

        /**
         * The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based
         * streams.
         * 
         * @param maxLatency
         *        The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and
         *        Fujitsu-based streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxLatency(Integer maxLatency);

        /**
         * The size of the buffer (in milliseconds) to use to sync incoming source data.
         * 
         * @param maxSyncBuffer
         *        The size of the buffer (in milliseconds) to use to sync incoming source data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSyncBuffer(Integer maxSyncBuffer);

        /**
         * The media streams that are associated with the source, and the parameters for those associations.
         * 
         * @param mediaStreamSourceConfigurations
         *        The media streams that are associated with the source, and the parameters for those associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStreamSourceConfigurations(Collection<MediaStreamSourceConfigurationRequest> mediaStreamSourceConfigurations);

        /**
         * The media streams that are associated with the source, and the parameters for those associations.
         * 
         * @param mediaStreamSourceConfigurations
         *        The media streams that are associated with the source, and the parameters for those associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStreamSourceConfigurations(MediaStreamSourceConfigurationRequest... mediaStreamSourceConfigurations);

        /**
         * The media streams that are associated with the source, and the parameters for those associations. This is a
         * convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.MediaStreamSourceConfigurationRequest.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.mediaconnect.model.MediaStreamSourceConfigurationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.MediaStreamSourceConfigurationRequest.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #mediaStreamSourceConfigurations(List<MediaStreamSourceConfigurationRequest>)}.
         * 
         * @param mediaStreamSourceConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.MediaStreamSourceConfigurationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaStreamSourceConfigurations(java.util.Collection<MediaStreamSourceConfigurationRequest>)
         */
        Builder mediaStreamSourceConfigurations(
                Consumer<MediaStreamSourceConfigurationRequest.Builder>... mediaStreamSourceConfigurations);

        /**
         * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value
         * that you set on your MediaConnect source or output represents the minimal potential latency of that
         * connection. The latency of the stream is set to the highest number between the sender’s minimum latency and
         * the receiver’s minimum latency.
         * 
         * @param minLatency
         *        The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this
         *        value that you set on your MediaConnect source or output represents the minimal potential latency of
         *        that connection. The latency of the stream is set to the highest number between the sender’s minimum
         *        latency and the receiver’s minimum latency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minLatency(Integer minLatency);

        /**
         * The name of the source.
         * 
         * @param name
         *        The name of the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The protocol that is used by the source.
         * 
         * @param protocol
         *        The protocol that is used by the source.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * The protocol that is used by the source.
         * 
         * @param protocol
         *        The protocol that is used by the source.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);

        /**
         * The port that the flow uses to send outbound requests to initiate connection with the sender.
         * 
         * @param senderControlPort
         *        The port that the flow uses to send outbound requests to initiate connection with the sender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderControlPort(Integer senderControlPort);

        /**
         * The IP address that the flow communicates with to initiate connection with the sender.
         * 
         * @param senderIpAddress
         *        The IP address that the flow communicates with to initiate connection with the sender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderIpAddress(String senderIpAddress);

        /**
         * Source IP or domain name for SRT-caller protocol.
         * 
         * @param sourceListenerAddress
         *        Source IP or domain name for SRT-caller protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceListenerAddress(String sourceListenerAddress);

        /**
         * Source port for SRT-caller protocol.
         * 
         * @param sourceListenerPort
         *        Source port for SRT-caller protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceListenerPort(Integer sourceListenerPort);

        /**
         * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
         * 
         * @param streamId
         *        The stream ID that you want to use for this transport. This parameter applies only to Zixi-based
         *        streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamId(String streamId);

        /**
         * The name of the VPC interface to use for this source.
         * 
         * @param vpcInterfaceName
         *        The name of the VPC interface to use for this source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcInterfaceName(String vpcInterfaceName);

        /**
         * The range of IP addresses that should be allowed to contribute content to your source. These IP addresses
         * should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         * 
         * @param whitelistCidr
         *        The range of IP addresses that should be allowed to contribute content to your source. These IP
         *        addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example,
         *        10.0.0.0/16.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whitelistCidr(String whitelistCidr);
    }

    static final class BuilderImpl implements Builder {
        private Encryption decryption;

        private String description;

        private String entitlementArn;

        private Integer ingestPort;

        private Integer maxBitrate;

        private Integer maxLatency;

        private Integer maxSyncBuffer;

        private List<MediaStreamSourceConfigurationRequest> mediaStreamSourceConfigurations = DefaultSdkAutoConstructList
                .getInstance();

        private Integer minLatency;

        private String name;

        private String protocol;

        private Integer senderControlPort;

        private String senderIpAddress;

        private String sourceListenerAddress;

        private Integer sourceListenerPort;

        private String streamId;

        private String vpcInterfaceName;

        private String whitelistCidr;

        private BuilderImpl() {
        }

        private BuilderImpl(SetSourceRequest model) {
            decryption(model.decryption);
            description(model.description);
            entitlementArn(model.entitlementArn);
            ingestPort(model.ingestPort);
            maxBitrate(model.maxBitrate);
            maxLatency(model.maxLatency);
            maxSyncBuffer(model.maxSyncBuffer);
            mediaStreamSourceConfigurations(model.mediaStreamSourceConfigurations);
            minLatency(model.minLatency);
            name(model.name);
            protocol(model.protocol);
            senderControlPort(model.senderControlPort);
            senderIpAddress(model.senderIpAddress);
            sourceListenerAddress(model.sourceListenerAddress);
            sourceListenerPort(model.sourceListenerPort);
            streamId(model.streamId);
            vpcInterfaceName(model.vpcInterfaceName);
            whitelistCidr(model.whitelistCidr);
        }

        public final Encryption.Builder getDecryption() {
            return decryption != null ? decryption.toBuilder() : null;
        }

        public final void setDecryption(Encryption.BuilderImpl decryption) {
            this.decryption = decryption != null ? decryption.build() : null;
        }

        @Override
        public final Builder decryption(Encryption decryption) {
            this.decryption = decryption;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEntitlementArn() {
            return entitlementArn;
        }

        public final void setEntitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
        }

        @Override
        public final Builder entitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
            return this;
        }

        public final Integer getIngestPort() {
            return ingestPort;
        }

        public final void setIngestPort(Integer ingestPort) {
            this.ingestPort = ingestPort;
        }

        @Override
        public final Builder ingestPort(Integer ingestPort) {
            this.ingestPort = ingestPort;
            return this;
        }

        public final Integer getMaxBitrate() {
            return maxBitrate;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final Integer getMaxLatency() {
            return maxLatency;
        }

        public final void setMaxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
        }

        @Override
        public final Builder maxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
            return this;
        }

        public final Integer getMaxSyncBuffer() {
            return maxSyncBuffer;
        }

        public final void setMaxSyncBuffer(Integer maxSyncBuffer) {
            this.maxSyncBuffer = maxSyncBuffer;
        }

        @Override
        public final Builder maxSyncBuffer(Integer maxSyncBuffer) {
            this.maxSyncBuffer = maxSyncBuffer;
            return this;
        }

        public final List<MediaStreamSourceConfigurationRequest.Builder> getMediaStreamSourceConfigurations() {
            List<MediaStreamSourceConfigurationRequest.Builder> result = ___listOfMediaStreamSourceConfigurationRequestCopier
                    .copyToBuilder(this.mediaStreamSourceConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaStreamSourceConfigurations(
                Collection<MediaStreamSourceConfigurationRequest.BuilderImpl> mediaStreamSourceConfigurations) {
            this.mediaStreamSourceConfigurations = ___listOfMediaStreamSourceConfigurationRequestCopier
                    .copyFromBuilder(mediaStreamSourceConfigurations);
        }

        @Override
        public final Builder mediaStreamSourceConfigurations(
                Collection<MediaStreamSourceConfigurationRequest> mediaStreamSourceConfigurations) {
            this.mediaStreamSourceConfigurations = ___listOfMediaStreamSourceConfigurationRequestCopier
                    .copy(mediaStreamSourceConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaStreamSourceConfigurations(
                MediaStreamSourceConfigurationRequest... mediaStreamSourceConfigurations) {
            mediaStreamSourceConfigurations(Arrays.asList(mediaStreamSourceConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaStreamSourceConfigurations(
                Consumer<MediaStreamSourceConfigurationRequest.Builder>... mediaStreamSourceConfigurations) {
            mediaStreamSourceConfigurations(Stream.of(mediaStreamSourceConfigurations)
                    .map(c -> MediaStreamSourceConfigurationRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getMinLatency() {
            return minLatency;
        }

        public final void setMinLatency(Integer minLatency) {
            this.minLatency = minLatency;
        }

        @Override
        public final Builder minLatency(Integer minLatency) {
            this.minLatency = minLatency;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Integer getSenderControlPort() {
            return senderControlPort;
        }

        public final void setSenderControlPort(Integer senderControlPort) {
            this.senderControlPort = senderControlPort;
        }

        @Override
        public final Builder senderControlPort(Integer senderControlPort) {
            this.senderControlPort = senderControlPort;
            return this;
        }

        public final String getSenderIpAddress() {
            return senderIpAddress;
        }

        public final void setSenderIpAddress(String senderIpAddress) {
            this.senderIpAddress = senderIpAddress;
        }

        @Override
        public final Builder senderIpAddress(String senderIpAddress) {
            this.senderIpAddress = senderIpAddress;
            return this;
        }

        public final String getSourceListenerAddress() {
            return sourceListenerAddress;
        }

        public final void setSourceListenerAddress(String sourceListenerAddress) {
            this.sourceListenerAddress = sourceListenerAddress;
        }

        @Override
        public final Builder sourceListenerAddress(String sourceListenerAddress) {
            this.sourceListenerAddress = sourceListenerAddress;
            return this;
        }

        public final Integer getSourceListenerPort() {
            return sourceListenerPort;
        }

        public final void setSourceListenerPort(Integer sourceListenerPort) {
            this.sourceListenerPort = sourceListenerPort;
        }

        @Override
        public final Builder sourceListenerPort(Integer sourceListenerPort) {
            this.sourceListenerPort = sourceListenerPort;
            return this;
        }

        public final String getStreamId() {
            return streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final String getVpcInterfaceName() {
            return vpcInterfaceName;
        }

        public final void setVpcInterfaceName(String vpcInterfaceName) {
            this.vpcInterfaceName = vpcInterfaceName;
        }

        @Override
        public final Builder vpcInterfaceName(String vpcInterfaceName) {
            this.vpcInterfaceName = vpcInterfaceName;
            return this;
        }

        public final String getWhitelistCidr() {
            return whitelistCidr;
        }

        public final void setWhitelistCidr(String whitelistCidr) {
            this.whitelistCidr = whitelistCidr;
        }

        @Override
        public final Builder whitelistCidr(String whitelistCidr) {
            this.whitelistCidr = whitelistCidr;
            return this;
        }

        @Override
        public SetSourceRequest build() {
            return new SetSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
