/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.Fmtp;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaStreamAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaStreamAttributes> {
    private static final SdkField<Fmtp> FMTP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Fmtp").getter(MediaStreamAttributes.getter(MediaStreamAttributes::fmtp)).setter(MediaStreamAttributes.setter(Builder::fmtp)).constructor(Fmtp::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fmtp").build()}).build();
    private static final SdkField<String> LANG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Lang").getter(MediaStreamAttributes.getter(MediaStreamAttributes::lang)).setter(MediaStreamAttributes.setter(Builder::lang)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lang").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FMTP_FIELD, LANG_FIELD));
    private static final long serialVersionUID = 1L;
    private final Fmtp fmtp;
    private final String lang;

    private MediaStreamAttributes(BuilderImpl builder) {
        this.fmtp = builder.fmtp;
        this.lang = builder.lang;
    }

    public final Fmtp fmtp() {
        return this.fmtp;
    }

    public final String lang() {
        return this.lang;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fmtp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lang());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaStreamAttributes)) {
            return false;
        }
        MediaStreamAttributes other = (MediaStreamAttributes)obj;
        return Objects.equals(this.fmtp(), other.fmtp()) && Objects.equals(this.lang(), other.lang());
    }

    public final String toString() {
        return ToString.builder((String)"MediaStreamAttributes").add("Fmtp", (Object)this.fmtp()).add("Lang", (Object)this.lang()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Fmtp": {
                return Optional.ofNullable(clazz.cast(this.fmtp()));
            }
            case "Lang": {
                return Optional.ofNullable(clazz.cast(this.lang()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MediaStreamAttributes, T> g) {
        return obj -> g.apply((MediaStreamAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Fmtp fmtp;
        private String lang;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaStreamAttributes model) {
            this.fmtp(model.fmtp);
            this.lang(model.lang);
        }

        public final Fmtp.Builder getFmtp() {
            return this.fmtp != null ? this.fmtp.toBuilder() : null;
        }

        public final void setFmtp(Fmtp.BuilderImpl fmtp) {
            this.fmtp = fmtp != null ? fmtp.build() : null;
        }

        @Override
        public final Builder fmtp(Fmtp fmtp) {
            this.fmtp = fmtp;
            return this;
        }

        public final String getLang() {
            return this.lang;
        }

        public final void setLang(String lang) {
            this.lang = lang;
        }

        @Override
        public final Builder lang(String lang) {
            this.lang = lang;
            return this;
        }

        public MediaStreamAttributes build() {
            return new MediaStreamAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaStreamAttributes> {
        public Builder fmtp(Fmtp var1);

        default public Builder fmtp(Consumer<Fmtp.Builder> fmtp) {
            return this.fmtp((Fmtp)((Fmtp.Builder)Fmtp.builder().applyMutation(fmtp)).build());
        }

        public Builder lang(String var1);
    }
}

