/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The settings for an instance in a gateway.
 */
@Generated("software.amazon.awssdk:codegen")
public final class GatewayInstance implements SdkPojo, Serializable, ToCopyableBuilder<GatewayInstance.Builder, GatewayInstance> {
    private static final SdkField<String> BRIDGE_PLACEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BridgePlacement").getter(getter(GatewayInstance::bridgePlacementAsString))
            .setter(setter(Builder::bridgePlacement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgePlacement").build()).build();

    private static final SdkField<String> CONNECTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionStatus").getter(getter(GatewayInstance::connectionStatusAsString))
            .setter(setter(Builder::connectionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionStatus").build()).build();

    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayArn").getter(getter(GatewayInstance::gatewayArn)).setter(setter(Builder::gatewayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayArn").build()).build();

    private static final SdkField<String> GATEWAY_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayInstanceArn").getter(getter(GatewayInstance::gatewayInstanceArn))
            .setter(setter(Builder::gatewayInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayInstanceArn").build())
            .build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(GatewayInstance::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()).build();

    private static final SdkField<List<MessageDetail>> INSTANCE_MESSAGES_FIELD = SdkField
            .<List<MessageDetail>> builder(MarshallingType.LIST)
            .memberName("InstanceMessages")
            .getter(getter(GatewayInstance::instanceMessages))
            .setter(setter(Builder::instanceMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceMessages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INSTANCE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceState").getter(getter(GatewayInstance::instanceStateAsString))
            .setter(setter(Builder::instanceState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceState").build()).build();

    private static final SdkField<Integer> RUNNING_BRIDGE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RunningBridgeCount").getter(getter(GatewayInstance::runningBridgeCount))
            .setter(setter(Builder::runningBridgeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runningBridgeCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIDGE_PLACEMENT_FIELD,
            CONNECTION_STATUS_FIELD, GATEWAY_ARN_FIELD, GATEWAY_INSTANCE_ARN_FIELD, INSTANCE_ID_FIELD, INSTANCE_MESSAGES_FIELD,
            INSTANCE_STATE_FIELD, RUNNING_BRIDGE_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bridgePlacement;

    private final String connectionStatus;

    private final String gatewayArn;

    private final String gatewayInstanceArn;

    private final String instanceId;

    private final List<MessageDetail> instanceMessages;

    private final String instanceState;

    private final Integer runningBridgeCount;

    private GatewayInstance(BuilderImpl builder) {
        this.bridgePlacement = builder.bridgePlacement;
        this.connectionStatus = builder.connectionStatus;
        this.gatewayArn = builder.gatewayArn;
        this.gatewayInstanceArn = builder.gatewayInstanceArn;
        this.instanceId = builder.instanceId;
        this.instanceMessages = builder.instanceMessages;
        this.instanceState = builder.instanceState;
        this.runningBridgeCount = builder.runningBridgeCount;
    }

    /**
     * The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or AVAILABLE. If
     * it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new bridges can be added to
     * this instance.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bridgePlacement}
     * will return {@link BridgePlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #bridgePlacementAsString}.
     * </p>
     * 
     * @return The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or
     *         AVAILABLE. If it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new
     *         bridges can be added to this instance.
     * @see BridgePlacement
     */
    public final BridgePlacement bridgePlacement() {
        return BridgePlacement.fromValue(bridgePlacement);
    }

    /**
     * The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or AVAILABLE. If
     * it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new bridges can be added to
     * this instance.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bridgePlacement}
     * will return {@link BridgePlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #bridgePlacementAsString}.
     * </p>
     * 
     * @return The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or
     *         AVAILABLE. If it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new
     *         bridges can be added to this instance.
     * @see BridgePlacement
     */
    public final String bridgePlacementAsString() {
        return bridgePlacement;
    }

    /**
     * The connection state of the instance.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionStatus}
     * will return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionStatusAsString}.
     * </p>
     * 
     * @return The connection state of the instance.
     * @see ConnectionStatus
     */
    public final ConnectionStatus connectionStatus() {
        return ConnectionStatus.fromValue(connectionStatus);
    }

    /**
     * The connection state of the instance.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionStatus}
     * will return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionStatusAsString}.
     * </p>
     * 
     * @return The connection state of the instance.
     * @see ConnectionStatus
     */
    public final String connectionStatusAsString() {
        return connectionStatus;
    }

    /**
     * The Amazon Resource Name (ARN) of the instance.
     * 
     * @return The Amazon Resource Name (ARN) of the instance.
     */
    public final String gatewayArn() {
        return gatewayArn;
    }

    /**
     * The Amazon Resource Name (ARN) of the gateway.
     * 
     * @return The Amazon Resource Name (ARN) of the gateway.
     */
    public final String gatewayInstanceArn() {
        return gatewayInstanceArn;
    }

    /**
     * The managed instance ID generated by the SSM install. This will begin with "mi-".
     * 
     * @return The managed instance ID generated by the SSM install. This will begin with "mi-".
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceMessages property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceMessages() {
        return instanceMessages != null && !(instanceMessages instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the InstanceMessages property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceMessages} method.
     * </p>
     * 
     * @return The value of the InstanceMessages property for this object.
     */
    public final List<MessageDetail> instanceMessages() {
        return instanceMessages;
    }

    /**
     * The status of the instance.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceState}
     * will return {@link InstanceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceStateAsString}.
     * </p>
     * 
     * @return The status of the instance.
     * @see InstanceState
     */
    public final InstanceState instanceState() {
        return InstanceState.fromValue(instanceState);
    }

    /**
     * The status of the instance.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceState}
     * will return {@link InstanceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceStateAsString}.
     * </p>
     * 
     * @return The status of the instance.
     * @see InstanceState
     */
    public final String instanceStateAsString() {
        return instanceState;
    }

    /**
     * The running bridge count.
     * 
     * @return The running bridge count.
     */
    public final Integer runningBridgeCount() {
        return runningBridgeCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bridgePlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceMessages() ? instanceMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(runningBridgeCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatewayInstance)) {
            return false;
        }
        GatewayInstance other = (GatewayInstance) obj;
        return Objects.equals(bridgePlacementAsString(), other.bridgePlacementAsString())
                && Objects.equals(connectionStatusAsString(), other.connectionStatusAsString())
                && Objects.equals(gatewayArn(), other.gatewayArn())
                && Objects.equals(gatewayInstanceArn(), other.gatewayInstanceArn())
                && Objects.equals(instanceId(), other.instanceId()) && hasInstanceMessages() == other.hasInstanceMessages()
                && Objects.equals(instanceMessages(), other.instanceMessages())
                && Objects.equals(instanceStateAsString(), other.instanceStateAsString())
                && Objects.equals(runningBridgeCount(), other.runningBridgeCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GatewayInstance").add("BridgePlacement", bridgePlacementAsString())
                .add("ConnectionStatus", connectionStatusAsString()).add("GatewayArn", gatewayArn())
                .add("GatewayInstanceArn", gatewayInstanceArn()).add("InstanceId", instanceId())
                .add("InstanceMessages", hasInstanceMessages() ? instanceMessages() : null)
                .add("InstanceState", instanceStateAsString()).add("RunningBridgeCount", runningBridgeCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BridgePlacement":
            return Optional.ofNullable(clazz.cast(bridgePlacementAsString()));
        case "ConnectionStatus":
            return Optional.ofNullable(clazz.cast(connectionStatusAsString()));
        case "GatewayArn":
            return Optional.ofNullable(clazz.cast(gatewayArn()));
        case "GatewayInstanceArn":
            return Optional.ofNullable(clazz.cast(gatewayInstanceArn()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceMessages":
            return Optional.ofNullable(clazz.cast(instanceMessages()));
        case "InstanceState":
            return Optional.ofNullable(clazz.cast(instanceStateAsString()));
        case "RunningBridgeCount":
            return Optional.ofNullable(clazz.cast(runningBridgeCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GatewayInstance, T> g) {
        return obj -> g.apply((GatewayInstance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GatewayInstance> {
        /**
         * The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or
         * AVAILABLE. If it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new bridges
         * can be added to this instance.
         * 
         * @param bridgePlacement
         *        The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or
         *        AVAILABLE. If it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new
         *        bridges can be added to this instance.
         * @see BridgePlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BridgePlacement
         */
        Builder bridgePlacement(String bridgePlacement);

        /**
         * The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or
         * AVAILABLE. If it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new bridges
         * can be added to this instance.
         * 
         * @param bridgePlacement
         *        The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or
         *        AVAILABLE. If it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new
         *        bridges can be added to this instance.
         * @see BridgePlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BridgePlacement
         */
        Builder bridgePlacement(BridgePlacement bridgePlacement);

        /**
         * The connection state of the instance.
         * 
         * @param connectionStatus
         *        The connection state of the instance.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder connectionStatus(String connectionStatus);

        /**
         * The connection state of the instance.
         * 
         * @param connectionStatus
         *        The connection state of the instance.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder connectionStatus(ConnectionStatus connectionStatus);

        /**
         * The Amazon Resource Name (ARN) of the instance.
         * 
         * @param gatewayArn
         *        The Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayArn(String gatewayArn);

        /**
         * The Amazon Resource Name (ARN) of the gateway.
         * 
         * @param gatewayInstanceArn
         *        The Amazon Resource Name (ARN) of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayInstanceArn(String gatewayInstanceArn);

        /**
         * The managed instance ID generated by the SSM install. This will begin with "mi-".
         * 
         * @param instanceId
         *        The managed instance ID generated by the SSM install. This will begin with "mi-".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * Sets the value of the InstanceMessages property for this object.
         *
         * @param instanceMessages
         *        The new value for the InstanceMessages property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMessages(Collection<MessageDetail> instanceMessages);

        /**
         * Sets the value of the InstanceMessages property for this object.
         *
         * @param instanceMessages
         *        The new value for the InstanceMessages property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMessages(MessageDetail... instanceMessages);

        /**
         * Sets the value of the InstanceMessages property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.MessageDetail.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mediaconnect.model.MessageDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.MessageDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceMessages(List<MessageDetail>)}.
         * 
         * @param instanceMessages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.MessageDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceMessages(java.util.Collection<MessageDetail>)
         */
        Builder instanceMessages(Consumer<MessageDetail.Builder>... instanceMessages);

        /**
         * The status of the instance.
         * 
         * @param instanceState
         *        The status of the instance.
         * @see InstanceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceState
         */
        Builder instanceState(String instanceState);

        /**
         * The status of the instance.
         * 
         * @param instanceState
         *        The status of the instance.
         * @see InstanceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceState
         */
        Builder instanceState(InstanceState instanceState);

        /**
         * The running bridge count.
         * 
         * @param runningBridgeCount
         *        The running bridge count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runningBridgeCount(Integer runningBridgeCount);
    }

    static final class BuilderImpl implements Builder {
        private String bridgePlacement;

        private String connectionStatus;

        private String gatewayArn;

        private String gatewayInstanceArn;

        private String instanceId;

        private List<MessageDetail> instanceMessages = DefaultSdkAutoConstructList.getInstance();

        private String instanceState;

        private Integer runningBridgeCount;

        private BuilderImpl() {
        }

        private BuilderImpl(GatewayInstance model) {
            bridgePlacement(model.bridgePlacement);
            connectionStatus(model.connectionStatus);
            gatewayArn(model.gatewayArn);
            gatewayInstanceArn(model.gatewayInstanceArn);
            instanceId(model.instanceId);
            instanceMessages(model.instanceMessages);
            instanceState(model.instanceState);
            runningBridgeCount(model.runningBridgeCount);
        }

        public final String getBridgePlacement() {
            return bridgePlacement;
        }

        public final void setBridgePlacement(String bridgePlacement) {
            this.bridgePlacement = bridgePlacement;
        }

        @Override
        public final Builder bridgePlacement(String bridgePlacement) {
            this.bridgePlacement = bridgePlacement;
            return this;
        }

        @Override
        public final Builder bridgePlacement(BridgePlacement bridgePlacement) {
            this.bridgePlacement(bridgePlacement == null ? null : bridgePlacement.toString());
            return this;
        }

        public final String getConnectionStatus() {
            return connectionStatus;
        }

        public final void setConnectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
        }

        @Override
        public final Builder connectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        @Override
        public final Builder connectionStatus(ConnectionStatus connectionStatus) {
            this.connectionStatus(connectionStatus == null ? null : connectionStatus.toString());
            return this;
        }

        public final String getGatewayArn() {
            return gatewayArn;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        @Override
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        public final String getGatewayInstanceArn() {
            return gatewayInstanceArn;
        }

        public final void setGatewayInstanceArn(String gatewayInstanceArn) {
            this.gatewayInstanceArn = gatewayInstanceArn;
        }

        @Override
        public final Builder gatewayInstanceArn(String gatewayInstanceArn) {
            this.gatewayInstanceArn = gatewayInstanceArn;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final List<MessageDetail.Builder> getInstanceMessages() {
            List<MessageDetail.Builder> result = ___listOfMessageDetailCopier.copyToBuilder(this.instanceMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceMessages(Collection<MessageDetail.BuilderImpl> instanceMessages) {
            this.instanceMessages = ___listOfMessageDetailCopier.copyFromBuilder(instanceMessages);
        }

        @Override
        public final Builder instanceMessages(Collection<MessageDetail> instanceMessages) {
            this.instanceMessages = ___listOfMessageDetailCopier.copy(instanceMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceMessages(MessageDetail... instanceMessages) {
            instanceMessages(Arrays.asList(instanceMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceMessages(Consumer<MessageDetail.Builder>... instanceMessages) {
            instanceMessages(Stream.of(instanceMessages).map(c -> MessageDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getInstanceState() {
            return instanceState;
        }

        public final void setInstanceState(String instanceState) {
            this.instanceState = instanceState;
        }

        @Override
        public final Builder instanceState(String instanceState) {
            this.instanceState = instanceState;
            return this;
        }

        @Override
        public final Builder instanceState(InstanceState instanceState) {
            this.instanceState(instanceState == null ? null : instanceState.toString());
            return this;
        }

        public final Integer getRunningBridgeCount() {
            return runningBridgeCount;
        }

        public final void setRunningBridgeCount(Integer runningBridgeCount) {
            this.runningBridgeCount = runningBridgeCount;
        }

        @Override
        public final Builder runningBridgeCount(Integer runningBridgeCount) {
            this.runningBridgeCount = runningBridgeCount;
            return this;
        }

        @Override
        public GatewayInstance build() {
            return new GatewayInstance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
