/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediaconnect.MediaConnectClient;
import software.amazon.awssdk.services.mediaconnect.model.ListBridgesRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListBridgesResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListedBridge;

public class ListBridgesIterable
implements SdkIterable<ListBridgesResponse> {
    private final MediaConnectClient client;
    private final ListBridgesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBridgesIterable(MediaConnectClient client, ListBridgesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListBridgesResponseFetcher();
    }

    public Iterator<ListBridgesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListedBridge> bridges() {
        Function<ListBridgesResponse, Iterator> getIterator = response -> {
            if (response != null && response.bridges() != null) {
                return response.bridges().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBridgesResponseFetcher
    implements SyncPageFetcher<ListBridgesResponse> {
        private ListBridgesResponseFetcher() {
        }

        public boolean hasNextPage(ListBridgesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBridgesResponse nextPage(ListBridgesResponse previousPage) {
            if (previousPage == null) {
                return ListBridgesIterable.this.client.listBridges(ListBridgesIterable.this.firstRequest);
            }
            return ListBridgesIterable.this.client.listBridges((ListBridgesRequest)((Object)ListBridgesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

