/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediaconnect.MediaConnectClient;
import software.amazon.awssdk.services.mediaconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediaconnect.model.ListReservationsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListReservationsResponse;
import software.amazon.awssdk.services.mediaconnect.model.Reservation;

public class ListReservationsIterable
implements SdkIterable<ListReservationsResponse> {
    private final MediaConnectClient client;
    private final ListReservationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReservationsIterable(MediaConnectClient client, ListReservationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListReservationsResponseFetcher();
    }

    public Iterator<ListReservationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Reservation> reservations() {
        Function<ListReservationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservations() != null) {
                return response.reservations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListReservationsResponseFetcher
    implements SyncPageFetcher<ListReservationsResponse> {
        private ListReservationsResponseFetcher() {
        }

        public boolean hasNextPage(ListReservationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReservationsResponse nextPage(ListReservationsResponse previousPage) {
            if (previousPage == null) {
                return ListReservationsIterable.this.client.listReservations(ListReservationsIterable.this.firstRequest);
            }
            return ListReservationsIterable.this.client.listReservations((ListReservationsRequest)((Object)ListReservationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

