/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediaconnect.MediaConnectClient;
import software.amazon.awssdk.services.mediaconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediaconnect.model.ListOfferingsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListOfferingsResponse;
import software.amazon.awssdk.services.mediaconnect.model.Offering;

public class ListOfferingsIterable
implements SdkIterable<ListOfferingsResponse> {
    private final MediaConnectClient client;
    private final ListOfferingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOfferingsIterable(MediaConnectClient client, ListOfferingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOfferingsResponseFetcher();
    }

    public Iterator<ListOfferingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Offering> offerings() {
        Function<ListOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.offerings() != null) {
                return response.offerings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOfferingsResponseFetcher
    implements SyncPageFetcher<ListOfferingsResponse> {
        private ListOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(ListOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOfferingsResponse nextPage(ListOfferingsResponse previousPage) {
            if (previousPage == null) {
                return ListOfferingsIterable.this.client.listOfferings(ListOfferingsIterable.this.firstRequest);
            }
            return ListOfferingsIterable.this.client.listOfferings((ListOfferingsRequest)((Object)ListOfferingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

