/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFlowSourceMetadataResponse extends MediaConnectResponse implements
        ToCopyableBuilder<DescribeFlowSourceMetadataResponse.Builder, DescribeFlowSourceMetadataResponse> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(DescribeFlowSourceMetadataResponse::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final SdkField<List<MessageDetail>> MESSAGES_FIELD = SdkField
            .<List<MessageDetail>> builder(MarshallingType.LIST)
            .memberName("Messages")
            .getter(getter(DescribeFlowSourceMetadataResponse::messages))
            .setter(setter(Builder::messages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp")
            .getter(getter(DescribeFlowSourceMetadataResponse::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<TransportMediaInfo> TRANSPORT_MEDIA_INFO_FIELD = SdkField
            .<TransportMediaInfo> builder(MarshallingType.SDK_POJO).memberName("TransportMediaInfo")
            .getter(getter(DescribeFlowSourceMetadataResponse::transportMediaInfo)).setter(setter(Builder::transportMediaInfo))
            .constructor(TransportMediaInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transportMediaInfo").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD,
            MESSAGES_FIELD, TIMESTAMP_FIELD, TRANSPORT_MEDIA_INFO_FIELD));

    private final String flowArn;

    private final List<MessageDetail> messages;

    private final Instant timestamp;

    private final TransportMediaInfo transportMediaInfo;

    private DescribeFlowSourceMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.messages = builder.messages;
        this.timestamp = builder.timestamp;
        this.transportMediaInfo = builder.transportMediaInfo;
    }

    /**
     * The ARN of the flow that DescribeFlowSourceMetadata was performed on.
     * 
     * @return The ARN of the flow that DescribeFlowSourceMetadata was performed on.
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Messages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMessages() {
        return messages != null && !(messages instanceof SdkAutoConstructList);
    }

    /**
     * Provides a status code and message regarding issues found with the flow source metadata.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessages} method.
     * </p>
     * 
     * @return Provides a status code and message regarding issues found with the flow source metadata.
     */
    public final List<MessageDetail> messages() {
        return messages;
    }

    /**
     * The timestamp of the most recent change in metadata for this flow’s source.
     * 
     * @return The timestamp of the most recent change in metadata for this flow’s source.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * Returns the value of the TransportMediaInfo property for this object.
     * 
     * @return The value of the TransportMediaInfo property for this object.
     */
    public final TransportMediaInfo transportMediaInfo() {
        return transportMediaInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasMessages() ? messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(transportMediaInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFlowSourceMetadataResponse)) {
            return false;
        }
        DescribeFlowSourceMetadataResponse other = (DescribeFlowSourceMetadataResponse) obj;
        return Objects.equals(flowArn(), other.flowArn()) && hasMessages() == other.hasMessages()
                && Objects.equals(messages(), other.messages()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(transportMediaInfo(), other.transportMediaInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFlowSourceMetadataResponse").add("FlowArn", flowArn())
                .add("Messages", hasMessages() ? messages() : null).add("Timestamp", timestamp())
                .add("TransportMediaInfo", transportMediaInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "Messages":
            return Optional.ofNullable(clazz.cast(messages()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "TransportMediaInfo":
            return Optional.ofNullable(clazz.cast(transportMediaInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFlowSourceMetadataResponse, T> g) {
        return obj -> g.apply((DescribeFlowSourceMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeFlowSourceMetadataResponse> {
        /**
         * The ARN of the flow that DescribeFlowSourceMetadata was performed on.
         * 
         * @param flowArn
         *        The ARN of the flow that DescribeFlowSourceMetadata was performed on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * Provides a status code and message regarding issues found with the flow source metadata.
         * 
         * @param messages
         *        Provides a status code and message regarding issues found with the flow source metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Collection<MessageDetail> messages);

        /**
         * Provides a status code and message regarding issues found with the flow source metadata.
         * 
         * @param messages
         *        Provides a status code and message regarding issues found with the flow source metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(MessageDetail... messages);

        /**
         * Provides a status code and message regarding issues found with the flow source metadata. This is a
         * convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.MessageDetail.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mediaconnect.model.MessageDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.MessageDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #messages(List<MessageDetail>)}.
         * 
         * @param messages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.MessageDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messages(java.util.Collection<MessageDetail>)
         */
        Builder messages(Consumer<MessageDetail.Builder>... messages);

        /**
         * The timestamp of the most recent change in metadata for this flow’s source.
         * 
         * @param timestamp
         *        The timestamp of the most recent change in metadata for this flow’s source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * Sets the value of the TransportMediaInfo property for this object.
         *
         * @param transportMediaInfo
         *        The new value for the TransportMediaInfo property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transportMediaInfo(TransportMediaInfo transportMediaInfo);

        /**
         * Sets the value of the TransportMediaInfo property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TransportMediaInfo.Builder} avoiding the
         * need to create one manually via {@link TransportMediaInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransportMediaInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #transportMediaInfo(TransportMediaInfo)}.
         * 
         * @param transportMediaInfo
         *        a consumer that will call methods on {@link TransportMediaInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transportMediaInfo(TransportMediaInfo)
         */
        default Builder transportMediaInfo(Consumer<TransportMediaInfo.Builder> transportMediaInfo) {
            return transportMediaInfo(TransportMediaInfo.builder().applyMutation(transportMediaInfo).build());
        }
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private String flowArn;

        private List<MessageDetail> messages = DefaultSdkAutoConstructList.getInstance();

        private Instant timestamp;

        private TransportMediaInfo transportMediaInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFlowSourceMetadataResponse model) {
            super(model);
            flowArn(model.flowArn);
            messages(model.messages);
            timestamp(model.timestamp);
            transportMediaInfo(model.transportMediaInfo);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final List<MessageDetail.Builder> getMessages() {
            List<MessageDetail.Builder> result = ___listOfMessageDetailCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<MessageDetail.BuilderImpl> messages) {
            this.messages = ___listOfMessageDetailCopier.copyFromBuilder(messages);
        }

        @Override
        public final Builder messages(Collection<MessageDetail> messages) {
            this.messages = ___listOfMessageDetailCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(MessageDetail... messages) {
            messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<MessageDetail.Builder>... messages) {
            messages(Stream.of(messages).map(c -> MessageDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final TransportMediaInfo.Builder getTransportMediaInfo() {
            return transportMediaInfo != null ? transportMediaInfo.toBuilder() : null;
        }

        public final void setTransportMediaInfo(TransportMediaInfo.BuilderImpl transportMediaInfo) {
            this.transportMediaInfo = transportMediaInfo != null ? transportMediaInfo.build() : null;
        }

        @Override
        public final Builder transportMediaInfo(TransportMediaInfo transportMediaInfo) {
            this.transportMediaInfo = transportMediaInfo;
            return this;
        }

        @Override
        public DescribeFlowSourceMetadataResponse build() {
            return new DescribeFlowSourceMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
