/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The details of the thumbnail, including thumbnail base64 string, timecode and the time when thumbnail was generated.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThumbnailDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ThumbnailDetails.Builder, ThumbnailDetails> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(ThumbnailDetails::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final SdkField<String> THUMBNAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Thumbnail").getter(getter(ThumbnailDetails::thumbnail)).setter(setter(Builder::thumbnail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnail").build()).build();

    private static final SdkField<List<MessageDetail>> THUMBNAIL_MESSAGES_FIELD = SdkField
            .<List<MessageDetail>> builder(MarshallingType.LIST)
            .memberName("ThumbnailMessages")
            .getter(getter(ThumbnailDetails::thumbnailMessages))
            .setter(setter(Builder::thumbnailMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailMessages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TIMECODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timecode").getter(getter(ThumbnailDetails::timecode)).setter(setter(Builder::timecode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecode").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp")
            .getter(getter(ThumbnailDetails::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD,
            THUMBNAIL_FIELD, THUMBNAIL_MESSAGES_FIELD, TIMECODE_FIELD, TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String flowArn;

    private final String thumbnail;

    private final List<MessageDetail> thumbnailMessages;

    private final String timecode;

    private final Instant timestamp;

    private ThumbnailDetails(BuilderImpl builder) {
        this.flowArn = builder.flowArn;
        this.thumbnail = builder.thumbnail;
        this.thumbnailMessages = builder.thumbnailMessages;
        this.timecode = builder.timecode;
        this.timestamp = builder.timestamp;
    }

    /**
     * The ARN of the flow that DescribeFlowSourceThumbnail was performed on.
     * 
     * @return The ARN of the flow that DescribeFlowSourceThumbnail was performed on.
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * Thumbnail Base64 string.
     * 
     * @return Thumbnail Base64 string.
     */
    public final String thumbnail() {
        return thumbnail;
    }

    /**
     * For responses, this returns true if the service returned a value for the ThumbnailMessages property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasThumbnailMessages() {
        return thumbnailMessages != null && !(thumbnailMessages instanceof SdkAutoConstructList);
    }

    /**
     * Status code and messages about the flow source thumbnail.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThumbnailMessages} method.
     * </p>
     * 
     * @return Status code and messages about the flow source thumbnail.
     */
    public final List<MessageDetail> thumbnailMessages() {
        return thumbnailMessages;
    }

    /**
     * Timecode of thumbnail.
     * 
     * @return Timecode of thumbnail.
     */
    public final String timecode() {
        return timecode;
    }

    /**
     * The timestamp of when thumbnail was generated.
     * 
     * @return The timestamp of when thumbnail was generated.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(thumbnail());
        hashCode = 31 * hashCode + Objects.hashCode(hasThumbnailMessages() ? thumbnailMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timecode());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThumbnailDetails)) {
            return false;
        }
        ThumbnailDetails other = (ThumbnailDetails) obj;
        return Objects.equals(flowArn(), other.flowArn()) && Objects.equals(thumbnail(), other.thumbnail())
                && hasThumbnailMessages() == other.hasThumbnailMessages()
                && Objects.equals(thumbnailMessages(), other.thumbnailMessages()) && Objects.equals(timecode(), other.timecode())
                && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThumbnailDetails").add("FlowArn", flowArn()).add("Thumbnail", thumbnail())
                .add("ThumbnailMessages", hasThumbnailMessages() ? thumbnailMessages() : null).add("Timecode", timecode())
                .add("Timestamp", timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "Thumbnail":
            return Optional.ofNullable(clazz.cast(thumbnail()));
        case "ThumbnailMessages":
            return Optional.ofNullable(clazz.cast(thumbnailMessages()));
        case "Timecode":
            return Optional.ofNullable(clazz.cast(timecode()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThumbnailDetails, T> g) {
        return obj -> g.apply((ThumbnailDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThumbnailDetails> {
        /**
         * The ARN of the flow that DescribeFlowSourceThumbnail was performed on.
         * 
         * @param flowArn
         *        The ARN of the flow that DescribeFlowSourceThumbnail was performed on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * Thumbnail Base64 string.
         * 
         * @param thumbnail
         *        Thumbnail Base64 string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnail(String thumbnail);

        /**
         * Status code and messages about the flow source thumbnail.
         * 
         * @param thumbnailMessages
         *        Status code and messages about the flow source thumbnail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnailMessages(Collection<MessageDetail> thumbnailMessages);

        /**
         * Status code and messages about the flow source thumbnail.
         * 
         * @param thumbnailMessages
         *        Status code and messages about the flow source thumbnail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnailMessages(MessageDetail... thumbnailMessages);

        /**
         * Status code and messages about the flow source thumbnail. This is a convenience method that creates an
         * instance of the {@link software.amazon.awssdk.services.mediaconnect.model.MessageDetail.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.mediaconnect.model.MessageDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.MessageDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #thumbnailMessages(List<MessageDetail>)}.
         * 
         * @param thumbnailMessages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.MessageDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thumbnailMessages(java.util.Collection<MessageDetail>)
         */
        Builder thumbnailMessages(Consumer<MessageDetail.Builder>... thumbnailMessages);

        /**
         * Timecode of thumbnail.
         * 
         * @param timecode
         *        Timecode of thumbnail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timecode(String timecode);

        /**
         * The timestamp of when thumbnail was generated.
         * 
         * @param timestamp
         *        The timestamp of when thumbnail was generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    static final class BuilderImpl implements Builder {
        private String flowArn;

        private String thumbnail;

        private List<MessageDetail> thumbnailMessages = DefaultSdkAutoConstructList.getInstance();

        private String timecode;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ThumbnailDetails model) {
            flowArn(model.flowArn);
            thumbnail(model.thumbnail);
            thumbnailMessages(model.thumbnailMessages);
            timecode(model.timecode);
            timestamp(model.timestamp);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final String getThumbnail() {
            return thumbnail;
        }

        public final void setThumbnail(String thumbnail) {
            this.thumbnail = thumbnail;
        }

        @Override
        public final Builder thumbnail(String thumbnail) {
            this.thumbnail = thumbnail;
            return this;
        }

        public final List<MessageDetail.Builder> getThumbnailMessages() {
            List<MessageDetail.Builder> result = ___listOfMessageDetailCopier.copyToBuilder(this.thumbnailMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThumbnailMessages(Collection<MessageDetail.BuilderImpl> thumbnailMessages) {
            this.thumbnailMessages = ___listOfMessageDetailCopier.copyFromBuilder(thumbnailMessages);
        }

        @Override
        public final Builder thumbnailMessages(Collection<MessageDetail> thumbnailMessages) {
            this.thumbnailMessages = ___listOfMessageDetailCopier.copy(thumbnailMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thumbnailMessages(MessageDetail... thumbnailMessages) {
            thumbnailMessages(Arrays.asList(thumbnailMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thumbnailMessages(Consumer<MessageDetail.Builder>... thumbnailMessages) {
            thumbnailMessages(Stream.of(thumbnailMessages).map(c -> MessageDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTimecode() {
            return timecode;
        }

        public final void setTimecode(String timecode) {
            this.timecode = timecode;
        }

        @Override
        public final Builder timecode(String timecode) {
            this.timecode = timecode;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public ThumbnailDetails build() {
            return new ThumbnailDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
