/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50) and
 * entitlements (up to 50).
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFlowRequest extends MediaConnectRequest implements
        ToCopyableBuilder<CreateFlowRequest.Builder, CreateFlowRequest> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(CreateFlowRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<List<GrantEntitlementRequest>> ENTITLEMENTS_FIELD = SdkField
            .<List<GrantEntitlementRequest>> builder(MarshallingType.LIST)
            .memberName("Entitlements")
            .getter(getter(CreateFlowRequest::entitlements))
            .setter(setter(Builder::entitlements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GrantEntitlementRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(GrantEntitlementRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AddMediaStreamRequest>> MEDIA_STREAMS_FIELD = SdkField
            .<List<AddMediaStreamRequest>> builder(MarshallingType.LIST)
            .memberName("MediaStreams")
            .getter(getter(CreateFlowRequest::mediaStreams))
            .setter(setter(Builder::mediaStreams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreams").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddMediaStreamRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddMediaStreamRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateFlowRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<AddOutputRequest>> OUTPUTS_FIELD = SdkField
            .<List<AddOutputRequest>> builder(MarshallingType.LIST)
            .memberName("Outputs")
            .getter(getter(CreateFlowRequest::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddOutputRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddOutputRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SetSourceRequest> SOURCE_FIELD = SdkField.<SetSourceRequest> builder(MarshallingType.SDK_POJO)
            .memberName("Source").getter(getter(CreateFlowRequest::source)).setter(setter(Builder::source))
            .constructor(SetSourceRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<FailoverConfig> SOURCE_FAILOVER_CONFIG_FIELD = SdkField
            .<FailoverConfig> builder(MarshallingType.SDK_POJO).memberName("SourceFailoverConfig")
            .getter(getter(CreateFlowRequest::sourceFailoverConfig)).setter(setter(Builder::sourceFailoverConfig))
            .constructor(FailoverConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFailoverConfig").build())
            .build();

    private static final SdkField<List<SetSourceRequest>> SOURCES_FIELD = SdkField
            .<List<SetSourceRequest>> builder(MarshallingType.LIST)
            .memberName("Sources")
            .getter(getter(CreateFlowRequest::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SetSourceRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(SetSourceRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<VpcInterfaceRequest>> VPC_INTERFACES_FIELD = SdkField
            .<List<VpcInterfaceRequest>> builder(MarshallingType.LIST)
            .memberName("VpcInterfaces")
            .getter(getter(CreateFlowRequest::vpcInterfaces))
            .setter(setter(Builder::vpcInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpcInterfaceRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcInterfaceRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AddMaintenance> MAINTENANCE_FIELD = SdkField.<AddMaintenance> builder(MarshallingType.SDK_POJO)
            .memberName("Maintenance").getter(getter(CreateFlowRequest::maintenance)).setter(setter(Builder::maintenance))
            .constructor(AddMaintenance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenance").build()).build();

    private static final SdkField<MonitoringConfig> SOURCE_MONITORING_CONFIG_FIELD = SdkField
            .<MonitoringConfig> builder(MarshallingType.SDK_POJO).memberName("SourceMonitoringConfig")
            .getter(getter(CreateFlowRequest::sourceMonitoringConfig)).setter(setter(Builder::sourceMonitoringConfig))
            .constructor(MonitoringConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceMonitoringConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            ENTITLEMENTS_FIELD, MEDIA_STREAMS_FIELD, NAME_FIELD, OUTPUTS_FIELD, SOURCE_FIELD, SOURCE_FAILOVER_CONFIG_FIELD,
            SOURCES_FIELD, VPC_INTERFACES_FIELD, MAINTENANCE_FIELD, SOURCE_MONITORING_CONFIG_FIELD));

    private final String availabilityZone;

    private final List<GrantEntitlementRequest> entitlements;

    private final List<AddMediaStreamRequest> mediaStreams;

    private final String name;

    private final List<AddOutputRequest> outputs;

    private final SetSourceRequest source;

    private final FailoverConfig sourceFailoverConfig;

    private final List<SetSourceRequest> sources;

    private final List<VpcInterfaceRequest> vpcInterfaces;

    private final AddMaintenance maintenance;

    private final MonitoringConfig sourceMonitoringConfig;

    private CreateFlowRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZone = builder.availabilityZone;
        this.entitlements = builder.entitlements;
        this.mediaStreams = builder.mediaStreams;
        this.name = builder.name;
        this.outputs = builder.outputs;
        this.source = builder.source;
        this.sourceFailoverConfig = builder.sourceFailoverConfig;
        this.sources = builder.sources;
        this.vpcInterfaces = builder.vpcInterfaces;
        this.maintenance = builder.maintenance;
        this.sourceMonitoringConfig = builder.sourceMonitoringConfig;
    }

    /**
     * The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones
     * within the current AWS Region.
     * 
     * @return The Availability Zone that you want to create the flow in. These options are limited to the Availability
     *         Zones within the current AWS Region.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entitlements property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntitlements() {
        return entitlements != null && !(entitlements instanceof SdkAutoConstructList);
    }

    /**
     * The entitlements that you want to grant on a flow.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntitlements} method.
     * </p>
     * 
     * @return The entitlements that you want to grant on a flow.
     */
    public final List<GrantEntitlementRequest> entitlements() {
        return entitlements;
    }

    /**
     * For responses, this returns true if the service returned a value for the MediaStreams property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMediaStreams() {
        return mediaStreams != null && !(mediaStreams instanceof SdkAutoConstructList);
    }

    /**
     * The media streams that you want to add to the flow. You can associate these media streams with sources and
     * outputs on the flow.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMediaStreams} method.
     * </p>
     * 
     * @return The media streams that you want to add to the flow. You can associate these media streams with sources
     *         and outputs on the flow.
     */
    public final List<AddMediaStreamRequest> mediaStreams() {
        return mediaStreams;
    }

    /**
     * The name of the flow.
     * 
     * @return The name of the flow.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * The outputs that you want to add to this flow.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return The outputs that you want to add to this flow.
     */
    public final List<AddOutputRequest> outputs() {
        return outputs;
    }

    /**
     * Returns the value of the Source property for this object.
     * 
     * @return The value of the Source property for this object.
     */
    public final SetSourceRequest source() {
        return source;
    }

    /**
     * Returns the value of the SourceFailoverConfig property for this object.
     * 
     * @return The value of the SourceFailoverConfig property for this object.
     */
    public final FailoverConfig sourceFailoverConfig() {
        return sourceFailoverConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Sources property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The value of the Sources property for this object.
     */
    public final List<SetSourceRequest> sources() {
        return sources;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcInterfaces property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcInterfaces() {
        return vpcInterfaces != null && !(vpcInterfaces instanceof SdkAutoConstructList);
    }

    /**
     * The VPC interfaces you want on the flow.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcInterfaces} method.
     * </p>
     * 
     * @return The VPC interfaces you want on the flow.
     */
    public final List<VpcInterfaceRequest> vpcInterfaces() {
        return vpcInterfaces;
    }

    /**
     * Returns the value of the Maintenance property for this object.
     * 
     * @return The value of the Maintenance property for this object.
     */
    public final AddMaintenance maintenance() {
        return maintenance;
    }

    /**
     * Returns the value of the SourceMonitoringConfig property for this object.
     * 
     * @return The value of the SourceMonitoringConfig property for this object.
     */
    public final MonitoringConfig sourceMonitoringConfig() {
        return sourceMonitoringConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntitlements() ? entitlements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMediaStreams() ? mediaStreams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFailoverConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcInterfaces() ? vpcInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maintenance());
        hashCode = 31 * hashCode + Objects.hashCode(sourceMonitoringConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFlowRequest)) {
            return false;
        }
        CreateFlowRequest other = (CreateFlowRequest) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone()) && hasEntitlements() == other.hasEntitlements()
                && Objects.equals(entitlements(), other.entitlements()) && hasMediaStreams() == other.hasMediaStreams()
                && Objects.equals(mediaStreams(), other.mediaStreams()) && Objects.equals(name(), other.name())
                && hasOutputs() == other.hasOutputs() && Objects.equals(outputs(), other.outputs())
                && Objects.equals(source(), other.source())
                && Objects.equals(sourceFailoverConfig(), other.sourceFailoverConfig()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources()) && hasVpcInterfaces() == other.hasVpcInterfaces()
                && Objects.equals(vpcInterfaces(), other.vpcInterfaces()) && Objects.equals(maintenance(), other.maintenance())
                && Objects.equals(sourceMonitoringConfig(), other.sourceMonitoringConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFlowRequest").add("AvailabilityZone", availabilityZone())
                .add("Entitlements", hasEntitlements() ? entitlements() : null)
                .add("MediaStreams", hasMediaStreams() ? mediaStreams() : null).add("Name", name())
                .add("Outputs", hasOutputs() ? outputs() : null).add("Source", source())
                .add("SourceFailoverConfig", sourceFailoverConfig()).add("Sources", hasSources() ? sources() : null)
                .add("VpcInterfaces", hasVpcInterfaces() ? vpcInterfaces() : null).add("Maintenance", maintenance())
                .add("SourceMonitoringConfig", sourceMonitoringConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "Entitlements":
            return Optional.ofNullable(clazz.cast(entitlements()));
        case "MediaStreams":
            return Optional.ofNullable(clazz.cast(mediaStreams()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "SourceFailoverConfig":
            return Optional.ofNullable(clazz.cast(sourceFailoverConfig()));
        case "Sources":
            return Optional.ofNullable(clazz.cast(sources()));
        case "VpcInterfaces":
            return Optional.ofNullable(clazz.cast(vpcInterfaces()));
        case "Maintenance":
            return Optional.ofNullable(clazz.cast(maintenance()));
        case "SourceMonitoringConfig":
            return Optional.ofNullable(clazz.cast(sourceMonitoringConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFlowRequest, T> g) {
        return obj -> g.apply((CreateFlowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFlowRequest> {
        /**
         * The Availability Zone that you want to create the flow in. These options are limited to the Availability
         * Zones within the current AWS Region.
         * 
         * @param availabilityZone
         *        The Availability Zone that you want to create the flow in. These options are limited to the
         *        Availability Zones within the current AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * The entitlements that you want to grant on a flow.
         * 
         * @param entitlements
         *        The entitlements that you want to grant on a flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(Collection<GrantEntitlementRequest> entitlements);

        /**
         * The entitlements that you want to grant on a flow.
         * 
         * @param entitlements
         *        The entitlements that you want to grant on a flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(GrantEntitlementRequest... entitlements);

        /**
         * The entitlements that you want to grant on a flow. This is a convenience method that creates an instance of
         * the {@link software.amazon.awssdk.services.mediaconnect.model.GrantEntitlementRequest.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.mediaconnect.model.GrantEntitlementRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.GrantEntitlementRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #entitlements(List<GrantEntitlementRequest>)}.
         * 
         * @param entitlements
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.GrantEntitlementRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entitlements(java.util.Collection<GrantEntitlementRequest>)
         */
        Builder entitlements(Consumer<GrantEntitlementRequest.Builder>... entitlements);

        /**
         * The media streams that you want to add to the flow. You can associate these media streams with sources and
         * outputs on the flow.
         * 
         * @param mediaStreams
         *        The media streams that you want to add to the flow. You can associate these media streams with sources
         *        and outputs on the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStreams(Collection<AddMediaStreamRequest> mediaStreams);

        /**
         * The media streams that you want to add to the flow. You can associate these media streams with sources and
         * outputs on the flow.
         * 
         * @param mediaStreams
         *        The media streams that you want to add to the flow. You can associate these media streams with sources
         *        and outputs on the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStreams(AddMediaStreamRequest... mediaStreams);

        /**
         * The media streams that you want to add to the flow. You can associate these media streams with sources and
         * outputs on the flow. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.AddMediaStreamRequest.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.mediaconnect.model.AddMediaStreamRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.AddMediaStreamRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #mediaStreams(List<AddMediaStreamRequest>)}.
         * 
         * @param mediaStreams
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.AddMediaStreamRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaStreams(java.util.Collection<AddMediaStreamRequest>)
         */
        Builder mediaStreams(Consumer<AddMediaStreamRequest.Builder>... mediaStreams);

        /**
         * The name of the flow.
         * 
         * @param name
         *        The name of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The outputs that you want to add to this flow.
         * 
         * @param outputs
         *        The outputs that you want to add to this flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<AddOutputRequest> outputs);

        /**
         * The outputs that you want to add to this flow.
         * 
         * @param outputs
         *        The outputs that you want to add to this flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(AddOutputRequest... outputs);

        /**
         * The outputs that you want to add to this flow. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.AddOutputRequest.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.mediaconnect.model.AddOutputRequest#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.AddOutputRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #outputs(List<AddOutputRequest>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.AddOutputRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(java.util.Collection<AddOutputRequest>)
         */
        Builder outputs(Consumer<AddOutputRequest.Builder>... outputs);

        /**
         * Sets the value of the Source property for this object.
         *
         * @param source
         *        The new value for the Source property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(SetSourceRequest source);

        /**
         * Sets the value of the Source property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SetSourceRequest.Builder} avoiding the
         * need to create one manually via {@link SetSourceRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SetSourceRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #source(SetSourceRequest)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link SetSourceRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(SetSourceRequest)
         */
        default Builder source(Consumer<SetSourceRequest.Builder> source) {
            return source(SetSourceRequest.builder().applyMutation(source).build());
        }

        /**
         * Sets the value of the SourceFailoverConfig property for this object.
         *
         * @param sourceFailoverConfig
         *        The new value for the SourceFailoverConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFailoverConfig(FailoverConfig sourceFailoverConfig);

        /**
         * Sets the value of the SourceFailoverConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FailoverConfig.Builder} avoiding the need
         * to create one manually via {@link FailoverConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FailoverConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceFailoverConfig(FailoverConfig)}.
         * 
         * @param sourceFailoverConfig
         *        a consumer that will call methods on {@link FailoverConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceFailoverConfig(FailoverConfig)
         */
        default Builder sourceFailoverConfig(Consumer<FailoverConfig.Builder> sourceFailoverConfig) {
            return sourceFailoverConfig(FailoverConfig.builder().applyMutation(sourceFailoverConfig).build());
        }

        /**
         * Sets the value of the Sources property for this object.
         *
         * @param sources
         *        The new value for the Sources property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<SetSourceRequest> sources);

        /**
         * Sets the value of the Sources property for this object.
         *
         * @param sources
         *        The new value for the Sources property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(SetSourceRequest... sources);

        /**
         * Sets the value of the Sources property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.SetSourceRequest.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.mediaconnect.model.SetSourceRequest#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.SetSourceRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #sources(List<SetSourceRequest>)}.
         * 
         * @param sources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.SetSourceRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(java.util.Collection<SetSourceRequest>)
         */
        Builder sources(Consumer<SetSourceRequest.Builder>... sources);

        /**
         * The VPC interfaces you want on the flow.
         * 
         * @param vpcInterfaces
         *        The VPC interfaces you want on the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcInterfaces(Collection<VpcInterfaceRequest> vpcInterfaces);

        /**
         * The VPC interfaces you want on the flow.
         * 
         * @param vpcInterfaces
         *        The VPC interfaces you want on the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcInterfaces(VpcInterfaceRequest... vpcInterfaces);

        /**
         * The VPC interfaces you want on the flow. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.VpcInterfaceRequest.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.mediaconnect.model.VpcInterfaceRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.VpcInterfaceRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcInterfaces(List<VpcInterfaceRequest>)}.
         * 
         * @param vpcInterfaces
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.VpcInterfaceRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcInterfaces(java.util.Collection<VpcInterfaceRequest>)
         */
        Builder vpcInterfaces(Consumer<VpcInterfaceRequest.Builder>... vpcInterfaces);

        /**
         * Sets the value of the Maintenance property for this object.
         *
         * @param maintenance
         *        The new value for the Maintenance property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenance(AddMaintenance maintenance);

        /**
         * Sets the value of the Maintenance property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AddMaintenance.Builder} avoiding the need
         * to create one manually via {@link AddMaintenance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AddMaintenance.Builder#build()} is called immediately and its
         * result is passed to {@link #maintenance(AddMaintenance)}.
         * 
         * @param maintenance
         *        a consumer that will call methods on {@link AddMaintenance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenance(AddMaintenance)
         */
        default Builder maintenance(Consumer<AddMaintenance.Builder> maintenance) {
            return maintenance(AddMaintenance.builder().applyMutation(maintenance).build());
        }

        /**
         * Sets the value of the SourceMonitoringConfig property for this object.
         *
         * @param sourceMonitoringConfig
         *        The new value for the SourceMonitoringConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceMonitoringConfig(MonitoringConfig sourceMonitoringConfig);

        /**
         * Sets the value of the SourceMonitoringConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MonitoringConfig.Builder} avoiding the
         * need to create one manually via {@link MonitoringConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceMonitoringConfig(MonitoringConfig)}.
         * 
         * @param sourceMonitoringConfig
         *        a consumer that will call methods on {@link MonitoringConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceMonitoringConfig(MonitoringConfig)
         */
        default Builder sourceMonitoringConfig(Consumer<MonitoringConfig.Builder> sourceMonitoringConfig) {
            return sourceMonitoringConfig(MonitoringConfig.builder().applyMutation(sourceMonitoringConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConnectRequest.BuilderImpl implements Builder {
        private String availabilityZone;

        private List<GrantEntitlementRequest> entitlements = DefaultSdkAutoConstructList.getInstance();

        private List<AddMediaStreamRequest> mediaStreams = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private List<AddOutputRequest> outputs = DefaultSdkAutoConstructList.getInstance();

        private SetSourceRequest source;

        private FailoverConfig sourceFailoverConfig;

        private List<SetSourceRequest> sources = DefaultSdkAutoConstructList.getInstance();

        private List<VpcInterfaceRequest> vpcInterfaces = DefaultSdkAutoConstructList.getInstance();

        private AddMaintenance maintenance;

        private MonitoringConfig sourceMonitoringConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFlowRequest model) {
            super(model);
            availabilityZone(model.availabilityZone);
            entitlements(model.entitlements);
            mediaStreams(model.mediaStreams);
            name(model.name);
            outputs(model.outputs);
            source(model.source);
            sourceFailoverConfig(model.sourceFailoverConfig);
            sources(model.sources);
            vpcInterfaces(model.vpcInterfaces);
            maintenance(model.maintenance);
            sourceMonitoringConfig(model.sourceMonitoringConfig);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final List<GrantEntitlementRequest.Builder> getEntitlements() {
            List<GrantEntitlementRequest.Builder> result = ___listOfGrantEntitlementRequestCopier
                    .copyToBuilder(this.entitlements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntitlements(Collection<GrantEntitlementRequest.BuilderImpl> entitlements) {
            this.entitlements = ___listOfGrantEntitlementRequestCopier.copyFromBuilder(entitlements);
        }

        @Override
        public final Builder entitlements(Collection<GrantEntitlementRequest> entitlements) {
            this.entitlements = ___listOfGrantEntitlementRequestCopier.copy(entitlements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(GrantEntitlementRequest... entitlements) {
            entitlements(Arrays.asList(entitlements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Consumer<GrantEntitlementRequest.Builder>... entitlements) {
            entitlements(Stream.of(entitlements).map(c -> GrantEntitlementRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AddMediaStreamRequest.Builder> getMediaStreams() {
            List<AddMediaStreamRequest.Builder> result = ___listOfAddMediaStreamRequestCopier.copyToBuilder(this.mediaStreams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaStreams(Collection<AddMediaStreamRequest.BuilderImpl> mediaStreams) {
            this.mediaStreams = ___listOfAddMediaStreamRequestCopier.copyFromBuilder(mediaStreams);
        }

        @Override
        public final Builder mediaStreams(Collection<AddMediaStreamRequest> mediaStreams) {
            this.mediaStreams = ___listOfAddMediaStreamRequestCopier.copy(mediaStreams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaStreams(AddMediaStreamRequest... mediaStreams) {
            mediaStreams(Arrays.asList(mediaStreams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaStreams(Consumer<AddMediaStreamRequest.Builder>... mediaStreams) {
            mediaStreams(Stream.of(mediaStreams).map(c -> AddMediaStreamRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<AddOutputRequest.Builder> getOutputs() {
            List<AddOutputRequest.Builder> result = ___listOfAddOutputRequestCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<AddOutputRequest.BuilderImpl> outputs) {
            this.outputs = ___listOfAddOutputRequestCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<AddOutputRequest> outputs) {
            this.outputs = ___listOfAddOutputRequestCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(AddOutputRequest... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<AddOutputRequest.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> AddOutputRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final SetSourceRequest.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(SetSourceRequest.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(SetSourceRequest source) {
            this.source = source;
            return this;
        }

        public final FailoverConfig.Builder getSourceFailoverConfig() {
            return sourceFailoverConfig != null ? sourceFailoverConfig.toBuilder() : null;
        }

        public final void setSourceFailoverConfig(FailoverConfig.BuilderImpl sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig != null ? sourceFailoverConfig.build() : null;
        }

        @Override
        public final Builder sourceFailoverConfig(FailoverConfig sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig;
            return this;
        }

        public final List<SetSourceRequest.Builder> getSources() {
            List<SetSourceRequest.Builder> result = ___listOfSetSourceRequestCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<SetSourceRequest.BuilderImpl> sources) {
            this.sources = ___listOfSetSourceRequestCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<SetSourceRequest> sources) {
            this.sources = ___listOfSetSourceRequestCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(SetSourceRequest... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<SetSourceRequest.Builder>... sources) {
            sources(Stream.of(sources).map(c -> SetSourceRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<VpcInterfaceRequest.Builder> getVpcInterfaces() {
            List<VpcInterfaceRequest.Builder> result = ___listOfVpcInterfaceRequestCopier.copyToBuilder(this.vpcInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcInterfaces(Collection<VpcInterfaceRequest.BuilderImpl> vpcInterfaces) {
            this.vpcInterfaces = ___listOfVpcInterfaceRequestCopier.copyFromBuilder(vpcInterfaces);
        }

        @Override
        public final Builder vpcInterfaces(Collection<VpcInterfaceRequest> vpcInterfaces) {
            this.vpcInterfaces = ___listOfVpcInterfaceRequestCopier.copy(vpcInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcInterfaces(VpcInterfaceRequest... vpcInterfaces) {
            vpcInterfaces(Arrays.asList(vpcInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcInterfaces(Consumer<VpcInterfaceRequest.Builder>... vpcInterfaces) {
            vpcInterfaces(Stream.of(vpcInterfaces).map(c -> VpcInterfaceRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AddMaintenance.Builder getMaintenance() {
            return maintenance != null ? maintenance.toBuilder() : null;
        }

        public final void setMaintenance(AddMaintenance.BuilderImpl maintenance) {
            this.maintenance = maintenance != null ? maintenance.build() : null;
        }

        @Override
        public final Builder maintenance(AddMaintenance maintenance) {
            this.maintenance = maintenance;
            return this;
        }

        public final MonitoringConfig.Builder getSourceMonitoringConfig() {
            return sourceMonitoringConfig != null ? sourceMonitoringConfig.toBuilder() : null;
        }

        public final void setSourceMonitoringConfig(MonitoringConfig.BuilderImpl sourceMonitoringConfig) {
            this.sourceMonitoringConfig = sourceMonitoringConfig != null ? sourceMonitoringConfig.build() : null;
        }

        @Override
        public final Builder sourceMonitoringConfig(MonitoringConfig sourceMonitoringConfig) {
            this.sourceMonitoringConfig = sourceMonitoringConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFlowRequest build() {
            return new CreateFlowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
