/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoveBridgeOutputResponse extends MediaConnectResponse implements
        ToCopyableBuilder<RemoveBridgeOutputResponse.Builder, RemoveBridgeOutputResponse> {
    private static final SdkField<String> BRIDGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BridgeArn").getter(getter(RemoveBridgeOutputResponse::bridgeArn)).setter(setter(Builder::bridgeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgeArn").build()).build();

    private static final SdkField<String> OUTPUT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputName").getter(getter(RemoveBridgeOutputResponse::outputName)).setter(setter(Builder::outputName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIDGE_ARN_FIELD,
            OUTPUT_NAME_FIELD));

    private final String bridgeArn;

    private final String outputName;

    private RemoveBridgeOutputResponse(BuilderImpl builder) {
        super(builder);
        this.bridgeArn = builder.bridgeArn;
        this.outputName = builder.outputName;
    }

    /**
     * Returns the value of the BridgeArn property for this object.
     * 
     * @return The value of the BridgeArn property for this object.
     */
    public final String bridgeArn() {
        return bridgeArn;
    }

    /**
     * Returns the value of the OutputName property for this object.
     * 
     * @return The value of the OutputName property for this object.
     */
    public final String outputName() {
        return outputName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bridgeArn());
        hashCode = 31 * hashCode + Objects.hashCode(outputName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveBridgeOutputResponse)) {
            return false;
        }
        RemoveBridgeOutputResponse other = (RemoveBridgeOutputResponse) obj;
        return Objects.equals(bridgeArn(), other.bridgeArn()) && Objects.equals(outputName(), other.outputName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemoveBridgeOutputResponse").add("BridgeArn", bridgeArn()).add("OutputName", outputName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BridgeArn":
            return Optional.ofNullable(clazz.cast(bridgeArn()));
        case "OutputName":
            return Optional.ofNullable(clazz.cast(outputName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveBridgeOutputResponse, T> g) {
        return obj -> g.apply((RemoveBridgeOutputResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, RemoveBridgeOutputResponse> {
        /**
         * Sets the value of the BridgeArn property for this object.
         *
         * @param bridgeArn
         *        The new value for the BridgeArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bridgeArn(String bridgeArn);

        /**
         * Sets the value of the OutputName property for this object.
         *
         * @param outputName
         *        The new value for the OutputName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputName(String outputName);
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private String bridgeArn;

        private String outputName;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveBridgeOutputResponse model) {
            super(model);
            bridgeArn(model.bridgeArn);
            outputName(model.outputName);
        }

        public final String getBridgeArn() {
            return bridgeArn;
        }

        public final void setBridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
        }

        @Override
        public final Builder bridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
            return this;
        }

        public final String getOutputName() {
            return outputName;
        }

        public final void setOutputName(String outputName) {
            this.outputName = outputName;
        }

        @Override
        public final Builder outputName(String outputName) {
            this.outputName = outputName;
            return this;
        }

        @Override
        public RemoveBridgeOutputResponse build() {
            return new RemoveBridgeOutputResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
